/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.schemas.model.SchemasResponse;
import software.amazon.awssdk.services.schemas.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSchemaResponse
extends SchemasResponse
implements ToCopyableBuilder<Builder, UpdateSchemaResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateSchemaResponse.getter(UpdateSchemaResponse::description)).setter(UpdateSchemaResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(UpdateSchemaResponse.getter(UpdateSchemaResponse::lastModified)).setter(UpdateSchemaResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaArn").getter(UpdateSchemaResponse.getter(UpdateSchemaResponse::schemaArn)).setter(UpdateSchemaResponse.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()}).build();
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaName").getter(UpdateSchemaResponse.getter(UpdateSchemaResponse::schemaName)).setter(UpdateSchemaResponse.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaVersion").getter(UpdateSchemaResponse.getter(UpdateSchemaResponse::schemaVersion)).setter(UpdateSchemaResponse.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersion").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(UpdateSchemaResponse.getter(UpdateSchemaResponse::tags)).setter(UpdateSchemaResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(UpdateSchemaResponse.getter(UpdateSchemaResponse::type)).setter(UpdateSchemaResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Instant> VERSION_CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("VersionCreatedDate").getter(UpdateSchemaResponse.getter(UpdateSchemaResponse::versionCreatedDate)).setter(UpdateSchemaResponse.setter(Builder::versionCreatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionCreatedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, LAST_MODIFIED_FIELD, SCHEMA_ARN_FIELD, SCHEMA_NAME_FIELD, SCHEMA_VERSION_FIELD, TAGS_FIELD, TYPE_FIELD, VERSION_CREATED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSchemaResponse.memberNameToFieldInitializer();
    private final String description;
    private final Instant lastModified;
    private final String schemaArn;
    private final String schemaName;
    private final String schemaVersion;
    private final Map<String, String> tags;
    private final String type;
    private final Instant versionCreatedDate;

    private UpdateSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.lastModified = builder.lastModified;
        this.schemaArn = builder.schemaArn;
        this.schemaName = builder.schemaName;
        this.schemaVersion = builder.schemaVersion;
        this.tags = builder.tags;
        this.type = builder.type;
        this.versionCreatedDate = builder.versionCreatedDate;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final String schemaArn() {
        return this.schemaArn;
    }

    public final String schemaName() {
        return this.schemaName;
    }

    public final String schemaVersion() {
        return this.schemaVersion;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String type() {
        return this.type;
    }

    public final Instant versionCreatedDate() {
        return this.versionCreatedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionCreatedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSchemaResponse)) {
            return false;
        }
        UpdateSchemaResponse other = (UpdateSchemaResponse)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.schemaName(), other.schemaName()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.versionCreatedDate(), other.versionCreatedDate());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSchemaResponse").add("Description", (Object)this.description()).add("LastModified", (Object)this.lastModified()).add("SchemaArn", (Object)this.schemaArn()).add("SchemaName", (Object)this.schemaName()).add("SchemaVersion", (Object)this.schemaVersion()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.type()).add("VersionCreatedDate", (Object)this.versionCreatedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "SchemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "SchemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "SchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "VersionCreatedDate": {
                return Optional.ofNullable(clazz.cast(this.versionCreatedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("LastModified", LAST_MODIFIED_FIELD);
        map.put("SchemaArn", SCHEMA_ARN_FIELD);
        map.put("SchemaName", SCHEMA_NAME_FIELD);
        map.put("SchemaVersion", SCHEMA_VERSION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("VersionCreatedDate", VERSION_CREATED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSchemaResponse, T> g) {
        return obj -> g.apply((UpdateSchemaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasResponse.BuilderImpl
    implements Builder {
        private String description;
        private Instant lastModified;
        private String schemaArn;
        private String schemaName;
        private String schemaVersion;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;
        private Instant versionCreatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSchemaResponse model) {
            super(model);
            this.description(model.description);
            this.lastModified(model.lastModified);
            this.schemaArn(model.schemaArn);
            this.schemaName(model.schemaName);
            this.schemaVersion(model.schemaVersion);
            this.tags(model.tags);
            this.type(model.type);
            this.versionCreatedDate(model.versionCreatedDate);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getVersionCreatedDate() {
            return this.versionCreatedDate;
        }

        public final void setVersionCreatedDate(Instant versionCreatedDate) {
            this.versionCreatedDate = versionCreatedDate;
        }

        @Override
        public final Builder versionCreatedDate(Instant versionCreatedDate) {
            this.versionCreatedDate = versionCreatedDate;
            return this;
        }

        @Override
        public UpdateSchemaResponse build() {
            return new UpdateSchemaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SchemasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSchemaResponse> {
        public Builder description(String var1);

        public Builder lastModified(Instant var1);

        public Builder schemaArn(String var1);

        public Builder schemaName(String var1);

        public Builder schemaVersion(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder versionCreatedDate(Instant var1);
    }
}

