/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSchemaRequest extends SchemasRequest implements
        ToCopyableBuilder<CreateSchemaRequest.Builder, CreateSchemaRequest> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(CreateSchemaRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateSchemaRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistryName").getter(getter(CreateSchemaRequest::registryName)).setter(setter(Builder::registryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("registryName").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaName").getter(getter(CreateSchemaRequest::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("schemaName").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateSchemaRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateSchemaRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            DESCRIPTION_FIELD, REGISTRY_NAME_FIELD, SCHEMA_NAME_FIELD, TAGS_FIELD, TYPE_FIELD));

    private final String content;

    private final String description;

    private final String registryName;

    private final String schemaName;

    private final Map<String, String> tags;

    private final String type;

    private CreateSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.description = builder.description;
        this.registryName = builder.registryName;
        this.schemaName = builder.schemaName;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * The source of the schema definition.
     * </p>
     * 
     * @return The source of the schema definition.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * A description of the schema.
     * </p>
     * 
     * @return A description of the schema.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the registry.
     * </p>
     * 
     * @return The name of the registry.
     */
    public final String registryName() {
        return registryName;
    }

    /**
     * <p>
     * The name of the schema.
     * </p>
     * 
     * @return The name of the schema.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags associated with the schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags associated with the schema.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of schema.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The type of schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of schema.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(registryName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSchemaRequest)) {
            return false;
        }
        CreateSchemaRequest other = (CreateSchemaRequest) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(description(), other.description())
                && Objects.equals(registryName(), other.registryName()) && Objects.equals(schemaName(), other.schemaName())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSchemaRequest").add("Content", content()).add("Description", description())
                .add("RegistryName", registryName()).add("SchemaName", schemaName()).add("Tags", hasTags() ? tags() : null)
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RegistryName":
            return Optional.ofNullable(clazz.cast(registryName()));
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSchemaRequest, T> g) {
        return obj -> g.apply((CreateSchemaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSchemaRequest> {
        /**
         * <p>
         * The source of the schema definition.
         * </p>
         * 
         * @param content
         *        The source of the schema definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * A description of the schema.
         * </p>
         * 
         * @param description
         *        A description of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the registry.
         * </p>
         * 
         * @param registryName
         *        The name of the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryName(String registryName);

        /**
         * <p>
         * The name of the schema.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * Tags associated with the schema.
         * </p>
         * 
         * @param tags
         *        Tags associated with the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The type of schema.
         * </p>
         * 
         * @param type
         *        The type of schema.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The type of schema.
         * </p>
         * 
         * @param type
         *        The type of schema.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SchemasRequest.BuilderImpl implements Builder {
        private String content;

        private String description;

        private String registryName;

        private String schemaName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSchemaRequest model) {
            super(model);
            content(model.content);
            description(model.description);
            registryName(model.registryName);
            schemaName(model.schemaName);
            tags(model.tags);
            type(model.type);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRegistryName() {
            return registryName;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSchemaRequest build() {
            return new CreateSchemaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
