/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.schemas.model.BadRequestException;
import software.amazon.awssdk.services.schemas.model.ConflictException;
import software.amazon.awssdk.services.schemas.model.CreateDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.CreateDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.CreateRegistryRequest;
import software.amazon.awssdk.services.schemas.model.CreateRegistryResponse;
import software.amazon.awssdk.services.schemas.model.CreateSchemaRequest;
import software.amazon.awssdk.services.schemas.model.CreateSchemaResponse;
import software.amazon.awssdk.services.schemas.model.DeleteDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.DeleteDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.DeleteRegistryRequest;
import software.amazon.awssdk.services.schemas.model.DeleteRegistryResponse;
import software.amazon.awssdk.services.schemas.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.schemas.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.schemas.model.DeleteSchemaRequest;
import software.amazon.awssdk.services.schemas.model.DeleteSchemaResponse;
import software.amazon.awssdk.services.schemas.model.DeleteSchemaVersionRequest;
import software.amazon.awssdk.services.schemas.model.DeleteSchemaVersionResponse;
import software.amazon.awssdk.services.schemas.model.DescribeCodeBindingRequest;
import software.amazon.awssdk.services.schemas.model.DescribeCodeBindingResponse;
import software.amazon.awssdk.services.schemas.model.DescribeDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.DescribeDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.DescribeRegistryRequest;
import software.amazon.awssdk.services.schemas.model.DescribeRegistryResponse;
import software.amazon.awssdk.services.schemas.model.DescribeSchemaRequest;
import software.amazon.awssdk.services.schemas.model.DescribeSchemaResponse;
import software.amazon.awssdk.services.schemas.model.ExportSchemaRequest;
import software.amazon.awssdk.services.schemas.model.ExportSchemaResponse;
import software.amazon.awssdk.services.schemas.model.ForbiddenException;
import software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceRequest;
import software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceResponse;
import software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaRequest;
import software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaResponse;
import software.amazon.awssdk.services.schemas.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.schemas.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.schemas.model.GoneException;
import software.amazon.awssdk.services.schemas.model.InternalServerErrorException;
import software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest;
import software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse;
import software.amazon.awssdk.services.schemas.model.ListRegistriesRequest;
import software.amazon.awssdk.services.schemas.model.ListRegistriesResponse;
import software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest;
import software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse;
import software.amazon.awssdk.services.schemas.model.ListSchemasRequest;
import software.amazon.awssdk.services.schemas.model.ListSchemasResponse;
import software.amazon.awssdk.services.schemas.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.schemas.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.schemas.model.NotFoundException;
import software.amazon.awssdk.services.schemas.model.PreconditionFailedException;
import software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest;
import software.amazon.awssdk.services.schemas.model.PutCodeBindingResponse;
import software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.schemas.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.schemas.model.SchemasException;
import software.amazon.awssdk.services.schemas.model.SearchSchemasRequest;
import software.amazon.awssdk.services.schemas.model.SearchSchemasResponse;
import software.amazon.awssdk.services.schemas.model.ServiceUnavailableException;
import software.amazon.awssdk.services.schemas.model.StartDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.StartDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.StopDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.StopDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.TagResourceRequest;
import software.amazon.awssdk.services.schemas.model.TagResourceResponse;
import software.amazon.awssdk.services.schemas.model.TooManyRequestsException;
import software.amazon.awssdk.services.schemas.model.UnauthorizedException;
import software.amazon.awssdk.services.schemas.model.UntagResourceRequest;
import software.amazon.awssdk.services.schemas.model.UntagResourceResponse;
import software.amazon.awssdk.services.schemas.model.UpdateDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.UpdateDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.UpdateRegistryRequest;
import software.amazon.awssdk.services.schemas.model.UpdateRegistryResponse;
import software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest;
import software.amazon.awssdk.services.schemas.model.UpdateSchemaResponse;
import software.amazon.awssdk.services.schemas.paginators.ListDiscoverersIterable;
import software.amazon.awssdk.services.schemas.paginators.ListRegistriesIterable;
import software.amazon.awssdk.services.schemas.paginators.ListSchemaVersionsIterable;
import software.amazon.awssdk.services.schemas.paginators.ListSchemasIterable;
import software.amazon.awssdk.services.schemas.paginators.SearchSchemasIterable;
import software.amazon.awssdk.services.schemas.waiters.SchemasWaiter;

/**
 * Service client for accessing Schemas. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon EventBridge Schema Registry
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SchemasClient extends SdkClient {
    String SERVICE_NAME = "schemas";

    /**
     * Create a {@link SchemasClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SchemasClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SchemasClient}.
     */
    static SchemasClientBuilder builder() {
        return new DefaultSchemasClientBuilder();
    }

    /**
     * <p>
     * Creates a discoverer.
     * </p>
     *
     * @param createDiscovererRequest
     * @return Result of the CreateDiscoverer operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws UnauthorizedException
     *         401 response
     * @throws ForbiddenException
     *         403 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.CreateDiscoverer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDiscovererResponse createDiscoverer(CreateDiscovererRequest createDiscovererRequest)
            throws BadRequestException, InternalServerErrorException, UnauthorizedException, ForbiddenException,
            ServiceUnavailableException, ConflictException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a discoverer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDiscovererRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDiscovererRequest#builder()}
     * </p>
     *
     * @param createDiscovererRequest
     *        A {@link Consumer} that will call methods on {@link CreateDiscovererRequest.Builder} to create a request.
     * @return Result of the CreateDiscoverer operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws UnauthorizedException
     *         401 response
     * @throws ForbiddenException
     *         403 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.CreateDiscoverer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDiscovererResponse createDiscoverer(Consumer<CreateDiscovererRequest.Builder> createDiscovererRequest)
            throws BadRequestException, InternalServerErrorException, UnauthorizedException, ForbiddenException,
            ServiceUnavailableException, ConflictException, AwsServiceException, SdkClientException, SchemasException {
        return createDiscoverer(CreateDiscovererRequest.builder().applyMutation(createDiscovererRequest).build());
    }

    /**
     * <p>
     * Creates a registry.
     * </p>
     *
     * @param createRegistryRequest
     * @return Result of the CreateRegistry operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws UnauthorizedException
     *         401 response
     * @throws ForbiddenException
     *         403 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.CreateRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRegistryResponse createRegistry(CreateRegistryRequest createRegistryRequest) throws BadRequestException,
            InternalServerErrorException, UnauthorizedException, ForbiddenException, ServiceUnavailableException,
            ConflictException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegistryRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRegistryRequest#builder()}
     * </p>
     *
     * @param createRegistryRequest
     *        A {@link Consumer} that will call methods on {@link CreateRegistryRequest.Builder} to create a request.
     * @return Result of the CreateRegistry operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws UnauthorizedException
     *         401 response
     * @throws ForbiddenException
     *         403 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws ConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.CreateRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRegistryResponse createRegistry(Consumer<CreateRegistryRequest.Builder> createRegistryRequest)
            throws BadRequestException, InternalServerErrorException, UnauthorizedException, ForbiddenException,
            ServiceUnavailableException, ConflictException, AwsServiceException, SdkClientException, SchemasException {
        return createRegistry(CreateRegistryRequest.builder().applyMutation(createRegistryRequest).build());
    }

    /**
     * <p>
     * Creates a schema definition.
     * </p>
     * <note>
     * <p>
     * Inactive schemas will be deleted after two years.
     * </p>
     * </note>
     *
     * @param createSchemaRequest
     * @return Result of the CreateSchema operation returned by the service.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.CreateSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSchemaResponse createSchema(CreateSchemaRequest createSchemaRequest) throws ServiceUnavailableException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a schema definition.
     * </p>
     * <note>
     * <p>
     * Inactive schemas will be deleted after two years.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSchemaRequest#builder()}
     * </p>
     *
     * @param createSchemaRequest
     *        A {@link Consumer} that will call methods on {@link CreateSchemaRequest.Builder} to create a request.
     * @return Result of the CreateSchema operation returned by the service.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.CreateSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSchemaResponse createSchema(Consumer<CreateSchemaRequest.Builder> createSchemaRequest)
            throws ServiceUnavailableException, BadRequestException, InternalServerErrorException, ForbiddenException,
            AwsServiceException, SdkClientException, SchemasException {
        return createSchema(CreateSchemaRequest.builder().applyMutation(createSchemaRequest).build());
    }

    /**
     * <p>
     * Deletes a discoverer.
     * </p>
     *
     * @param deleteDiscovererRequest
     * @return Result of the DeleteDiscoverer operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DeleteDiscoverer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDiscovererResponse deleteDiscoverer(DeleteDiscovererRequest deleteDiscovererRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a discoverer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDiscovererRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDiscovererRequest#builder()}
     * </p>
     *
     * @param deleteDiscovererRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDiscovererRequest.Builder} to create a request.
     * @return Result of the DeleteDiscoverer operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DeleteDiscoverer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDiscovererResponse deleteDiscoverer(Consumer<DeleteDiscovererRequest.Builder> deleteDiscovererRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return deleteDiscoverer(DeleteDiscovererRequest.builder().applyMutation(deleteDiscovererRequest).build());
    }

    /**
     * <p>
     * Deletes a Registry.
     * </p>
     *
     * @param deleteRegistryRequest
     * @return Result of the DeleteRegistry operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DeleteRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRegistryResponse deleteRegistry(DeleteRegistryRequest deleteRegistryRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegistryRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRegistryRequest#builder()}
     * </p>
     *
     * @param deleteRegistryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRegistryRequest.Builder} to create a request.
     * @return Result of the DeleteRegistry operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DeleteRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRegistryResponse deleteRegistry(Consumer<DeleteRegistryRequest.Builder> deleteRegistryRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return deleteRegistry(DeleteRegistryRequest.builder().applyMutation(deleteRegistryRequest).build());
    }

    /**
     * <p>
     * Delete the resource-based policy attached to the specified registry.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DeleteResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the resource-based policy attached to the specified registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DeleteResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Delete a schema definition.
     * </p>
     *
     * @param deleteSchemaRequest
     * @return Result of the DeleteSchema operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DeleteSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSchemaResponse deleteSchema(DeleteSchemaRequest deleteSchemaRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a schema definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSchemaRequest#builder()}
     * </p>
     *
     * @param deleteSchemaRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSchemaRequest.Builder} to create a request.
     * @return Result of the DeleteSchema operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DeleteSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSchemaResponse deleteSchema(Consumer<DeleteSchemaRequest.Builder> deleteSchemaRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return deleteSchema(DeleteSchemaRequest.builder().applyMutation(deleteSchemaRequest).build());
    }

    /**
     * <p>
     * Delete the schema version definition
     * </p>
     *
     * @param deleteSchemaVersionRequest
     * @return Result of the DeleteSchemaVersion operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DeleteSchemaVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteSchemaVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSchemaVersionResponse deleteSchemaVersion(DeleteSchemaVersionRequest deleteSchemaVersionRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the schema version definition
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSchemaVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSchemaVersionRequest#builder()}
     * </p>
     *
     * @param deleteSchemaVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSchemaVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSchemaVersion operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DeleteSchemaVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteSchemaVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSchemaVersionResponse deleteSchemaVersion(
            Consumer<DeleteSchemaVersionRequest.Builder> deleteSchemaVersionRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return deleteSchemaVersion(DeleteSchemaVersionRequest.builder().applyMutation(deleteSchemaVersionRequest).build());
    }

    /**
     * <p>
     * Describe the code binding URI.
     * </p>
     *
     * @param describeCodeBindingRequest
     * @return Result of the DescribeCodeBinding operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DescribeCodeBinding
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeCodeBinding" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeCodeBindingResponse describeCodeBinding(DescribeCodeBindingRequest describeCodeBindingRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe the code binding URI.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCodeBindingRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCodeBindingRequest#builder()}
     * </p>
     *
     * @param describeCodeBindingRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCodeBindingRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeCodeBinding operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DescribeCodeBinding
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeCodeBinding" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeCodeBindingResponse describeCodeBinding(
            Consumer<DescribeCodeBindingRequest.Builder> describeCodeBindingRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, SchemasException {
        return describeCodeBinding(DescribeCodeBindingRequest.builder().applyMutation(describeCodeBindingRequest).build());
    }

    /**
     * <p>
     * Describes the discoverer.
     * </p>
     *
     * @param describeDiscovererRequest
     * @return Result of the DescribeDiscoverer operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DescribeDiscoverer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDiscovererResponse describeDiscoverer(DescribeDiscovererRequest describeDiscovererRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the discoverer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDiscovererRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDiscovererRequest#builder()}
     * </p>
     *
     * @param describeDiscovererRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDiscovererRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDiscoverer operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DescribeDiscoverer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDiscovererResponse describeDiscoverer(Consumer<DescribeDiscovererRequest.Builder> describeDiscovererRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return describeDiscoverer(DescribeDiscovererRequest.builder().applyMutation(describeDiscovererRequest).build());
    }

    /**
     * <p>
     * Describes the registry.
     * </p>
     *
     * @param describeRegistryRequest
     * @return Result of the DescribeRegistry operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DescribeRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRegistryResponse describeRegistry(DescribeRegistryRequest describeRegistryRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistryRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeRegistryRequest#builder()}
     * </p>
     *
     * @param describeRegistryRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRegistryRequest.Builder} to create a request.
     * @return Result of the DescribeRegistry operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DescribeRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRegistryResponse describeRegistry(Consumer<DescribeRegistryRequest.Builder> describeRegistryRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return describeRegistry(DescribeRegistryRequest.builder().applyMutation(describeRegistryRequest).build());
    }

    /**
     * <p>
     * Retrieve the schema definition.
     * </p>
     *
     * @param describeSchemaRequest
     * @return Result of the DescribeSchema operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DescribeSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSchemaResponse describeSchema(DescribeSchemaRequest describeSchemaRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the schema definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeSchemaRequest#builder()}
     * </p>
     *
     * @param describeSchemaRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSchemaRequest.Builder} to create a request.
     * @return Result of the DescribeSchema operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.DescribeSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSchemaResponse describeSchema(Consumer<DescribeSchemaRequest.Builder> describeSchemaRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return describeSchema(DescribeSchemaRequest.builder().applyMutation(describeSchemaRequest).build());
    }

    /**
     * Invokes the ExportSchema operation.
     *
     * @param exportSchemaRequest
     * @return Result of the ExportSchema operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ExportSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ExportSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default ExportSchemaResponse exportSchema(ExportSchemaRequest exportSchemaRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the ExportSchema operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link ExportSchemaRequest#builder()}
     * </p>
     *
     * @param exportSchemaRequest
     *        A {@link Consumer} that will call methods on {@link ExportSchemaRequest.Builder} to create a request.
     * @return Result of the ExportSchema operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ExportSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ExportSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default ExportSchemaResponse exportSchema(Consumer<ExportSchemaRequest.Builder> exportSchemaRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            SchemasException {
        return exportSchema(ExportSchemaRequest.builder().applyMutation(exportSchemaRequest).build());
    }

    /**
     * <p>
     * Get the code binding source URI.
     * </p>
     *
     * @param getCodeBindingSourceRequest
     * @return Result of the GetCodeBindingSource operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.GetCodeBindingSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetCodeBindingSource" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCodeBindingSourceResponse getCodeBindingSource(GetCodeBindingSourceRequest getCodeBindingSourceRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the code binding source URI.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCodeBindingSourceRequest.Builder} avoiding the
     * need to create one manually via {@link GetCodeBindingSourceRequest#builder()}
     * </p>
     *
     * @param getCodeBindingSourceRequest
     *        A {@link Consumer} that will call methods on {@link GetCodeBindingSourceRequest.Builder} to create a
     *        request.
     * @return Result of the GetCodeBindingSource operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.GetCodeBindingSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetCodeBindingSource" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCodeBindingSourceResponse getCodeBindingSource(
            Consumer<GetCodeBindingSourceRequest.Builder> getCodeBindingSourceRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, SchemasException {
        return getCodeBindingSource(GetCodeBindingSourceRequest.builder().applyMutation(getCodeBindingSourceRequest).build());
    }

    /**
     * <p>
     * Get the discovered schema that was generated based on sampled events.
     * </p>
     *
     * @param getDiscoveredSchemaRequest
     * @return Result of the GetDiscoveredSchema operation returned by the service.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.GetDiscoveredSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetDiscoveredSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDiscoveredSchemaResponse getDiscoveredSchema(GetDiscoveredSchemaRequest getDiscoveredSchemaRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the discovered schema that was generated based on sampled events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiscoveredSchemaRequest.Builder} avoiding the
     * need to create one manually via {@link GetDiscoveredSchemaRequest#builder()}
     * </p>
     *
     * @param getDiscoveredSchemaRequest
     *        A {@link Consumer} that will call methods on {@link GetDiscoveredSchemaRequest.Builder} to create a
     *        request.
     * @return Result of the GetDiscoveredSchema operation returned by the service.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.GetDiscoveredSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetDiscoveredSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDiscoveredSchemaResponse getDiscoveredSchema(
            Consumer<GetDiscoveredSchemaRequest.Builder> getDiscoveredSchemaRequest) throws ServiceUnavailableException,
            BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, SchemasException {
        return getDiscoveredSchema(GetDiscoveredSchemaRequest.builder().applyMutation(getDiscoveredSchemaRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource-based policy attached to a given registry.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.GetResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource-based policy attached to a given registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePolicyRequest.Builder} to create a request.
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.GetResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * List the discoverers.
     * </p>
     *
     * @param listDiscoverersRequest
     * @return Result of the ListDiscoverers operation returned by the service.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListDiscoverers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListDiscoverers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDiscoverersResponse listDiscoverers(ListDiscoverersRequest listDiscoverersRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the discoverers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoverersRequest.Builder} avoiding the need
     * to create one manually via {@link ListDiscoverersRequest#builder()}
     * </p>
     *
     * @param listDiscoverersRequest
     *        A {@link Consumer} that will call methods on {@link ListDiscoverersRequest.Builder} to create a request.
     * @return Result of the ListDiscoverers operation returned by the service.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListDiscoverers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListDiscoverers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDiscoverersResponse listDiscoverers(Consumer<ListDiscoverersRequest.Builder> listDiscoverersRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        return listDiscoverers(ListDiscoverersRequest.builder().applyMutation(listDiscoverersRequest).build());
    }

    /**
     * <p>
     * List the discoverers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDiscoverers(software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListDiscoverersIterable responses = client.listDiscoverersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.schemas.paginators.ListDiscoverersIterable responses = client
     *             .listDiscoverersPaginator(request);
     *     for (software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListDiscoverersIterable responses = client.listDiscoverersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoverers(software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest)} operation.</b>
     * </p>
     *
     * @param listDiscoverersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListDiscoverers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListDiscoverers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDiscoverersIterable listDiscoverersPaginator(ListDiscoverersRequest listDiscoverersRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the discoverers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDiscoverers(software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListDiscoverersIterable responses = client.listDiscoverersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.schemas.paginators.ListDiscoverersIterable responses = client
     *             .listDiscoverersPaginator(request);
     *     for (software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListDiscoverersIterable responses = client.listDiscoverersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoverers(software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoverersRequest.Builder} avoiding the need
     * to create one manually via {@link ListDiscoverersRequest#builder()}
     * </p>
     *
     * @param listDiscoverersRequest
     *        A {@link Consumer} that will call methods on {@link ListDiscoverersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListDiscoverers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListDiscoverers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDiscoverersIterable listDiscoverersPaginator(Consumer<ListDiscoverersRequest.Builder> listDiscoverersRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        return listDiscoverersPaginator(ListDiscoverersRequest.builder().applyMutation(listDiscoverersRequest).build());
    }

    /**
     * <p>
     * List the registries.
     * </p>
     *
     * @param listRegistriesRequest
     * @return Result of the ListRegistries operation returned by the service.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListRegistries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListRegistries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRegistriesResponse listRegistries(ListRegistriesRequest listRegistriesRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the registries.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegistriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRegistriesRequest#builder()}
     * </p>
     *
     * @param listRegistriesRequest
     *        A {@link Consumer} that will call methods on {@link ListRegistriesRequest.Builder} to create a request.
     * @return Result of the ListRegistries operation returned by the service.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListRegistries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListRegistries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRegistriesResponse listRegistries(Consumer<ListRegistriesRequest.Builder> listRegistriesRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        return listRegistries(ListRegistriesRequest.builder().applyMutation(listRegistriesRequest).build());
    }

    /**
     * <p>
     * List the registries.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRegistries(software.amazon.awssdk.services.schemas.model.ListRegistriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListRegistriesIterable responses = client.listRegistriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.schemas.paginators.ListRegistriesIterable responses = client.listRegistriesPaginator(request);
     *     for (software.amazon.awssdk.services.schemas.model.ListRegistriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListRegistriesIterable responses = client.listRegistriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegistries(software.amazon.awssdk.services.schemas.model.ListRegistriesRequest)} operation.</b>
     * </p>
     *
     * @param listRegistriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListRegistries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListRegistries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRegistriesIterable listRegistriesPaginator(ListRegistriesRequest listRegistriesRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the registries.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRegistries(software.amazon.awssdk.services.schemas.model.ListRegistriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListRegistriesIterable responses = client.listRegistriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.schemas.paginators.ListRegistriesIterable responses = client.listRegistriesPaginator(request);
     *     for (software.amazon.awssdk.services.schemas.model.ListRegistriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListRegistriesIterable responses = client.listRegistriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegistries(software.amazon.awssdk.services.schemas.model.ListRegistriesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegistriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRegistriesRequest#builder()}
     * </p>
     *
     * @param listRegistriesRequest
     *        A {@link Consumer} that will call methods on {@link ListRegistriesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListRegistries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListRegistries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRegistriesIterable listRegistriesPaginator(Consumer<ListRegistriesRequest.Builder> listRegistriesRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        return listRegistriesPaginator(ListRegistriesRequest.builder().applyMutation(listRegistriesRequest).build());
    }

    /**
     * <p>
     * Provides a list of the schema versions and related information.
     * </p>
     *
     * @param listSchemaVersionsRequest
     * @return Result of the ListSchemaVersions operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListSchemaVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemaVersionsResponse listSchemaVersions(ListSchemaVersionsRequest listSchemaVersionsRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of the schema versions and related information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaVersionsRequest#builder()}
     * </p>
     *
     * @param listSchemaVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemaVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSchemaVersions operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListSchemaVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemaVersionsResponse listSchemaVersions(Consumer<ListSchemaVersionsRequest.Builder> listSchemaVersionsRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return listSchemaVersions(ListSchemaVersionsRequest.builder().applyMutation(listSchemaVersionsRequest).build());
    }

    /**
     * <p>
     * Provides a list of the schema versions and related information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSchemaVersions(software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemaVersionsIterable responses = client.listSchemaVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.schemas.paginators.ListSchemaVersionsIterable responses = client
     *             .listSchemaVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemaVersionsIterable responses = client.listSchemaVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaVersions(software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSchemaVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListSchemaVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemaVersionsIterable listSchemaVersionsPaginator(ListSchemaVersionsRequest listSchemaVersionsRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of the schema versions and related information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSchemaVersions(software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemaVersionsIterable responses = client.listSchemaVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.schemas.paginators.ListSchemaVersionsIterable responses = client
     *             .listSchemaVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemaVersionsIterable responses = client.listSchemaVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaVersions(software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaVersionsRequest#builder()}
     * </p>
     *
     * @param listSchemaVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemaVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListSchemaVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemaVersionsIterable listSchemaVersionsPaginator(
            Consumer<ListSchemaVersionsRequest.Builder> listSchemaVersionsRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return listSchemaVersionsPaginator(ListSchemaVersionsRequest.builder().applyMutation(listSchemaVersionsRequest).build());
    }

    /**
     * <p>
     * List the schemas.
     * </p>
     *
     * @param listSchemasRequest
     * @return Result of the ListSchemas operation returned by the service.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListSchemas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasResponse listSchemas(ListSchemasRequest listSchemasRequest) throws ServiceUnavailableException,
            BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the schemas.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchemasRequest#builder()}
     * </p>
     *
     * @param listSchemasRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemasRequest.Builder} to create a request.
     * @return Result of the ListSchemas operation returned by the service.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListSchemas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasResponse listSchemas(Consumer<ListSchemasRequest.Builder> listSchemasRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        return listSchemas(ListSchemasRequest.builder().applyMutation(listSchemasRequest).build());
    }

    /**
     * <p>
     * List the schemas.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSchemas(software.amazon.awssdk.services.schemas.model.ListSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.schemas.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.schemas.model.ListSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemas(software.amazon.awssdk.services.schemas.model.ListSchemasRequest)} operation.</b>
     * </p>
     *
     * @param listSchemasRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListSchemas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasIterable listSchemasPaginator(ListSchemasRequest listSchemasRequest) throws ServiceUnavailableException,
            BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the schemas.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSchemas(software.amazon.awssdk.services.schemas.model.ListSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.schemas.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.schemas.model.ListSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemas(software.amazon.awssdk.services.schemas.model.ListSchemasRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchemasRequest#builder()}
     * </p>
     *
     * @param listSchemasRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemasRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListSchemas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasIterable listSchemasPaginator(Consumer<ListSchemasRequest.Builder> listSchemasRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        return listSchemasPaginator(ListSchemasRequest.builder().applyMutation(listSchemasRequest).build());
    }

    /**
     * <p>
     * Get tags for resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get tags for resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            SchemasException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Put code binding URI
     * </p>
     *
     * @param putCodeBindingRequest
     * @return Result of the PutCodeBinding operation returned by the service.
     * @throws GoneException
     *         410 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.PutCodeBinding
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/PutCodeBinding" target="_top">AWS API
     *      Documentation</a>
     */
    default PutCodeBindingResponse putCodeBinding(PutCodeBindingRequest putCodeBindingRequest) throws GoneException,
            BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Put code binding URI
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutCodeBindingRequest.Builder} avoiding the need to
     * create one manually via {@link PutCodeBindingRequest#builder()}
     * </p>
     *
     * @param putCodeBindingRequest
     *        A {@link Consumer} that will call methods on {@link PutCodeBindingRequest.Builder} to create a request.
     * @return Result of the PutCodeBinding operation returned by the service.
     * @throws GoneException
     *         410 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.PutCodeBinding
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/PutCodeBinding" target="_top">AWS API
     *      Documentation</a>
     */
    default PutCodeBindingResponse putCodeBinding(Consumer<PutCodeBindingRequest.Builder> putCodeBindingRequest)
            throws GoneException, BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, SchemasException {
        return putCodeBinding(PutCodeBindingRequest.builder().applyMutation(putCodeBindingRequest).build());
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     *
     * @param putResourcePolicyRequest
     *        The name of the policy.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws PreconditionFailedException
     *         412 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.PutResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/PutResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws BadRequestException, UnauthorizedException, PreconditionFailedException, InternalServerErrorException,
            ForbiddenException, NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutResourcePolicyRequest.Builder} to create a request.
     *        The name of the policy.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws PreconditionFailedException
     *         412 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.PutResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/PutResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws BadRequestException, UnauthorizedException, PreconditionFailedException, InternalServerErrorException,
            ForbiddenException, NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            SchemasException {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Search the schemas
     * </p>
     *
     * @param searchSchemasRequest
     * @return Result of the SearchSchemas operation returned by the service.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.SearchSchemas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/SearchSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchSchemasResponse searchSchemas(SearchSchemasRequest searchSchemasRequest) throws ServiceUnavailableException,
            BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Search the schemas
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link SearchSchemasRequest#builder()}
     * </p>
     *
     * @param searchSchemasRequest
     *        A {@link Consumer} that will call methods on {@link SearchSchemasRequest.Builder} to create a request.
     * @return Result of the SearchSchemas operation returned by the service.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.SearchSchemas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/SearchSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchSchemasResponse searchSchemas(Consumer<SearchSchemasRequest.Builder> searchSchemasRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        return searchSchemas(SearchSchemasRequest.builder().applyMutation(searchSchemasRequest).build());
    }

    /**
     * <p>
     * Search the schemas
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #searchSchemas(software.amazon.awssdk.services.schemas.model.SearchSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.SearchSchemasIterable responses = client.searchSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.schemas.paginators.SearchSchemasIterable responses = client.searchSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.schemas.model.SearchSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.SearchSchemasIterable responses = client.searchSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSchemas(software.amazon.awssdk.services.schemas.model.SearchSchemasRequest)} operation.</b>
     * </p>
     *
     * @param searchSchemasRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.SearchSchemas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/SearchSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchSchemasIterable searchSchemasPaginator(SearchSchemasRequest searchSchemasRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Search the schemas
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #searchSchemas(software.amazon.awssdk.services.schemas.model.SearchSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.SearchSchemasIterable responses = client.searchSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.schemas.paginators.SearchSchemasIterable responses = client.searchSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.schemas.model.SearchSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.SearchSchemasIterable responses = client.searchSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSchemas(software.amazon.awssdk.services.schemas.model.SearchSchemasRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link SearchSchemasRequest#builder()}
     * </p>
     *
     * @param searchSchemasRequest
     *        A {@link Consumer} that will call methods on {@link SearchSchemasRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         503 response
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.SearchSchemas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/SearchSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchSchemasIterable searchSchemasPaginator(Consumer<SearchSchemasRequest.Builder> searchSchemasRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        return searchSchemasPaginator(SearchSchemasRequest.builder().applyMutation(searchSchemasRequest).build());
    }

    /**
     * <p>
     * Starts the discoverer
     * </p>
     *
     * @param startDiscovererRequest
     * @return Result of the StartDiscoverer operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.StartDiscoverer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/StartDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default StartDiscovererResponse startDiscoverer(StartDiscovererRequest startDiscovererRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the discoverer
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDiscovererRequest.Builder} avoiding the need
     * to create one manually via {@link StartDiscovererRequest#builder()}
     * </p>
     *
     * @param startDiscovererRequest
     *        A {@link Consumer} that will call methods on {@link StartDiscovererRequest.Builder} to create a request.
     * @return Result of the StartDiscoverer operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.StartDiscoverer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/StartDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default StartDiscovererResponse startDiscoverer(Consumer<StartDiscovererRequest.Builder> startDiscovererRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return startDiscoverer(StartDiscovererRequest.builder().applyMutation(startDiscovererRequest).build());
    }

    /**
     * <p>
     * Stops the discoverer
     * </p>
     *
     * @param stopDiscovererRequest
     * @return Result of the StopDiscoverer operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.StopDiscoverer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/StopDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default StopDiscovererResponse stopDiscoverer(StopDiscovererRequest stopDiscovererRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the discoverer
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDiscovererRequest.Builder} avoiding the need to
     * create one manually via {@link StopDiscovererRequest#builder()}
     * </p>
     *
     * @param stopDiscovererRequest
     *        A {@link Consumer} that will call methods on {@link StopDiscovererRequest.Builder} to create a request.
     * @return Result of the StopDiscoverer operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.StopDiscoverer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/StopDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default StopDiscovererResponse stopDiscoverer(Consumer<StopDiscovererRequest.Builder> stopDiscovererRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return stopDiscoverer(StopDiscovererRequest.builder().applyMutation(stopDiscovererRequest).build());
    }

    /**
     * <p>
     * Add tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            SchemasException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, SchemasException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the discoverer
     * </p>
     *
     * @param updateDiscovererRequest
     * @return Result of the UpdateDiscoverer operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.UpdateDiscoverer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDiscovererResponse updateDiscoverer(UpdateDiscovererRequest updateDiscovererRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the discoverer
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDiscovererRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDiscovererRequest#builder()}
     * </p>
     *
     * @param updateDiscovererRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDiscovererRequest.Builder} to create a request.
     * @return Result of the UpdateDiscoverer operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.UpdateDiscoverer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDiscovererResponse updateDiscoverer(Consumer<UpdateDiscovererRequest.Builder> updateDiscovererRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return updateDiscoverer(UpdateDiscovererRequest.builder().applyMutation(updateDiscovererRequest).build());
    }

    /**
     * <p>
     * Updates a registry.
     * </p>
     *
     * @param updateRegistryRequest
     *        Updates the registry.
     * @return Result of the UpdateRegistry operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.UpdateRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRegistryResponse updateRegistry(UpdateRegistryRequest updateRegistryRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRegistryRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRegistryRequest#builder()}
     * </p>
     *
     * @param updateRegistryRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRegistryRequest.Builder} to create a request.
     *        Updates the registry.
     * @return Result of the UpdateRegistry operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws UnauthorizedException
     *         401 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.UpdateRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRegistryResponse updateRegistry(Consumer<UpdateRegistryRequest.Builder> updateRegistryRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return updateRegistry(UpdateRegistryRequest.builder().applyMutation(updateRegistryRequest).build());
    }

    /**
     * <p>
     * Updates the schema definition
     * </p>
     * <note>
     * <p>
     * Inactive schemas will be deleted after two years.
     * </p>
     * </note>
     *
     * @param updateSchemaRequest
     * @return Result of the UpdateSchema operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.UpdateSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSchemaResponse updateSchema(UpdateSchemaRequest updateSchemaRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, SchemasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the schema definition
     * </p>
     * <note>
     * <p>
     * Inactive schemas will be deleted after two years.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSchemaRequest#builder()}
     * </p>
     *
     * @param updateSchemaRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSchemaRequest.Builder} to create a request.
     * @return Result of the UpdateSchema operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws ServiceUnavailableException
     *         503 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SchemasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SchemasClient.UpdateSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSchemaResponse updateSchema(Consumer<UpdateSchemaRequest.Builder> updateSchemaRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, SchemasException {
        return updateSchema(UpdateSchemaRequest.builder().applyMutation(updateSchemaRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("schemas");
    }

    /**
     * Create an instance of {@link SchemasWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link SchemasWaiter}
     */
    default SchemasWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
