/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.schemas.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegistrySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegistrySummary> {
    private static final SdkField<String> REGISTRY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegistrySummary.getter(RegistrySummary::registryArn)).setter(RegistrySummary.setter(Builder::registryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryArn").build()}).build();
    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegistrySummary.getter(RegistrySummary::registryName)).setter(RegistrySummary.setter(Builder::registryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(RegistrySummary.getter(RegistrySummary::tags)).setter(RegistrySummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ARN_FIELD, REGISTRY_NAME_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String registryArn;
    private final String registryName;
    private final Map<String, String> tags;

    private RegistrySummary(BuilderImpl builder) {
        this.registryArn = builder.registryArn;
        this.registryName = builder.registryName;
        this.tags = builder.tags;
    }

    public String registryArn() {
        return this.registryArn;
    }

    public String registryName() {
        return this.registryName;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrySummary)) {
            return false;
        }
        RegistrySummary other = (RegistrySummary)obj;
        return Objects.equals(this.registryArn(), other.registryArn()) && Objects.equals(this.registryName(), other.registryName()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"RegistrySummary").add("RegistryArn", (Object)this.registryArn()).add("RegistryName", (Object)this.registryName()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistryArn": {
                return Optional.ofNullable(clazz.cast(this.registryArn()));
            }
            case "RegistryName": {
                return Optional.ofNullable(clazz.cast(this.registryName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegistrySummary, T> g) {
        return obj -> g.apply((RegistrySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String registryArn;
        private String registryName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrySummary model) {
            this.registryArn(model.registryArn);
            this.registryName(model.registryName);
            this.tags(model.tags);
        }

        public final String getRegistryArn() {
            return this.registryArn;
        }

        @Override
        public final Builder registryArn(String registryArn) {
            this.registryArn = registryArn;
            return this;
        }

        public final void setRegistryArn(String registryArn) {
            this.registryArn = registryArn;
        }

        public final String getRegistryName() {
            return this.registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public RegistrySummary build() {
            return new RegistrySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegistrySummary> {
        public Builder registryArn(String var1);

        public Builder registryName(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

