/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.schemas.model.CodeGenerationStatus;
import software.amazon.awssdk.services.schemas.model.SchemasResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCodeBindingResponse
extends SchemasResponse
implements ToCopyableBuilder<Builder, DescribeCodeBindingResponse> {
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeCodeBindingResponse.getter(DescribeCodeBindingResponse::creationDate)).setter(DescribeCodeBindingResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeCodeBindingResponse.getter(DescribeCodeBindingResponse::lastModified)).setter(DescribeCodeBindingResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeCodeBindingResponse.getter(DescribeCodeBindingResponse::schemaVersion)).setter(DescribeCodeBindingResponse.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeCodeBindingResponse.getter(DescribeCodeBindingResponse::statusAsString)).setter(DescribeCodeBindingResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_FIELD, LAST_MODIFIED_FIELD, SCHEMA_VERSION_FIELD, STATUS_FIELD));
    private final Instant creationDate;
    private final Instant lastModified;
    private final String schemaVersion;
    private final String status;

    private DescribeCodeBindingResponse(BuilderImpl builder) {
        super(builder);
        this.creationDate = builder.creationDate;
        this.lastModified = builder.lastModified;
        this.schemaVersion = builder.schemaVersion;
        this.status = builder.status;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public CodeGenerationStatus status() {
        return CodeGenerationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCodeBindingResponse)) {
            return false;
        }
        DescribeCodeBindingResponse other = (DescribeCodeBindingResponse)((Object)obj);
        return Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCodeBindingResponse").add("CreationDate", (Object)this.creationDate()).add("LastModified", (Object)this.lastModified()).add("SchemaVersion", (Object)this.schemaVersion()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "SchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCodeBindingResponse, T> g) {
        return obj -> g.apply((DescribeCodeBindingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasResponse.BuilderImpl
    implements Builder {
        private Instant creationDate;
        private Instant lastModified;
        private String schemaVersion;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCodeBindingResponse model) {
            super(model);
            this.creationDate(model.creationDate);
            this.lastModified(model.lastModified);
            this.schemaVersion(model.schemaVersion);
            this.status(model.status);
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CodeGenerationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public DescribeCodeBindingResponse build() {
            return new DescribeCodeBindingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SchemasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCodeBindingResponse> {
        public Builder creationDate(Instant var1);

        public Builder lastModified(Instant var1);

        public Builder schemaVersion(String var1);

        public Builder status(String var1);

        public Builder status(CodeGenerationStatus var1);
    }
}

