/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDiscoverersRequest extends SchemasRequest implements
        ToCopyableBuilder<ListDiscoverersRequest.Builder, ListDiscoverersRequest> {
    private static final SdkField<String> DISCOVERER_ID_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDiscoverersRequest::discovererIdPrefix)).setter(setter(Builder::discovererIdPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("discovererIdPrefix").build())
            .build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListDiscoverersRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDiscoverersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> SOURCE_ARN_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDiscoverersRequest::sourceArnPrefix)).setter(setter(Builder::sourceArnPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sourceArnPrefix").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERER_ID_PREFIX_FIELD,
            LIMIT_FIELD, NEXT_TOKEN_FIELD, SOURCE_ARN_PREFIX_FIELD));

    private final String discovererIdPrefix;

    private final Integer limit;

    private final String nextToken;

    private final String sourceArnPrefix;

    private ListDiscoverersRequest(BuilderImpl builder) {
        super(builder);
        this.discovererIdPrefix = builder.discovererIdPrefix;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
        this.sourceArnPrefix = builder.sourceArnPrefix;
    }

    /**
     * <p>
     * Specifying this limits the results to only those discoverer IDs that start with the specified prefix.
     * </p>
     * 
     * @return Specifying this limits the results to only those discoverer IDs that start with the specified prefix.
     */
    public String discovererIdPrefix() {
        return discovererIdPrefix;
    }

    /**
     * Returns the value of the Limit property for this object.
     * 
     * @return The value of the Limit property for this object.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The token that specifies the next page of results to return. To request the first page, leave NextToken empty.
     * The token will expire in 24 hours, and cannot be shared with other accounts.
     * </p>
     * 
     * @return The token that specifies the next page of results to return. To request the first page, leave NextToken
     *         empty. The token will expire in 24 hours, and cannot be shared with other accounts.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifying this limits the results to only those ARNs that start with the specified prefix.
     * </p>
     * 
     * @return Specifying this limits the results to only those ARNs that start with the specified prefix.
     */
    public String sourceArnPrefix() {
        return sourceArnPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(discovererIdPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArnPrefix());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoverersRequest)) {
            return false;
        }
        ListDiscoverersRequest other = (ListDiscoverersRequest) obj;
        return Objects.equals(discovererIdPrefix(), other.discovererIdPrefix()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sourceArnPrefix(), other.sourceArnPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDiscoverersRequest").add("DiscovererIdPrefix", discovererIdPrefix()).add("Limit", limit())
                .add("NextToken", nextToken()).add("SourceArnPrefix", sourceArnPrefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DiscovererIdPrefix":
            return Optional.ofNullable(clazz.cast(discovererIdPrefix()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SourceArnPrefix":
            return Optional.ofNullable(clazz.cast(sourceArnPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDiscoverersRequest, T> g) {
        return obj -> g.apply((ListDiscoverersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDiscoverersRequest> {
        /**
         * <p>
         * Specifying this limits the results to only those discoverer IDs that start with the specified prefix.
         * </p>
         * 
         * @param discovererIdPrefix
         *        Specifying this limits the results to only those discoverer IDs that start with the specified prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discovererIdPrefix(String discovererIdPrefix);

        /**
         * Sets the value of the Limit property for this object.
         *
         * @param limit
         *        The new value for the Limit property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The token that specifies the next page of results to return. To request the first page, leave NextToken
         * empty. The token will expire in 24 hours, and cannot be shared with other accounts.
         * </p>
         * 
         * @param nextToken
         *        The token that specifies the next page of results to return. To request the first page, leave
         *        NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifying this limits the results to only those ARNs that start with the specified prefix.
         * </p>
         * 
         * @param sourceArnPrefix
         *        Specifying this limits the results to only those ARNs that start with the specified prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArnPrefix(String sourceArnPrefix);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SchemasRequest.BuilderImpl implements Builder {
        private String discovererIdPrefix;

        private Integer limit;

        private String nextToken;

        private String sourceArnPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDiscoverersRequest model) {
            super(model);
            discovererIdPrefix(model.discovererIdPrefix);
            limit(model.limit);
            nextToken(model.nextToken);
            sourceArnPrefix(model.sourceArnPrefix);
        }

        public final String getDiscovererIdPrefix() {
            return discovererIdPrefix;
        }

        @Override
        public final Builder discovererIdPrefix(String discovererIdPrefix) {
            this.discovererIdPrefix = discovererIdPrefix;
            return this;
        }

        public final void setDiscovererIdPrefix(String discovererIdPrefix) {
            this.discovererIdPrefix = discovererIdPrefix;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSourceArnPrefix() {
            return sourceArnPrefix;
        }

        @Override
        public final Builder sourceArnPrefix(String sourceArnPrefix) {
            this.sourceArnPrefix = sourceArnPrefix;
            return this;
        }

        public final void setSourceArnPrefix(String sourceArnPrefix) {
            this.sourceArnPrefix = sourceArnPrefix;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDiscoverersRequest build() {
            return new ListDiscoverersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
