/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSchemaRequest extends SchemasRequest implements
        ToCopyableBuilder<UpdateSchemaRequest.Builder, UpdateSchemaRequest> {
    private static final SdkField<String> CLIENT_TOKEN_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSchemaRequest::clientTokenId))
            .setter(setter(Builder::clientTokenId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientTokenId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSchemaRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSchemaRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSchemaRequest::registryName)).setter(setter(Builder::registryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("registryName").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSchemaRequest::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("schemaName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSchemaRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_ID_FIELD,
            CONTENT_FIELD, DESCRIPTION_FIELD, REGISTRY_NAME_FIELD, SCHEMA_NAME_FIELD, TYPE_FIELD));

    private final String clientTokenId;

    private final String content;

    private final String description;

    private final String registryName;

    private final String schemaName;

    private final String type;

    private UpdateSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.clientTokenId = builder.clientTokenId;
        this.content = builder.content;
        this.description = builder.description;
        this.registryName = builder.registryName;
        this.schemaName = builder.schemaName;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID of the client token.
     * </p>
     * 
     * @return The ID of the client token.
     */
    public String clientTokenId() {
        return clientTokenId;
    }

    /**
     * <p>
     * The source of the schema definition.
     * </p>
     * 
     * @return The source of the schema definition.
     */
    public String content() {
        return content;
    }

    /**
     * <p>
     * The description of the schema.
     * </p>
     * 
     * @return The description of the schema.
     */
    public String description() {
        return description;
    }

    /**
     * Returns the value of the RegistryName property for this object.
     * 
     * @return The value of the RegistryName property for this object.
     */
    public String registryName() {
        return registryName;
    }

    /**
     * Returns the value of the SchemaName property for this object.
     * 
     * @return The value of the SchemaName property for this object.
     */
    public String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The schema type for the events schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The schema type for the events schema.
     * @see Type
     */
    public Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The schema type for the events schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The schema type for the events schema.
     * @see Type
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientTokenId());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(registryName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSchemaRequest)) {
            return false;
        }
        UpdateSchemaRequest other = (UpdateSchemaRequest) obj;
        return Objects.equals(clientTokenId(), other.clientTokenId()) && Objects.equals(content(), other.content())
                && Objects.equals(description(), other.description()) && Objects.equals(registryName(), other.registryName())
                && Objects.equals(schemaName(), other.schemaName()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateSchemaRequest").add("ClientTokenId", clientTokenId()).add("Content", content())
                .add("Description", description()).add("RegistryName", registryName()).add("SchemaName", schemaName())
                .add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientTokenId":
            return Optional.ofNullable(clazz.cast(clientTokenId()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RegistryName":
            return Optional.ofNullable(clazz.cast(registryName()));
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSchemaRequest, T> g) {
        return obj -> g.apply((UpdateSchemaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSchemaRequest> {
        /**
         * <p>
         * The ID of the client token.
         * </p>
         * 
         * @param clientTokenId
         *        The ID of the client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientTokenId(String clientTokenId);

        /**
         * <p>
         * The source of the schema definition.
         * </p>
         * 
         * @param content
         *        The source of the schema definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The description of the schema.
         * </p>
         * 
         * @param description
         *        The description of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the RegistryName property for this object.
         *
         * @param registryName
         *        The new value for the RegistryName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryName(String registryName);

        /**
         * Sets the value of the SchemaName property for this object.
         *
         * @param schemaName
         *        The new value for the SchemaName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The schema type for the events schema.
         * </p>
         * 
         * @param type
         *        The schema type for the events schema.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The schema type for the events schema.
         * </p>
         * 
         * @param type
         *        The schema type for the events schema.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SchemasRequest.BuilderImpl implements Builder {
        private String clientTokenId;

        private String content;

        private String description;

        private String registryName;

        private String schemaName;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSchemaRequest model) {
            super(model);
            clientTokenId(model.clientTokenId);
            content(model.content);
            description(model.description);
            registryName(model.registryName);
            schemaName(model.schemaName);
            type(model.type);
        }

        public final String getClientTokenId() {
            return clientTokenId;
        }

        @Override
        public final Builder clientTokenId(String clientTokenId) {
            this.clientTokenId = clientTokenId;
            return this;
        }

        public final void setClientTokenId(String clientTokenId) {
            this.clientTokenId = clientTokenId;
        }

        public final String getContent() {
            return content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRegistryName() {
            return registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSchemaRequest build() {
            return new UpdateSchemaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
