/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.scheduler.model.ScheduleListCopier;
import software.amazon.awssdk.services.scheduler.model.ScheduleSummary;
import software.amazon.awssdk.services.scheduler.model.SchedulerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSchedulesResponse
extends SchedulerResponse
implements ToCopyableBuilder<Builder, ListSchedulesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSchedulesResponse.getter(ListSchedulesResponse::nextToken)).setter(ListSchedulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ScheduleSummary>> SCHEDULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Schedules").getter(ListSchedulesResponse.getter(ListSchedulesResponse::schedules)).setter(ListSchedulesResponse.setter(Builder::schedules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SCHEDULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSchedulesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ScheduleSummary> schedules;

    private ListSchedulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.schedules = builder.schedules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSchedules() {
        return this.schedules != null && !(this.schedules instanceof SdkAutoConstructList);
    }

    public final List<ScheduleSummary> schedules() {
        return this.schedules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchedules() ? this.schedules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchedulesResponse)) {
            return false;
        }
        ListSchedulesResponse other = (ListSchedulesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSchedules() == other.hasSchedules() && Objects.equals(this.schedules(), other.schedules());
    }

    public final String toString() {
        return ToString.builder((String)"ListSchedulesResponse").add("NextToken", (Object)this.nextToken()).add("Schedules", this.hasSchedules() ? this.schedules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Schedules": {
                return Optional.ofNullable(clazz.cast(this.schedules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Schedules", SCHEDULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSchedulesResponse, T> g) {
        return obj -> g.apply((ListSchedulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchedulerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ScheduleSummary> schedules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchedulesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.schedules(model.schedules);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ScheduleSummary.Builder> getSchedules() {
            List<ScheduleSummary.Builder> result = ScheduleListCopier.copyToBuilder(this.schedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchedules(Collection<ScheduleSummary.BuilderImpl> schedules) {
            this.schedules = ScheduleListCopier.copyFromBuilder(schedules);
        }

        @Override
        public final Builder schedules(Collection<ScheduleSummary> schedules) {
            this.schedules = ScheduleListCopier.copy(schedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedules(ScheduleSummary ... schedules) {
            this.schedules(Arrays.asList(schedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedules(Consumer<ScheduleSummary.Builder> ... schedules) {
            this.schedules(Stream.of(schedules).map(c -> (ScheduleSummary)((ScheduleSummary.Builder)ScheduleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSchedulesResponse build() {
            return new ListSchedulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SchedulerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSchedulesResponse> {
        public Builder nextToken(String var1);

        public Builder schedules(Collection<ScheduleSummary> var1);

        public Builder schedules(ScheduleSummary ... var1);

        public Builder schedules(Consumer<ScheduleSummary.Builder> ... var1);
    }
}

