/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.scheduler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The schedule's target. EventBridge Scheduler supports templated target that invoke common API operations, as well as
 * universal targets that you can customize to invoke over 6,000 API operations across more than 270 services. You can
 * only specify one templated or universal target for a schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Target implements SdkPojo, Serializable, ToCopyableBuilder<Target.Builder, Target> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Target::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField
            .<DeadLetterConfig> builder(MarshallingType.SDK_POJO).memberName("DeadLetterConfig")
            .getter(getter(Target::deadLetterConfig)).setter(setter(Builder::deadLetterConfig))
            .constructor(DeadLetterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()).build();

    private static final SdkField<EcsParameters> ECS_PARAMETERS_FIELD = SdkField
            .<EcsParameters> builder(MarshallingType.SDK_POJO).memberName("EcsParameters").getter(getter(Target::ecsParameters))
            .setter(setter(Builder::ecsParameters)).constructor(EcsParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EcsParameters").build()).build();

    private static final SdkField<EventBridgeParameters> EVENT_BRIDGE_PARAMETERS_FIELD = SdkField
            .<EventBridgeParameters> builder(MarshallingType.SDK_POJO).memberName("EventBridgeParameters")
            .getter(getter(Target::eventBridgeParameters)).setter(setter(Builder::eventBridgeParameters))
            .constructor(EventBridgeParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeParameters").build())
            .build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Input")
            .getter(getter(Target::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<KinesisParameters> KINESIS_PARAMETERS_FIELD = SdkField
            .<KinesisParameters> builder(MarshallingType.SDK_POJO).memberName("KinesisParameters")
            .getter(getter(Target::kinesisParameters)).setter(setter(Builder::kinesisParameters))
            .constructor(KinesisParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisParameters").build()).build();

    private static final SdkField<RetryPolicy> RETRY_POLICY_FIELD = SdkField.<RetryPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("RetryPolicy").getter(getter(Target::retryPolicy)).setter(setter(Builder::retryPolicy))
            .constructor(RetryPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryPolicy").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(Target::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<SageMakerPipelineParameters> SAGE_MAKER_PIPELINE_PARAMETERS_FIELD = SdkField
            .<SageMakerPipelineParameters> builder(MarshallingType.SDK_POJO)
            .memberName("SageMakerPipelineParameters")
            .getter(getter(Target::sageMakerPipelineParameters))
            .setter(setter(Builder::sageMakerPipelineParameters))
            .constructor(SageMakerPipelineParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerPipelineParameters")
                    .build()).build();

    private static final SdkField<SqsParameters> SQS_PARAMETERS_FIELD = SdkField
            .<SqsParameters> builder(MarshallingType.SDK_POJO).memberName("SqsParameters").getter(getter(Target::sqsParameters))
            .setter(setter(Builder::sqsParameters)).constructor(SqsParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsParameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            DEAD_LETTER_CONFIG_FIELD, ECS_PARAMETERS_FIELD, EVENT_BRIDGE_PARAMETERS_FIELD, INPUT_FIELD, KINESIS_PARAMETERS_FIELD,
            RETRY_POLICY_FIELD, ROLE_ARN_FIELD, SAGE_MAKER_PIPELINE_PARAMETERS_FIELD, SQS_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final DeadLetterConfig deadLetterConfig;

    private final EcsParameters ecsParameters;

    private final EventBridgeParameters eventBridgeParameters;

    private final String input;

    private final KinesisParameters kinesisParameters;

    private final RetryPolicy retryPolicy;

    private final String roleArn;

    private final SageMakerPipelineParameters sageMakerPipelineParameters;

    private final SqsParameters sqsParameters;

    private Target(BuilderImpl builder) {
        this.arn = builder.arn;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.ecsParameters = builder.ecsParameters;
        this.eventBridgeParameters = builder.eventBridgeParameters;
        this.input = builder.input;
        this.kinesisParameters = builder.kinesisParameters;
        this.retryPolicy = builder.retryPolicy;
        this.roleArn = builder.roleArn;
        this.sageMakerPipelineParameters = builder.sageMakerPipelineParameters;
        this.sqsParameters = builder.sqsParameters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter
     * queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be
     * successfully delivered to a target to the queue.
     * </p>
     * 
     * @return An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a
     *         dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that
     *         could not be successfully delivered to a target to the queue.
     */
    public final DeadLetterConfig deadLetterConfig() {
        return deadLetterConfig;
    }

    /**
     * <p>
     * The templated target type for the Amazon ECS <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html"> <code>RunTask</code> </a> API
     * operation.
     * </p>
     * 
     * @return The templated target type for the Amazon ECS <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html"> <code>RunTask</code>
     *         </a> API operation.
     */
    public final EcsParameters ecsParameters() {
        return ecsParameters;
    }

    /**
     * <p>
     * The templated target type for the EventBridge <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html"> <code>PutEvents</code>
     * </a> API operation.
     * </p>
     * 
     * @return The templated target type for the EventBridge <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html">
     *         <code>PutEvents</code> </a> API operation.
     */
    public final EventBridgeParameters eventBridgeParameters() {
        return eventBridgeParameters;
    }

    /**
     * <p>
     * The text, or well-formed JSON, passed to the target. If you are configuring a templated Lambda, AWS Step
     * Functions, or Amazon EventBridge target, the input must be a well-formed JSON. For all other target types, a JSON
     * is not required. If you do not specify anything for this field, EventBridge Scheduler delivers a default
     * notification to the target.
     * </p>
     * 
     * @return The text, or well-formed JSON, passed to the target. If you are configuring a templated Lambda, AWS Step
     *         Functions, or Amazon EventBridge target, the input must be a well-formed JSON. For all other target
     *         types, a JSON is not required. If you do not specify anything for this field, EventBridge Scheduler
     *         delivers a default notification to the target.
     */
    public final String input() {
        return input;
    }

    /**
     * <p>
     * The templated target type for the Amazon Kinesis <a href="kinesis/latest/APIReference/API_PutRecord.html">
     * <code>PutRecord</code> </a> API operation.
     * </p>
     * 
     * @return The templated target type for the Amazon Kinesis <a
     *         href="kinesis/latest/APIReference/API_PutRecord.html"> <code>PutRecord</code> </a> API operation.
     */
    public final KinesisParameters kinesisParameters() {
        return kinesisParameters;
    }

    /**
     * <p>
     * A <code>RetryPolicy</code> object that includes information about the retry policy settings, including the
     * maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event to a
     * target.
     * </p>
     * 
     * @return A <code>RetryPolicy</code> object that includes information about the retry policy settings, including
     *         the maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver
     *         the event to a target.
     */
    public final RetryPolicy retryPolicy() {
        return retryPolicy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that EventBridge Scheduler will use for this target when the
     * schedule is invoked.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that EventBridge Scheduler will use for this target when
     *         the schedule is invoked.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The templated target type for the Amazon SageMaker <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html">
     * <code>StartPipelineExecution</code> </a> API operation.
     * </p>
     * 
     * @return The templated target type for the Amazon SageMaker <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html">
     *         <code>StartPipelineExecution</code> </a> API operation.
     */
    public final SageMakerPipelineParameters sageMakerPipelineParameters() {
        return sageMakerPipelineParameters;
    }

    /**
     * <p>
     * The templated target type for the Amazon SQS <a
     * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html">
     * <code>SendMessage</code> </a> API operation. Contains the message group ID to use when the target is a FIFO
     * queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have content-based deduplication
     * enabled. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html"
     * >Using the Amazon SQS message deduplication ID</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * 
     * @return The templated target type for the Amazon SQS <a
     *         href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html">
     *         <code>SendMessage</code> </a> API operation. Contains the message group ID to use when the target is a
     *         FIFO queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have content-based
     *         deduplication enabled. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html"
     *         >Using the Amazon SQS message deduplication ID</a> in the <i>Amazon SQS Developer Guide</i>.
     */
    public final SqsParameters sqsParameters() {
        return sqsParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(ecsParameters());
        hashCode = 31 * hashCode + Objects.hashCode(eventBridgeParameters());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisParameters());
        hashCode = 31 * hashCode + Objects.hashCode(retryPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(sageMakerPipelineParameters());
        hashCode = 31 * hashCode + Objects.hashCode(sqsParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(deadLetterConfig(), other.deadLetterConfig())
                && Objects.equals(ecsParameters(), other.ecsParameters())
                && Objects.equals(eventBridgeParameters(), other.eventBridgeParameters())
                && Objects.equals(input(), other.input()) && Objects.equals(kinesisParameters(), other.kinesisParameters())
                && Objects.equals(retryPolicy(), other.retryPolicy()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(sageMakerPipelineParameters(), other.sageMakerPipelineParameters())
                && Objects.equals(sqsParameters(), other.sqsParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Target").add("Arn", arn()).add("DeadLetterConfig", deadLetterConfig())
                .add("EcsParameters", ecsParameters()).add("EventBridgeParameters", eventBridgeParameters())
                .add("Input", input()).add("KinesisParameters", kinesisParameters()).add("RetryPolicy", retryPolicy())
                .add("RoleArn", roleArn()).add("SageMakerPipelineParameters", sageMakerPipelineParameters())
                .add("SqsParameters", sqsParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "DeadLetterConfig":
            return Optional.ofNullable(clazz.cast(deadLetterConfig()));
        case "EcsParameters":
            return Optional.ofNullable(clazz.cast(ecsParameters()));
        case "EventBridgeParameters":
            return Optional.ofNullable(clazz.cast(eventBridgeParameters()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "KinesisParameters":
            return Optional.ofNullable(clazz.cast(kinesisParameters()));
        case "RetryPolicy":
            return Optional.ofNullable(clazz.cast(retryPolicy()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SageMakerPipelineParameters":
            return Optional.ofNullable(clazz.cast(sageMakerPipelineParameters()));
        case "SqsParameters":
            return Optional.ofNullable(clazz.cast(sqsParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Target, T> g) {
        return obj -> g.apply((Target) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Target> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a
         * dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could
         * not be successfully delivered to a target to the queue.
         * </p>
         * 
         * @param deadLetterConfig
         *        An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a
         *        dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that
         *        could not be successfully delivered to a target to the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadLetterConfig(DeadLetterConfig deadLetterConfig);

        /**
         * <p>
         * An object that contains information about an Amazon SQS queue that EventBridge Scheduler uses as a
         * dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could
         * not be successfully delivered to a target to the queue.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeadLetterConfig.Builder} avoiding the
         * need to create one manually via {@link DeadLetterConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeadLetterConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deadLetterConfig(DeadLetterConfig)}.
         * 
         * @param deadLetterConfig
         *        a consumer that will call methods on {@link DeadLetterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deadLetterConfig(DeadLetterConfig)
         */
        default Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return deadLetterConfig(DeadLetterConfig.builder().applyMutation(deadLetterConfig).build());
        }

        /**
         * <p>
         * The templated target type for the Amazon ECS <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html"> <code>RunTask</code> </a>
         * API operation.
         * </p>
         * 
         * @param ecsParameters
         *        The templated target type for the Amazon ECS <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">
         *        <code>RunTask</code> </a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsParameters(EcsParameters ecsParameters);

        /**
         * <p>
         * The templated target type for the Amazon ECS <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html"> <code>RunTask</code> </a>
         * API operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcsParameters.Builder} avoiding the need
         * to create one manually via {@link EcsParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EcsParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #ecsParameters(EcsParameters)}.
         * 
         * @param ecsParameters
         *        a consumer that will call methods on {@link EcsParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecsParameters(EcsParameters)
         */
        default Builder ecsParameters(Consumer<EcsParameters.Builder> ecsParameters) {
            return ecsParameters(EcsParameters.builder().applyMutation(ecsParameters).build());
        }

        /**
         * <p>
         * The templated target type for the EventBridge <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html"> <code>PutEvents</code>
         * </a> API operation.
         * </p>
         * 
         * @param eventBridgeParameters
         *        The templated target type for the EventBridge <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html">
         *        <code>PutEvents</code> </a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeParameters(EventBridgeParameters eventBridgeParameters);

        /**
         * <p>
         * The templated target type for the EventBridge <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html"> <code>PutEvents</code>
         * </a> API operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventBridgeParameters.Builder} avoiding
         * the need to create one manually via {@link EventBridgeParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventBridgeParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #eventBridgeParameters(EventBridgeParameters)}.
         * 
         * @param eventBridgeParameters
         *        a consumer that will call methods on {@link EventBridgeParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBridgeParameters(EventBridgeParameters)
         */
        default Builder eventBridgeParameters(Consumer<EventBridgeParameters.Builder> eventBridgeParameters) {
            return eventBridgeParameters(EventBridgeParameters.builder().applyMutation(eventBridgeParameters).build());
        }

        /**
         * <p>
         * The text, or well-formed JSON, passed to the target. If you are configuring a templated Lambda, AWS Step
         * Functions, or Amazon EventBridge target, the input must be a well-formed JSON. For all other target types, a
         * JSON is not required. If you do not specify anything for this field, EventBridge Scheduler delivers a default
         * notification to the target.
         * </p>
         * 
         * @param input
         *        The text, or well-formed JSON, passed to the target. If you are configuring a templated Lambda, AWS
         *        Step Functions, or Amazon EventBridge target, the input must be a well-formed JSON. For all other
         *        target types, a JSON is not required. If you do not specify anything for this field, EventBridge
         *        Scheduler delivers a default notification to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The templated target type for the Amazon Kinesis <a href="kinesis/latest/APIReference/API_PutRecord.html">
         * <code>PutRecord</code> </a> API operation.
         * </p>
         * 
         * @param kinesisParameters
         *        The templated target type for the Amazon Kinesis <a
         *        href="kinesis/latest/APIReference/API_PutRecord.html"> <code>PutRecord</code> </a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisParameters(KinesisParameters kinesisParameters);

        /**
         * <p>
         * The templated target type for the Amazon Kinesis <a href="kinesis/latest/APIReference/API_PutRecord.html">
         * <code>PutRecord</code> </a> API operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisParameters.Builder} avoiding the
         * need to create one manually via {@link KinesisParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #kinesisParameters(KinesisParameters)}.
         * 
         * @param kinesisParameters
         *        a consumer that will call methods on {@link KinesisParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisParameters(KinesisParameters)
         */
        default Builder kinesisParameters(Consumer<KinesisParameters.Builder> kinesisParameters) {
            return kinesisParameters(KinesisParameters.builder().applyMutation(kinesisParameters).build());
        }

        /**
         * <p>
         * A <code>RetryPolicy</code> object that includes information about the retry policy settings, including the
         * maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event
         * to a target.
         * </p>
         * 
         * @param retryPolicy
         *        A <code>RetryPolicy</code> object that includes information about the retry policy settings, including
         *        the maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver
         *        the event to a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryPolicy(RetryPolicy retryPolicy);

        /**
         * <p>
         * A <code>RetryPolicy</code> object that includes information about the retry policy settings, including the
         * maximum age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event
         * to a target.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetryPolicy.Builder} avoiding the need to
         * create one manually via {@link RetryPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetryPolicy.Builder#build()} is called immediately and its result
         * is passed to {@link #retryPolicy(RetryPolicy)}.
         * 
         * @param retryPolicy
         *        a consumer that will call methods on {@link RetryPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryPolicy(RetryPolicy)
         */
        default Builder retryPolicy(Consumer<RetryPolicy.Builder> retryPolicy) {
            return retryPolicy(RetryPolicy.builder().applyMutation(retryPolicy).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that EventBridge Scheduler will use for this target when the
         * schedule is invoked.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that EventBridge Scheduler will use for this target
         *        when the schedule is invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The templated target type for the Amazon SageMaker <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html">
         * <code>StartPipelineExecution</code> </a> API operation.
         * </p>
         * 
         * @param sageMakerPipelineParameters
         *        The templated target type for the Amazon SageMaker <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html">
         *        <code>StartPipelineExecution</code> </a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sageMakerPipelineParameters(SageMakerPipelineParameters sageMakerPipelineParameters);

        /**
         * <p>
         * The templated target type for the Amazon SageMaker <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html">
         * <code>StartPipelineExecution</code> </a> API operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link SageMakerPipelineParameters.Builder}
         * avoiding the need to create one manually via {@link SageMakerPipelineParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SageMakerPipelineParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #sageMakerPipelineParameters(SageMakerPipelineParameters)}.
         * 
         * @param sageMakerPipelineParameters
         *        a consumer that will call methods on {@link SageMakerPipelineParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sageMakerPipelineParameters(SageMakerPipelineParameters)
         */
        default Builder sageMakerPipelineParameters(Consumer<SageMakerPipelineParameters.Builder> sageMakerPipelineParameters) {
            return sageMakerPipelineParameters(SageMakerPipelineParameters.builder().applyMutation(sageMakerPipelineParameters)
                    .build());
        }

        /**
         * <p>
         * The templated target type for the Amazon SQS <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html">
         * <code>SendMessage</code> </a> API operation. Contains the message group ID to use when the target is a FIFO
         * queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have content-based deduplication
         * enabled. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html"
         * >Using the Amazon SQS message deduplication ID</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * 
         * @param sqsParameters
         *        The templated target type for the Amazon SQS <a
         *        href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html">
         *        <code>SendMessage</code> </a> API operation. Contains the message group ID to use when the target is a
         *        FIFO queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have content-based
         *        deduplication enabled. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html"
         *        >Using the Amazon SQS message deduplication ID</a> in the <i>Amazon SQS Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqsParameters(SqsParameters sqsParameters);

        /**
         * <p>
         * The templated target type for the Amazon SQS <a
         * href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html">
         * <code>SendMessage</code> </a> API operation. Contains the message group ID to use when the target is a FIFO
         * queue. If you specify an Amazon SQS FIFO queue as a target, the queue must have content-based deduplication
         * enabled. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html"
         * >Using the Amazon SQS message deduplication ID</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SqsParameters.Builder} avoiding the need
         * to create one manually via {@link SqsParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SqsParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #sqsParameters(SqsParameters)}.
         * 
         * @param sqsParameters
         *        a consumer that will call methods on {@link SqsParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqsParameters(SqsParameters)
         */
        default Builder sqsParameters(Consumer<SqsParameters.Builder> sqsParameters) {
            return sqsParameters(SqsParameters.builder().applyMutation(sqsParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private DeadLetterConfig deadLetterConfig;

        private EcsParameters ecsParameters;

        private EventBridgeParameters eventBridgeParameters;

        private String input;

        private KinesisParameters kinesisParameters;

        private RetryPolicy retryPolicy;

        private String roleArn;

        private SageMakerPipelineParameters sageMakerPipelineParameters;

        private SqsParameters sqsParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            arn(model.arn);
            deadLetterConfig(model.deadLetterConfig);
            ecsParameters(model.ecsParameters);
            eventBridgeParameters(model.eventBridgeParameters);
            input(model.input);
            kinesisParameters(model.kinesisParameters);
            retryPolicy(model.retryPolicy);
            roleArn(model.roleArn);
            sageMakerPipelineParameters(model.sageMakerPipelineParameters);
            sqsParameters(model.sqsParameters);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return deadLetterConfig != null ? deadLetterConfig.toBuilder() : null;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final EcsParameters.Builder getEcsParameters() {
            return ecsParameters != null ? ecsParameters.toBuilder() : null;
        }

        public final void setEcsParameters(EcsParameters.BuilderImpl ecsParameters) {
            this.ecsParameters = ecsParameters != null ? ecsParameters.build() : null;
        }

        @Override
        public final Builder ecsParameters(EcsParameters ecsParameters) {
            this.ecsParameters = ecsParameters;
            return this;
        }

        public final EventBridgeParameters.Builder getEventBridgeParameters() {
            return eventBridgeParameters != null ? eventBridgeParameters.toBuilder() : null;
        }

        public final void setEventBridgeParameters(EventBridgeParameters.BuilderImpl eventBridgeParameters) {
            this.eventBridgeParameters = eventBridgeParameters != null ? eventBridgeParameters.build() : null;
        }

        @Override
        public final Builder eventBridgeParameters(EventBridgeParameters eventBridgeParameters) {
            this.eventBridgeParameters = eventBridgeParameters;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final KinesisParameters.Builder getKinesisParameters() {
            return kinesisParameters != null ? kinesisParameters.toBuilder() : null;
        }

        public final void setKinesisParameters(KinesisParameters.BuilderImpl kinesisParameters) {
            this.kinesisParameters = kinesisParameters != null ? kinesisParameters.build() : null;
        }

        @Override
        public final Builder kinesisParameters(KinesisParameters kinesisParameters) {
            this.kinesisParameters = kinesisParameters;
            return this;
        }

        public final RetryPolicy.Builder getRetryPolicy() {
            return retryPolicy != null ? retryPolicy.toBuilder() : null;
        }

        public final void setRetryPolicy(RetryPolicy.BuilderImpl retryPolicy) {
            this.retryPolicy = retryPolicy != null ? retryPolicy.build() : null;
        }

        @Override
        public final Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final SageMakerPipelineParameters.Builder getSageMakerPipelineParameters() {
            return sageMakerPipelineParameters != null ? sageMakerPipelineParameters.toBuilder() : null;
        }

        public final void setSageMakerPipelineParameters(SageMakerPipelineParameters.BuilderImpl sageMakerPipelineParameters) {
            this.sageMakerPipelineParameters = sageMakerPipelineParameters != null ? sageMakerPipelineParameters.build() : null;
        }

        @Override
        public final Builder sageMakerPipelineParameters(SageMakerPipelineParameters sageMakerPipelineParameters) {
            this.sageMakerPipelineParameters = sageMakerPipelineParameters;
            return this;
        }

        public final SqsParameters.Builder getSqsParameters() {
            return sqsParameters != null ? sqsParameters.toBuilder() : null;
        }

        public final void setSqsParameters(SqsParameters.BuilderImpl sqsParameters) {
            this.sqsParameters = sqsParameters != null ? sqsParameters.build() : null;
        }

        @Override
        public final Builder sqsParameters(SqsParameters sqsParameters) {
            this.sqsParameters = sqsParameters;
            return this;
        }

        @Override
        public Target build() {
            return new Target(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
