/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SavingsPlanType {
    COMPUTE("Compute"),
    EC2_INSTANCE("EC2Instance"),
    SAGE_MAKER("SageMaker"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SavingsPlanType> VALUE_MAP;
    private final String value;

    private SavingsPlanType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SavingsPlanType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SavingsPlanType> knownValues() {
        EnumSet<SavingsPlanType> knownValues = EnumSet.allOf(SavingsPlanType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SavingsPlanType.class, SavingsPlanType::toString);
    }
}

