/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SavingsPlanState {
    PAYMENT_PENDING("payment-pending"),
    PAYMENT_FAILED("payment-failed"),
    ACTIVE("active"),
    RETIRED("retired"),
    QUEUED("queued"),
    QUEUED_DELETED("queued-deleted"),
    PENDING_RETURN("pending-return"),
    RETURNED("returned"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SavingsPlanState> VALUE_MAP;
    private final String value;

    private SavingsPlanState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SavingsPlanState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SavingsPlanState> knownValues() {
        EnumSet<SavingsPlanState> knownValues = EnumSet.allOf(SavingsPlanState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SavingsPlanState.class, SavingsPlanState::toString);
    }
}

