/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanRate;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsplansResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSavingsPlanRatesResponse
extends SavingsplansResponse
implements ToCopyableBuilder<Builder, DescribeSavingsPlanRatesResponse> {
    private static final SdkField<String> SAVINGS_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("savingsPlanId").getter(DescribeSavingsPlanRatesResponse.getter(DescribeSavingsPlanRatesResponse::savingsPlanId)).setter(DescribeSavingsPlanRatesResponse.setter(Builder::savingsPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanId").build()}).build();
    private static final SdkField<List<SavingsPlanRate>> SEARCH_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("searchResults").getter(DescribeSavingsPlanRatesResponse.getter(DescribeSavingsPlanRatesResponse::searchResults)).setter(DescribeSavingsPlanRatesResponse.setter(Builder::searchResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SavingsPlanRate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeSavingsPlanRatesResponse.getter(DescribeSavingsPlanRatesResponse::nextToken)).setter(DescribeSavingsPlanRatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLAN_ID_FIELD, SEARCH_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String savingsPlanId;
    private final List<SavingsPlanRate> searchResults;
    private final String nextToken;

    private DescribeSavingsPlanRatesResponse(BuilderImpl builder) {
        super(builder);
        this.savingsPlanId = builder.savingsPlanId;
        this.searchResults = builder.searchResults;
        this.nextToken = builder.nextToken;
    }

    public final String savingsPlanId() {
        return this.savingsPlanId;
    }

    public final boolean hasSearchResults() {
        return this.searchResults != null && !(this.searchResults instanceof SdkAutoConstructList);
    }

    public final List<SavingsPlanRate> searchResults() {
        return this.searchResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSearchResults() ? this.searchResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlanRatesResponse)) {
            return false;
        }
        DescribeSavingsPlanRatesResponse other = (DescribeSavingsPlanRatesResponse)((Object)obj);
        return Objects.equals(this.savingsPlanId(), other.savingsPlanId()) && this.hasSearchResults() == other.hasSearchResults() && Objects.equals(this.searchResults(), other.searchResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSavingsPlanRatesResponse").add("SavingsPlanId", (Object)this.savingsPlanId()).add("SearchResults", this.hasSearchResults() ? this.searchResults() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "savingsPlanId": {
                return Optional.ofNullable(clazz.cast(this.savingsPlanId()));
            }
            case "searchResults": {
                return Optional.ofNullable(clazz.cast(this.searchResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlanRatesResponse, T> g) {
        return obj -> g.apply((DescribeSavingsPlanRatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SavingsplansResponse.BuilderImpl
    implements Builder {
        private String savingsPlanId;
        private List<SavingsPlanRate> searchResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlanRatesResponse model) {
            super(model);
            this.savingsPlanId(model.savingsPlanId);
            this.searchResults(model.searchResults);
            this.nextToken(model.nextToken);
        }

        public final String getSavingsPlanId() {
            return this.savingsPlanId;
        }

        @Override
        public final Builder savingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
            return this;
        }

        public final void setSavingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
        }

        public final Collection<SavingsPlanRate.Builder> getSearchResults() {
            if (this.searchResults instanceof SdkAutoConstructList) {
                return null;
            }
            return this.searchResults != null ? (Collection)this.searchResults.stream().map(SavingsPlanRate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder searchResults(Collection<SavingsPlanRate> searchResults) {
            this.searchResults = SavingsPlanRateListCopier.copy(searchResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchResults(SavingsPlanRate ... searchResults) {
            this.searchResults(Arrays.asList(searchResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchResults(Consumer<SavingsPlanRate.Builder> ... searchResults) {
            this.searchResults(Stream.of(searchResults).map(c -> (SavingsPlanRate)((SavingsPlanRate.Builder)SavingsPlanRate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSearchResults(Collection<SavingsPlanRate.BuilderImpl> searchResults) {
            this.searchResults = SavingsPlanRateListCopier.copyFromBuilder(searchResults);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSavingsPlanRatesResponse build() {
            return new DescribeSavingsPlanRatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SavingsplansResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSavingsPlanRatesResponse> {
        public Builder savingsPlanId(String var1);

        public Builder searchResults(Collection<SavingsPlanRate> var1);

        public Builder searchResults(SavingsPlanRate ... var1);

        public Builder searchResults(Consumer<SavingsPlanRate.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

