/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerruntime.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakerruntime.model.SageMakerRuntimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeEndpointResponse
extends SageMakerRuntimeResponse
implements ToCopyableBuilder<Builder, InvokeEndpointResponse> {
    private static final SdkField<SdkBytes> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(InvokeEndpointResponse.getter(InvokeEndpointResponse::body)).setter(InvokeEndpointResponse.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InvokeEndpointResponse.getter(InvokeEndpointResponse::contentType)).setter(InvokeEndpointResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> INVOKED_PRODUCTION_VARIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InvokeEndpointResponse.getter(InvokeEndpointResponse::invokedProductionVariant)).setter(InvokeEndpointResponse.setter(Builder::invokedProductionVariant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-Amzn-Invoked-Production-Variant").build()}).build();
    private static final SdkField<String> CUSTOM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InvokeEndpointResponse.getter(InvokeEndpointResponse::customAttributes)).setter(InvokeEndpointResponse.setter(Builder::customAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Custom-Attributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, CONTENT_TYPE_FIELD, INVOKED_PRODUCTION_VARIANT_FIELD, CUSTOM_ATTRIBUTES_FIELD));
    private final SdkBytes body;
    private final String contentType;
    private final String invokedProductionVariant;
    private final String customAttributes;

    private InvokeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.invokedProductionVariant = builder.invokedProductionVariant;
        this.customAttributes = builder.customAttributes;
    }

    public SdkBytes body() {
        return this.body;
    }

    public String contentType() {
        return this.contentType;
    }

    public String invokedProductionVariant() {
        return this.invokedProductionVariant;
    }

    public String customAttributes() {
        return this.customAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.invokedProductionVariant());
        hashCode = 31 * hashCode + Objects.hashCode(this.customAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeEndpointResponse)) {
            return false;
        }
        InvokeEndpointResponse other = (InvokeEndpointResponse)((Object)obj);
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.invokedProductionVariant(), other.invokedProductionVariant()) && Objects.equals(this.customAttributes(), other.customAttributes());
    }

    public String toString() {
        return ToString.builder((String)"InvokeEndpointResponse").add("Body", (Object)(this.body() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentType", (Object)this.contentType()).add("InvokedProductionVariant", (Object)this.invokedProductionVariant()).add("CustomAttributes", (Object)(this.customAttributes() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "InvokedProductionVariant": {
                return Optional.ofNullable(clazz.cast(this.invokedProductionVariant()));
            }
            case "CustomAttributes": {
                return Optional.ofNullable(clazz.cast(this.customAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeEndpointResponse, T> g) {
        return obj -> g.apply((InvokeEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRuntimeResponse.BuilderImpl
    implements Builder {
        private SdkBytes body;
        private String contentType;
        private String invokedProductionVariant;
        private String customAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeEndpointResponse model) {
            super(model);
            this.body(model.body);
            this.contentType(model.contentType);
            this.invokedProductionVariant(model.invokedProductionVariant);
            this.customAttributes(model.customAttributes);
        }

        public final ByteBuffer getBody() {
            return this.body == null ? null : this.body.asByteBuffer();
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = StandardMemberCopier.copy((SdkBytes)body);
            return this;
        }

        public final void setBody(ByteBuffer body) {
            this.body(body == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)body));
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getInvokedProductionVariant() {
            return this.invokedProductionVariant;
        }

        @Override
        public final Builder invokedProductionVariant(String invokedProductionVariant) {
            this.invokedProductionVariant = invokedProductionVariant;
            return this;
        }

        public final void setInvokedProductionVariant(String invokedProductionVariant) {
            this.invokedProductionVariant = invokedProductionVariant;
        }

        public final String getCustomAttributes() {
            return this.customAttributes;
        }

        @Override
        public final Builder customAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public final void setCustomAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
        }

        @Override
        public InvokeEndpointResponse build() {
            return new InvokeEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeEndpointResponse> {
        public Builder body(SdkBytes var1);

        public Builder contentType(String var1);

        public Builder invokedProductionVariant(String var1);

        public Builder customAttributes(String var1);
    }
}

