/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerruntime.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeEndpointRequest extends SageMakerRuntimeRequest implements
        ToCopyableBuilder<InvokeEndpointRequest.Builder, InvokeEndpointRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(InvokeEndpointRequest::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EndpointName").build()).build();

    private static final SdkField<SdkBytes> BODY_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Body")
            .getter(getter(InvokeEndpointRequest::body))
            .setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(InvokeEndpointRequest::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> ACCEPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Accept")
            .getter(getter(InvokeEndpointRequest::accept)).setter(setter(Builder::accept))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()).build();

    private static final SdkField<String> CUSTOM_ATTRIBUTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomAttributes")
            .getter(getter(InvokeEndpointRequest::customAttributes))
            .setter(setter(Builder::customAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Custom-Attributes")
                    .build()).build();

    private static final SdkField<String> TARGET_MODEL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetModel")
            .getter(getter(InvokeEndpointRequest::targetModel))
            .setter(setter(Builder::targetModel))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Target-Model")
                    .build()).build();

    private static final SdkField<String> TARGET_VARIANT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetVariant")
            .getter(getter(InvokeEndpointRequest::targetVariant))
            .setter(setter(Builder::targetVariant))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Target-Variant")
                    .build()).build();

    private static final SdkField<String> INFERENCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InferenceId")
            .getter(getter(InvokeEndpointRequest::inferenceId))
            .setter(setter(Builder::inferenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Inference-Id")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            BODY_FIELD, CONTENT_TYPE_FIELD, ACCEPT_FIELD, CUSTOM_ATTRIBUTES_FIELD, TARGET_MODEL_FIELD, TARGET_VARIANT_FIELD,
            INFERENCE_ID_FIELD));

    private final String endpointName;

    private final SdkBytes body;

    private final String contentType;

    private final String accept;

    private final String customAttributes;

    private final String targetModel;

    private final String targetVariant;

    private final String inferenceId;

    private InvokeEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.accept = builder.accept;
        this.customAttributes = builder.customAttributes;
        this.targetModel = builder.targetModel;
        this.targetVariant = builder.targetVariant;
        this.inferenceId = builder.inferenceId;
    }

    /**
     * <p>
     * The name of the endpoint that you specified when you created the endpoint using the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html">CreateEndpoint</a> API.
     * </p>
     * 
     * @return The name of the endpoint that you specified when you created the endpoint using the <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html">CreateEndpoint</a> API.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * Provides input data, in the format specified in the <code>ContentType</code> request header. Amazon SageMaker
     * passes all of the data in the body to the model.
     * </p>
     * <p>
     * For information about the format of the request body, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html">Common Data Formats-Inference</a>.
     * </p>
     * 
     * @return Provides input data, in the format specified in the <code>ContentType</code> request header. Amazon
     *         SageMaker passes all of the data in the body to the model. </p>
     *         <p>
     *         For information about the format of the request body, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html">Common Data
     *         Formats-Inference</a>.
     */
    public final SdkBytes body() {
        return body;
    }

    /**
     * <p>
     * The MIME type of the input data in the request body.
     * </p>
     * 
     * @return The MIME type of the input data in the request body.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The desired MIME type of the inference in the response.
     * </p>
     * 
     * @return The desired MIME type of the inference in the response.
     */
    public final String accept() {
        return accept;
    }

    /**
     * <p>
     * Provides additional information about a request for an inference submitted to a model hosted at an Amazon
     * SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for
     * example, to provide an ID that you can use to track a request or to provide other metadata that a service
     * endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters as
     * specified in <a href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value
     * Components</a> of the Hypertext Transfer Protocol (HTTP/1.1).
     * </p>
     * <p>
     * The code in your model is responsible for setting or updating any custom attributes in the response. If your code
     * does not set this value in the response, an empty value is returned. For example, if a custom attribute
     * represents the trace ID, your model can prepend the custom attribute with <code>Trace ID:</code> in your
     * post-processing function.
     * </p>
     * <p>
     * This feature is currently supported in the AWS SDKs but not in the Amazon SageMaker Python SDK.
     * </p>
     * 
     * @return Provides additional information about a request for an inference submitted to a model hosted at an Amazon
     *         SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this
     *         value, for example, to provide an ID that you can use to track a request or to provide other metadata
     *         that a service endpoint was programmed to process. The value must consist of no more than 1024 visible
     *         US-ASCII characters as specified in <a href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section
     *         3.3.6. Field Value Components</a> of the Hypertext Transfer Protocol (HTTP/1.1). </p>
     *         <p>
     *         The code in your model is responsible for setting or updating any custom attributes in the response. If
     *         your code does not set this value in the response, an empty value is returned. For example, if a custom
     *         attribute represents the trace ID, your model can prepend the custom attribute with
     *         <code>Trace ID:</code> in your post-processing function.
     *         </p>
     *         <p>
     *         This feature is currently supported in the AWS SDKs but not in the Amazon SageMaker Python SDK.
     */
    public final String customAttributes() {
        return customAttributes;
    }

    /**
     * <p>
     * The model to request for inference when invoking a multi-model endpoint.
     * </p>
     * 
     * @return The model to request for inference when invoking a multi-model endpoint.
     */
    public final String targetModel() {
        return targetModel;
    }

    /**
     * <p>
     * Specify the production variant to send the inference request to when invoking an endpoint that is running two or
     * more variants. Note that this parameter overrides the default behavior for the endpoint, which is to distribute
     * the invocation traffic based on the variant weights.
     * </p>
     * <p>
     * For information about how to use variant targeting to perform a/b testing, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html">Test models in production</a>
     * </p>
     * 
     * @return Specify the production variant to send the inference request to when invoking an endpoint that is running
     *         two or more variants. Note that this parameter overrides the default behavior for the endpoint, which is
     *         to distribute the invocation traffic based on the variant weights.</p>
     *         <p>
     *         For information about how to use variant targeting to perform a/b testing, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html">Test models in
     *         production</a>
     */
    public final String targetVariant() {
        return targetVariant;
    }

    /**
     * <p>
     * If you provide a value, it is added to the captured data when you enable data capture on the endpoint. For
     * information about data capture, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html">Capture Data</a>.
     * </p>
     * 
     * @return If you provide a value, it is added to the captured data when you enable data capture on the endpoint.
     *         For information about data capture, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html">Capture Data</a>.
     */
    public final String inferenceId() {
        return inferenceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(accept());
        hashCode = 31 * hashCode + Objects.hashCode(customAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(targetModel());
        hashCode = 31 * hashCode + Objects.hashCode(targetVariant());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeEndpointRequest)) {
            return false;
        }
        InvokeEndpointRequest other = (InvokeEndpointRequest) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(body(), other.body())
                && Objects.equals(contentType(), other.contentType()) && Objects.equals(accept(), other.accept())
                && Objects.equals(customAttributes(), other.customAttributes())
                && Objects.equals(targetModel(), other.targetModel()) && Objects.equals(targetVariant(), other.targetVariant())
                && Objects.equals(inferenceId(), other.inferenceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeEndpointRequest").add("EndpointName", endpointName())
                .add("Body", body() == null ? null : "*** Sensitive Data Redacted ***").add("ContentType", contentType())
                .add("Accept", accept())
                .add("CustomAttributes", customAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TargetModel", targetModel()).add("TargetVariant", targetVariant()).add("InferenceId", inferenceId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "Accept":
            return Optional.ofNullable(clazz.cast(accept()));
        case "CustomAttributes":
            return Optional.ofNullable(clazz.cast(customAttributes()));
        case "TargetModel":
            return Optional.ofNullable(clazz.cast(targetModel()));
        case "TargetVariant":
            return Optional.ofNullable(clazz.cast(targetVariant()));
        case "InferenceId":
            return Optional.ofNullable(clazz.cast(inferenceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeEndpointRequest, T> g) {
        return obj -> g.apply((InvokeEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, InvokeEndpointRequest> {
        /**
         * <p>
         * The name of the endpoint that you specified when you created the endpoint using the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html">CreateEndpoint</a> API.
         * </p>
         * 
         * @param endpointName
         *        The name of the endpoint that you specified when you created the endpoint using the <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html">CreateEndpoint</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * Provides input data, in the format specified in the <code>ContentType</code> request header. Amazon SageMaker
         * passes all of the data in the body to the model.
         * </p>
         * <p>
         * For information about the format of the request body, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html">Common Data Formats-Inference</a>.
         * </p>
         * 
         * @param body
         *        Provides input data, in the format specified in the <code>ContentType</code> request header. Amazon
         *        SageMaker passes all of the data in the body to the model. </p>
         *        <p>
         *        For information about the format of the request body, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html">Common Data
         *        Formats-Inference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(SdkBytes body);

        /**
         * <p>
         * The MIME type of the input data in the request body.
         * </p>
         * 
         * @param contentType
         *        The MIME type of the input data in the request body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The desired MIME type of the inference in the response.
         * </p>
         * 
         * @param accept
         *        The desired MIME type of the inference in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accept(String accept);

        /**
         * <p>
         * Provides additional information about a request for an inference submitted to a model hosted at an Amazon
         * SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value,
         * for example, to provide an ID that you can use to track a request or to provide other metadata that a service
         * endpoint was programmed to process. The value must consist of no more than 1024 visible US-ASCII characters
         * as specified in <a href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value
         * Components</a> of the Hypertext Transfer Protocol (HTTP/1.1).
         * </p>
         * <p>
         * The code in your model is responsible for setting or updating any custom attributes in the response. If your
         * code does not set this value in the response, an empty value is returned. For example, if a custom attribute
         * represents the trace ID, your model can prepend the custom attribute with <code>Trace ID:</code> in your
         * post-processing function.
         * </p>
         * <p>
         * This feature is currently supported in the AWS SDKs but not in the Amazon SageMaker Python SDK.
         * </p>
         * 
         * @param customAttributes
         *        Provides additional information about a request for an inference submitted to a model hosted at an
         *        Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could
         *        use this value, for example, to provide an ID that you can use to track a request or to provide other
         *        metadata that a service endpoint was programmed to process. The value must consist of no more than
         *        1024 visible US-ASCII characters as specified in <a
         *        href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of
         *        the Hypertext Transfer Protocol (HTTP/1.1). </p>
         *        <p>
         *        The code in your model is responsible for setting or updating any custom attributes in the response.
         *        If your code does not set this value in the response, an empty value is returned. For example, if a
         *        custom attribute represents the trace ID, your model can prepend the custom attribute with
         *        <code>Trace ID:</code> in your post-processing function.
         *        </p>
         *        <p>
         *        This feature is currently supported in the AWS SDKs but not in the Amazon SageMaker Python SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAttributes(String customAttributes);

        /**
         * <p>
         * The model to request for inference when invoking a multi-model endpoint.
         * </p>
         * 
         * @param targetModel
         *        The model to request for inference when invoking a multi-model endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetModel(String targetModel);

        /**
         * <p>
         * Specify the production variant to send the inference request to when invoking an endpoint that is running two
         * or more variants. Note that this parameter overrides the default behavior for the endpoint, which is to
         * distribute the invocation traffic based on the variant weights.
         * </p>
         * <p>
         * For information about how to use variant targeting to perform a/b testing, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html">Test models in production</a>
         * </p>
         * 
         * @param targetVariant
         *        Specify the production variant to send the inference request to when invoking an endpoint that is
         *        running two or more variants. Note that this parameter overrides the default behavior for the
         *        endpoint, which is to distribute the invocation traffic based on the variant weights.</p>
         *        <p>
         *        For information about how to use variant targeting to perform a/b testing, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html">Test models in
         *        production</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVariant(String targetVariant);

        /**
         * <p>
         * If you provide a value, it is added to the captured data when you enable data capture on the endpoint. For
         * information about data capture, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html">Capture Data</a>.
         * </p>
         * 
         * @param inferenceId
         *        If you provide a value, it is added to the captured data when you enable data capture on the endpoint.
         *        For information about data capture, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html">Capture
         *        Data</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceId(String inferenceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRuntimeRequest.BuilderImpl implements Builder {
        private String endpointName;

        private SdkBytes body;

        private String contentType;

        private String accept;

        private String customAttributes;

        private String targetModel;

        private String targetVariant;

        private String inferenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeEndpointRequest model) {
            super(model);
            endpointName(model.endpointName);
            body(model.body);
            contentType(model.contentType);
            accept(model.accept);
            customAttributes(model.customAttributes);
            targetModel(model.targetModel);
            targetVariant(model.targetVariant);
            inferenceId(model.inferenceId);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final ByteBuffer getBody() {
            return body == null ? null : body.asByteBuffer();
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = StandardMemberCopier.copy(body);
            return this;
        }

        public final void setBody(ByteBuffer body) {
            body(body == null ? null : SdkBytes.fromByteBuffer(body));
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getAccept() {
            return accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        public final String getCustomAttributes() {
            return customAttributes;
        }

        @Override
        public final Builder customAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public final void setCustomAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
        }

        public final String getTargetModel() {
            return targetModel;
        }

        @Override
        public final Builder targetModel(String targetModel) {
            this.targetModel = targetModel;
            return this;
        }

        public final void setTargetModel(String targetModel) {
            this.targetModel = targetModel;
        }

        public final String getTargetVariant() {
            return targetVariant;
        }

        @Override
        public final Builder targetVariant(String targetVariant) {
            this.targetVariant = targetVariant;
            return this;
        }

        public final void setTargetVariant(String targetVariant) {
            this.targetVariant = targetVariant;
        }

        public final String getInferenceId() {
            return inferenceId;
        }

        @Override
        public final Builder inferenceId(String inferenceId) {
            this.inferenceId = inferenceId;
            return this;
        }

        public final void setInferenceId(String inferenceId) {
            this.inferenceId = inferenceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeEndpointRequest build() {
            return new InvokeEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
