/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerruntime.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeEndpointResponse extends SageMakerRuntimeResponse implements
        ToCopyableBuilder<InvokeEndpointResponse.Builder, InvokeEndpointResponse> {
    private static final SdkField<SdkBytes> BODY_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(InvokeEndpointResponse::body))
            .setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InvokeEndpointResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> INVOKED_PRODUCTION_VARIANT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InvokeEndpointResponse::invokedProductionVariant))
            .setter(setter(Builder::invokedProductionVariant))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-Amzn-Invoked-Production-Variant")
                    .build()).build();

    private static final SdkField<String> CUSTOM_ATTRIBUTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InvokeEndpointResponse::customAttributes))
            .setter(setter(Builder::customAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Custom-Attributes")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD,
            CONTENT_TYPE_FIELD, INVOKED_PRODUCTION_VARIANT_FIELD, CUSTOM_ATTRIBUTES_FIELD));

    private final SdkBytes body;

    private final String contentType;

    private final String invokedProductionVariant;

    private final String customAttributes;

    private InvokeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.invokedProductionVariant = builder.invokedProductionVariant;
        this.customAttributes = builder.customAttributes;
    }

    /**
     * <p>
     * Includes the inference provided by the model.
     * </p>
     * <p>
     * For information about the format of the response body, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html">Common Data Formats—Inference</a>.
     * </p>
     * 
     * @return Includes the inference provided by the model.</p>
     *         <p>
     *         For information about the format of the response body, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html">Common Data
     *         Formats—Inference</a>.
     */
    public SdkBytes body() {
        return body;
    }

    /**
     * <p>
     * The MIME type of the inference returned in the response body.
     * </p>
     * 
     * @return The MIME type of the inference returned in the response body.
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p>
     * Identifies the production variant that was invoked.
     * </p>
     * 
     * @return Identifies the production variant that was invoked.
     */
    public String invokedProductionVariant() {
        return invokedProductionVariant;
    }

    /**
     * <p>
     * Provides additional information in the response about the inference returned by a model hosted at an Amazon
     * SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for
     * example, to return an ID received in the <code>CustomAttributes</code> header of a request or other metadata that
     * a service endpoint was programmed to produce. The value must consist of no more than 1024 visible US-ASCII
     * characters as specified in <a href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value
     * Components</a> of the Hypertext Transfer Protocol (HTTP/1.1). If the customer wants the custom attribute
     * returned, the model must set the custom attribute to be included on the way back.
     * </p>
     * <p>
     * This feature is currently supported in the AWS SDKs but not in the Amazon SageMaker Python SDK.
     * </p>
     * 
     * @return Provides additional information in the response about the inference returned by a model hosted at an
     *         Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use
     *         this value, for example, to return an ID received in the <code>CustomAttributes</code> header of a
     *         request or other metadata that a service endpoint was programmed to produce. The value must consist of no
     *         more than 1024 visible US-ASCII characters as specified in <a
     *         href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of the
     *         Hypertext Transfer Protocol (HTTP/1.1). If the customer wants the custom attribute returned, the model
     *         must set the custom attribute to be included on the way back. </p>
     *         <p>
     *         This feature is currently supported in the AWS SDKs but not in the Amazon SageMaker Python SDK.
     */
    public String customAttributes() {
        return customAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(invokedProductionVariant());
        hashCode = 31 * hashCode + Objects.hashCode(customAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeEndpointResponse)) {
            return false;
        }
        InvokeEndpointResponse other = (InvokeEndpointResponse) obj;
        return Objects.equals(body(), other.body()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(invokedProductionVariant(), other.invokedProductionVariant())
                && Objects.equals(customAttributes(), other.customAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InvokeEndpointResponse").add("Body", body() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContentType", contentType()).add("InvokedProductionVariant", invokedProductionVariant())
                .add("CustomAttributes", customAttributes() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "InvokedProductionVariant":
            return Optional.ofNullable(clazz.cast(invokedProductionVariant()));
        case "CustomAttributes":
            return Optional.ofNullable(clazz.cast(customAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeEndpointResponse, T> g) {
        return obj -> g.apply((InvokeEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRuntimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, InvokeEndpointResponse> {
        /**
         * <p>
         * Includes the inference provided by the model.
         * </p>
         * <p>
         * For information about the format of the response body, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html">Common Data Formats—Inference</a>.
         * </p>
         * 
         * @param body
         *        Includes the inference provided by the model.</p>
         *        <p>
         *        For information about the format of the response body, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html">Common Data
         *        Formats—Inference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(SdkBytes body);

        /**
         * <p>
         * The MIME type of the inference returned in the response body.
         * </p>
         * 
         * @param contentType
         *        The MIME type of the inference returned in the response body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Identifies the production variant that was invoked.
         * </p>
         * 
         * @param invokedProductionVariant
         *        Identifies the production variant that was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invokedProductionVariant(String invokedProductionVariant);

        /**
         * <p>
         * Provides additional information in the response about the inference returned by a model hosted at an Amazon
         * SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value,
         * for example, to return an ID received in the <code>CustomAttributes</code> header of a request or other
         * metadata that a service endpoint was programmed to produce. The value must consist of no more than 1024
         * visible US-ASCII characters as specified in <a
         * href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of the
         * Hypertext Transfer Protocol (HTTP/1.1). If the customer wants the custom attribute returned, the model must
         * set the custom attribute to be included on the way back.
         * </p>
         * <p>
         * This feature is currently supported in the AWS SDKs but not in the Amazon SageMaker Python SDK.
         * </p>
         * 
         * @param customAttributes
         *        Provides additional information in the response about the inference returned by a model hosted at an
         *        Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could
         *        use this value, for example, to return an ID received in the <code>CustomAttributes</code> header of a
         *        request or other metadata that a service endpoint was programmed to produce. The value must consist of
         *        no more than 1024 visible US-ASCII characters as specified in <a
         *        href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of
         *        the Hypertext Transfer Protocol (HTTP/1.1). If the customer wants the custom attribute returned, the
         *        model must set the custom attribute to be included on the way back. </p>
         *        <p>
         *        This feature is currently supported in the AWS SDKs but not in the Amazon SageMaker Python SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAttributes(String customAttributes);
    }

    static final class BuilderImpl extends SageMakerRuntimeResponse.BuilderImpl implements Builder {
        private SdkBytes body;

        private String contentType;

        private String invokedProductionVariant;

        private String customAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeEndpointResponse model) {
            super(model);
            body(model.body);
            contentType(model.contentType);
            invokedProductionVariant(model.invokedProductionVariant);
            customAttributes(model.customAttributes);
        }

        public final ByteBuffer getBody() {
            return body == null ? null : body.asByteBuffer();
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = StandardMemberCopier.copy(body);
            return this;
        }

        public final void setBody(ByteBuffer body) {
            body(body == null ? null : SdkBytes.fromByteBuffer(body));
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getInvokedProductionVariant() {
            return invokedProductionVariant;
        }

        @Override
        public final Builder invokedProductionVariant(String invokedProductionVariant) {
            this.invokedProductionVariant = invokedProductionVariant;
            return this;
        }

        public final void setInvokedProductionVariant(String invokedProductionVariant) {
            this.invokedProductionVariant = invokedProductionVariant;
        }

        public final String getCustomAttributes() {
            return customAttributes;
        }

        @Override
        public final Builder customAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public final void setCustomAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
        }

        @Override
        public InvokeEndpointResponse build() {
            return new InvokeEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
