/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Model (owned by the customer in the container) returned 4xx or 5xx error code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelErrorException extends SageMakerRuntimeException implements
        ToCopyableBuilder<ModelErrorException.Builder, ModelErrorException> {
    private static final SdkField<Integer> ORIGINAL_STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModelErrorException::originalStatusCode)).setter(setter(Builder::originalStatusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalStatusCode").build())
            .build();

    private static final SdkField<String> ORIGINAL_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelErrorException::originalMessage)).setter(setter(Builder::originalMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalMessage").build()).build();

    private static final SdkField<String> LOG_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelErrorException::logStreamArn)).setter(setter(Builder::logStreamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStreamArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGINAL_STATUS_CODE_FIELD,
            ORIGINAL_MESSAGE_FIELD, LOG_STREAM_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer originalStatusCode;

    private final String originalMessage;

    private final String logStreamArn;

    private ModelErrorException(BuilderImpl builder) {
        super(builder);
        this.originalStatusCode = builder.originalStatusCode;
        this.originalMessage = builder.originalMessage;
        this.logStreamArn = builder.logStreamArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * Original status code.
     * </p>
     * 
     * @return Original status code.
     */
    public Integer originalStatusCode() {
        return originalStatusCode;
    }

    /**
     * <p>
     * Original message.
     * </p>
     * 
     * @return Original message.
     */
    public String originalMessage() {
        return originalMessage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the log stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the log stream.
     */
    public String logStreamArn() {
        return logStreamArn;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelErrorException, T> g) {
        return obj -> g.apply((ModelErrorException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelErrorException>, SageMakerRuntimeException.Builder {
        /**
         * <p>
         * Original status code.
         * </p>
         * 
         * @param originalStatusCode
         *        Original status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalStatusCode(Integer originalStatusCode);

        /**
         * <p>
         * Original message.
         * </p>
         * 
         * @param originalMessage
         *        Original message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalMessage(String originalMessage);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the log stream.
         * </p>
         * 
         * @param logStreamArn
         *        The Amazon Resource Name (ARN) of the log stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamArn(String logStreamArn);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends SageMakerRuntimeException.BuilderImpl implements Builder {
        private Integer originalStatusCode;

        private String originalMessage;

        private String logStreamArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelErrorException model) {
            super(model);
            originalStatusCode(model.originalStatusCode);
            originalMessage(model.originalMessage);
            logStreamArn(model.logStreamArn);
        }

        public final Integer getOriginalStatusCode() {
            return originalStatusCode;
        }

        @Override
        public final Builder originalStatusCode(Integer originalStatusCode) {
            this.originalStatusCode = originalStatusCode;
            return this;
        }

        public final void setOriginalStatusCode(Integer originalStatusCode) {
            this.originalStatusCode = originalStatusCode;
        }

        public final String getOriginalMessage() {
            return originalMessage;
        }

        @Override
        public final Builder originalMessage(String originalMessage) {
            this.originalMessage = originalMessage;
            return this;
        }

        public final void setOriginalMessage(String originalMessage) {
            this.originalMessage = originalMessage;
        }

        public final String getLogStreamArn() {
            return logStreamArn;
        }

        @Override
        public final Builder logStreamArn(String logStreamArn) {
            this.logStreamArn = logStreamArn;
            return this;
        }

        public final void setLogStreamArn(String logStreamArn) {
            this.logStreamArn = logStreamArn;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ModelErrorException build() {
            return new ModelErrorException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
