/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakermetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error that occured when putting the metric data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutMetricsError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchPutMetricsError.Builder, BatchPutMetricsError> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(BatchPutMetricsError::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<Integer> METRIC_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MetricIndex").getter(getter(BatchPutMetricsError::metricIndex)).setter(setter(Builder::metricIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CODE_FIELD, METRIC_INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final Integer metricIndex;

    private BatchPutMetricsError(BuilderImpl builder) {
        this.code = builder.code;
        this.metricIndex = builder.metricIndex;
    }

    /**
     * <p>
     * The error code of an error that occured when attempting to put metrics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>METRIC_LIMIT_EXCEEDED</code>: The maximum amount of metrics per resource is exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERNAL_ERROR</code>: An internal error occured.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VALIDATION_ERROR</code>: The metric data failed validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONFLICT_ERROR</code>: Multiple requests attempted to modify the same data simultaneously.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link PutMetricsErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The error code of an error that occured when attempting to put metrics.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>METRIC_LIMIT_EXCEEDED</code>: The maximum amount of metrics per resource is exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERNAL_ERROR</code>: An internal error occured.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VALIDATION_ERROR</code>: The metric data failed validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONFLICT_ERROR</code>: Multiple requests attempted to modify the same data simultaneously.
     *         </p>
     *         </li>
     * @see PutMetricsErrorCode
     */
    public final PutMetricsErrorCode code() {
        return PutMetricsErrorCode.fromValue(code);
    }

    /**
     * <p>
     * The error code of an error that occured when attempting to put metrics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>METRIC_LIMIT_EXCEEDED</code>: The maximum amount of metrics per resource is exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERNAL_ERROR</code>: An internal error occured.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VALIDATION_ERROR</code>: The metric data failed validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONFLICT_ERROR</code>: Multiple requests attempted to modify the same data simultaneously.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link PutMetricsErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The error code of an error that occured when attempting to put metrics.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>METRIC_LIMIT_EXCEEDED</code>: The maximum amount of metrics per resource is exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERNAL_ERROR</code>: An internal error occured.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VALIDATION_ERROR</code>: The metric data failed validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONFLICT_ERROR</code>: Multiple requests attempted to modify the same data simultaneously.
     *         </p>
     *         </li>
     * @see PutMetricsErrorCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * An index that corresponds to the metric in the request.
     * </p>
     * 
     * @return An index that corresponds to the metric in the request.
     */
    public final Integer metricIndex() {
        return metricIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutMetricsError)) {
            return false;
        }
        BatchPutMetricsError other = (BatchPutMetricsError) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(metricIndex(), other.metricIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutMetricsError").add("Code", codeAsString()).add("MetricIndex", metricIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "MetricIndex":
            return Optional.ofNullable(clazz.cast(metricIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Code", CODE_FIELD);
        map.put("MetricIndex", METRIC_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchPutMetricsError, T> g) {
        return obj -> g.apply((BatchPutMetricsError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchPutMetricsError> {
        /**
         * <p>
         * The error code of an error that occured when attempting to put metrics.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>METRIC_LIMIT_EXCEEDED</code>: The maximum amount of metrics per resource is exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERNAL_ERROR</code>: An internal error occured.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VALIDATION_ERROR</code>: The metric data failed validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONFLICT_ERROR</code>: Multiple requests attempted to modify the same data simultaneously.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The error code of an error that occured when attempting to put metrics.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>METRIC_LIMIT_EXCEEDED</code>: The maximum amount of metrics per resource is exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERNAL_ERROR</code>: An internal error occured.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VALIDATION_ERROR</code>: The metric data failed validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONFLICT_ERROR</code>: Multiple requests attempted to modify the same data simultaneously.
         *        </p>
         *        </li>
         * @see PutMetricsErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PutMetricsErrorCode
         */
        Builder code(String code);

        /**
         * <p>
         * The error code of an error that occured when attempting to put metrics.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>METRIC_LIMIT_EXCEEDED</code>: The maximum amount of metrics per resource is exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERNAL_ERROR</code>: An internal error occured.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VALIDATION_ERROR</code>: The metric data failed validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONFLICT_ERROR</code>: Multiple requests attempted to modify the same data simultaneously.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The error code of an error that occured when attempting to put metrics.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>METRIC_LIMIT_EXCEEDED</code>: The maximum amount of metrics per resource is exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERNAL_ERROR</code>: An internal error occured.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VALIDATION_ERROR</code>: The metric data failed validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONFLICT_ERROR</code>: Multiple requests attempted to modify the same data simultaneously.
         *        </p>
         *        </li>
         * @see PutMetricsErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PutMetricsErrorCode
         */
        Builder code(PutMetricsErrorCode code);

        /**
         * <p>
         * An index that corresponds to the metric in the request.
         * </p>
         * 
         * @param metricIndex
         *        An index that corresponds to the metric in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricIndex(Integer metricIndex);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private Integer metricIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutMetricsError model) {
            code(model.code);
            metricIndex(model.metricIndex);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(PutMetricsErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final Integer getMetricIndex() {
            return metricIndex;
        }

        public final void setMetricIndex(Integer metricIndex) {
            this.metricIndex = metricIndex;
        }

        @Override
        public final Builder metricIndex(Integer metricIndex) {
            this.metricIndex = metricIndex;
            return this;
        }

        @Override
        public BatchPutMetricsError build() {
            return new BatchPutMetricsError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
