/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakermetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetMetricsResponse extends SageMakerMetricsResponse implements
        ToCopyableBuilder<BatchGetMetricsResponse.Builder, BatchGetMetricsResponse> {
    private static final SdkField<List<MetricQueryResult>> METRIC_QUERY_RESULTS_FIELD = SdkField
            .<List<MetricQueryResult>> builder(MarshallingType.LIST)
            .memberName("MetricQueryResults")
            .getter(getter(BatchGetMetricsResponse::metricQueryResults))
            .setter(setter(Builder::metricQueryResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricQueryResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricQueryResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricQueryResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_QUERY_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MetricQueryResult> metricQueryResults;

    private BatchGetMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.metricQueryResults = builder.metricQueryResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricQueryResults property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricQueryResults() {
        return metricQueryResults != null && !(metricQueryResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results of a query to retrieve training metrics from SageMaker.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricQueryResults} method.
     * </p>
     * 
     * @return The results of a query to retrieve training metrics from SageMaker.
     */
    public final List<MetricQueryResult> metricQueryResults() {
        return metricQueryResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricQueryResults() ? metricQueryResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetMetricsResponse)) {
            return false;
        }
        BatchGetMetricsResponse other = (BatchGetMetricsResponse) obj;
        return hasMetricQueryResults() == other.hasMetricQueryResults()
                && Objects.equals(metricQueryResults(), other.metricQueryResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetMetricsResponse")
                .add("MetricQueryResults", hasMetricQueryResults() ? metricQueryResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricQueryResults":
            return Optional.ofNullable(clazz.cast(metricQueryResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricQueryResults", METRIC_QUERY_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetMetricsResponse, T> g) {
        return obj -> g.apply((BatchGetMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerMetricsResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetMetricsResponse> {
        /**
         * <p>
         * The results of a query to retrieve training metrics from SageMaker.
         * </p>
         * 
         * @param metricQueryResults
         *        The results of a query to retrieve training metrics from SageMaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricQueryResults(Collection<MetricQueryResult> metricQueryResults);

        /**
         * <p>
         * The results of a query to retrieve training metrics from SageMaker.
         * </p>
         * 
         * @param metricQueryResults
         *        The results of a query to retrieve training metrics from SageMaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricQueryResults(MetricQueryResult... metricQueryResults);

        /**
         * <p>
         * The results of a query to retrieve training metrics from SageMaker.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakermetrics.model.MetricQueryResult.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemakermetrics.model.MetricQueryResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakermetrics.model.MetricQueryResult.Builder#build()} is called
         * immediately and its result is passed to {@link #metricQueryResults(List<MetricQueryResult>)}.
         * 
         * @param metricQueryResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakermetrics.model.MetricQueryResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricQueryResults(java.util.Collection<MetricQueryResult>)
         */
        Builder metricQueryResults(Consumer<MetricQueryResult.Builder>... metricQueryResults);
    }

    static final class BuilderImpl extends SageMakerMetricsResponse.BuilderImpl implements Builder {
        private List<MetricQueryResult> metricQueryResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetMetricsResponse model) {
            super(model);
            metricQueryResults(model.metricQueryResults);
        }

        public final List<MetricQueryResult.Builder> getMetricQueryResults() {
            List<MetricQueryResult.Builder> result = MetricQueryResultListCopier.copyToBuilder(this.metricQueryResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricQueryResults(Collection<MetricQueryResult.BuilderImpl> metricQueryResults) {
            this.metricQueryResults = MetricQueryResultListCopier.copyFromBuilder(metricQueryResults);
        }

        @Override
        public final Builder metricQueryResults(Collection<MetricQueryResult> metricQueryResults) {
            this.metricQueryResults = MetricQueryResultListCopier.copy(metricQueryResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricQueryResults(MetricQueryResult... metricQueryResults) {
            metricQueryResults(Arrays.asList(metricQueryResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricQueryResults(Consumer<MetricQueryResult.Builder>... metricQueryResults) {
            metricQueryResults(Stream.of(metricQueryResults).map(c -> MetricQueryResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetMetricsResponse build() {
            return new BatchGetMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
