/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakermetrics;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sagemakermetrics.DefaultSageMakerMetricsBaseClientBuilder;
import software.amazon.awssdk.services.sagemakermetrics.DefaultSageMakerMetricsClient;
import software.amazon.awssdk.services.sagemakermetrics.SageMakerMetricsClient;
import software.amazon.awssdk.services.sagemakermetrics.SageMakerMetricsClientBuilder;
import software.amazon.awssdk.services.sagemakermetrics.SageMakerMetricsServiceClientConfiguration;
import software.amazon.awssdk.services.sagemakermetrics.endpoints.SageMakerMetricsEndpointProvider;

@SdkInternalApi
final class DefaultSageMakerMetricsClientBuilder
extends DefaultSageMakerMetricsBaseClientBuilder<SageMakerMetricsClientBuilder, SageMakerMetricsClient>
implements SageMakerMetricsClientBuilder {
    DefaultSageMakerMetricsClientBuilder() {
    }

    @Override
    public DefaultSageMakerMetricsClientBuilder endpointProvider(SageMakerMetricsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SageMakerMetricsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSageMakerMetricsClientBuilder.validateClientOptions(clientConfiguration);
        SageMakerMetricsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSageMakerMetricsClient client = new DefaultSageMakerMetricsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SageMakerMetricsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SageMakerMetricsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

