/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AlgorithmNameResampling {
    NEAR("NEAR"),
    BILINEAR("BILINEAR"),
    CUBIC("CUBIC"),
    CUBICSPLINE("CUBICSPLINE"),
    LANCZOS("LANCZOS"),
    AVERAGE("AVERAGE"),
    RMS("RMS"),
    MODE("MODE"),
    MAX("MAX"),
    MIN("MIN"),
    MED("MED"),
    Q1("Q1"),
    Q3("Q3"),
    SUM("SUM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AlgorithmNameResampling> VALUE_MAP;
    private final String value;

    private AlgorithmNameResampling(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AlgorithmNameResampling fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AlgorithmNameResampling> knownValues() {
        EnumSet<AlgorithmNameResampling> knownValues = EnumSet.allOf(AlgorithmNameResampling.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AlgorithmNameResampling.class, AlgorithmNameResampling::toString);
    }
}

