/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakergeospatial.model.OutputType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Operation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Operation> {
    private static final SdkField<String> EQUATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Equation").getter(Operation.getter(Operation::equation)).setter(Operation.setter(Builder::equation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Equation").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Operation.getter(Operation::name)).setter(Operation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputType").getter(Operation.getter(Operation::outputTypeAsString)).setter(Operation.setter(Builder::outputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQUATION_FIELD, NAME_FIELD, OUTPUT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Equation", EQUATION_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("OutputType", OUTPUT_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String equation;
    private final String name;
    private final String outputType;

    private Operation(BuilderImpl builder) {
        this.equation = builder.equation;
        this.name = builder.name;
        this.outputType = builder.outputType;
    }

    public final String equation() {
        return this.equation;
    }

    public final String name() {
        return this.name;
    }

    public final OutputType outputType() {
        return OutputType.fromValue(this.outputType);
    }

    public final String outputTypeAsString() {
        return this.outputType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.equation());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)obj;
        return Objects.equals(this.equation(), other.equation()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.outputTypeAsString(), other.outputTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Operation").add("Equation", (Object)this.equation()).add("Name", (Object)this.name()).add("OutputType", (Object)this.outputTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Equation": {
                return Optional.ofNullable(clazz.cast(this.equation()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OutputType": {
                return Optional.ofNullable(clazz.cast(this.outputTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Operation, T> g) {
        return obj -> g.apply((Operation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String equation;
        private String name;
        private String outputType;

        private BuilderImpl() {
        }

        private BuilderImpl(Operation model) {
            this.equation(model.equation);
            this.name(model.name);
            this.outputType(model.outputType);
        }

        public final String getEquation() {
            return this.equation;
        }

        public final void setEquation(String equation) {
            this.equation = equation;
        }

        @Override
        public final Builder equation(String equation) {
            this.equation = equation;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOutputType() {
            return this.outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        @Override
        public final Builder outputType(OutputType outputType) {
            this.outputType(outputType == null ? null : outputType.toString());
            return this;
        }

        public Operation build() {
            return new Operation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Operation> {
        public Builder equation(String var1);

        public Builder name(String var1);

        public Builder outputType(String var1);

        public Builder outputType(OutputType var1);
    }
}

