/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig;
import software.amazon.awssdk.services.sagemakergeospatial.model.SageMakerGeospatialResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobExportStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportVectorEnrichmentJobResponse
extends SageMakerGeospatialResponse
implements ToCopyableBuilder<Builder, ExportVectorEnrichmentJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ExportVectorEnrichmentJobResponse.getter(ExportVectorEnrichmentJobResponse::arn)).setter(ExportVectorEnrichmentJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ExportVectorEnrichmentJobResponse.getter(ExportVectorEnrichmentJobResponse::creationTime)).setter(ExportVectorEnrichmentJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(ExportVectorEnrichmentJobResponse.getter(ExportVectorEnrichmentJobResponse::executionRoleArn)).setter(ExportVectorEnrichmentJobResponse.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportStatus").getter(ExportVectorEnrichmentJobResponse.getter(ExportVectorEnrichmentJobResponse::exportStatusAsString)).setter(ExportVectorEnrichmentJobResponse.setter(Builder::exportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()}).build();
    private static final SdkField<ExportVectorEnrichmentJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(ExportVectorEnrichmentJobResponse.getter(ExportVectorEnrichmentJobResponse::outputConfig)).setter(ExportVectorEnrichmentJobResponse.setter(Builder::outputConfig)).constructor(ExportVectorEnrichmentJobOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, EXECUTION_ROLE_ARN_FIELD, EXPORT_STATUS_FIELD, OUTPUT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
            this.put("ExportStatus", EXPORT_STATUS_FIELD);
            this.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        }
    });
    private final String arn;
    private final Instant creationTime;
    private final String executionRoleArn;
    private final String exportStatus;
    private final ExportVectorEnrichmentJobOutputConfig outputConfig;

    private ExportVectorEnrichmentJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.executionRoleArn = builder.executionRoleArn;
        this.exportStatus = builder.exportStatus;
        this.outputConfig = builder.outputConfig;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final VectorEnrichmentJobExportStatus exportStatus() {
        return VectorEnrichmentJobExportStatus.fromValue(this.exportStatus);
    }

    public final String exportStatusAsString() {
        return this.exportStatus;
    }

    public final ExportVectorEnrichmentJobOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportVectorEnrichmentJobResponse)) {
            return false;
        }
        ExportVectorEnrichmentJobResponse other = (ExportVectorEnrichmentJobResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.exportStatusAsString(), other.exportStatusAsString()) && Objects.equals(this.outputConfig(), other.outputConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ExportVectorEnrichmentJobResponse").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("ExportStatus", (Object)this.exportStatusAsString()).add("OutputConfig", (Object)this.outputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "ExportStatus": {
                return Optional.ofNullable(clazz.cast(this.exportStatusAsString()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExportVectorEnrichmentJobResponse, T> g) {
        return obj -> g.apply((ExportVectorEnrichmentJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerGeospatialResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationTime;
        private String executionRoleArn;
        private String exportStatus;
        private ExportVectorEnrichmentJobOutputConfig outputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportVectorEnrichmentJobResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.executionRoleArn(model.executionRoleArn);
            this.exportStatus(model.exportStatus);
            this.outputConfig(model.outputConfig);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getExportStatus() {
            return this.exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(VectorEnrichmentJobExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final ExportVectorEnrichmentJobOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ExportVectorEnrichmentJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ExportVectorEnrichmentJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        @Override
        public ExportVectorEnrichmentJobResponse build() {
            return new ExportVectorEnrichmentJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerGeospatialResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportVectorEnrichmentJobResponse> {
        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder executionRoleArn(String var1);

        public Builder exportStatus(String var1);

        public Builder exportStatus(VectorEnrichmentJobExportStatus var1);

        public Builder outputConfig(ExportVectorEnrichmentJobOutputConfig var1);

        default public Builder outputConfig(Consumer<ExportVectorEnrichmentJobOutputConfig.Builder> outputConfig) {
            return this.outputConfig((ExportVectorEnrichmentJobOutputConfig)((ExportVectorEnrichmentJobOutputConfig.Builder)ExportVectorEnrichmentJobOutputConfig.builder().applyMutation(outputConfig)).build());
        }
    }
}

