/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig;
import software.amazon.awssdk.services.sagemakergeospatial.model.SageMakerGeospatialResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVectorEnrichmentJobsResponse
extends SageMakerGeospatialResponse
implements ToCopyableBuilder<Builder, ListVectorEnrichmentJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListVectorEnrichmentJobsResponse.getter(ListVectorEnrichmentJobsResponse::nextToken)).setter(ListVectorEnrichmentJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ListVectorEnrichmentJobOutputConfig>> VECTOR_ENRICHMENT_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VectorEnrichmentJobSummaries").getter(ListVectorEnrichmentJobsResponse.getter(ListVectorEnrichmentJobsResponse::vectorEnrichmentJobSummaries)).setter(ListVectorEnrichmentJobsResponse.setter(Builder::vectorEnrichmentJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VectorEnrichmentJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListVectorEnrichmentJobOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VECTOR_ENRICHMENT_JOB_SUMMARIES_FIELD));
    private final String nextToken;
    private final List<ListVectorEnrichmentJobOutputConfig> vectorEnrichmentJobSummaries;

    private ListVectorEnrichmentJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vectorEnrichmentJobSummaries = builder.vectorEnrichmentJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasVectorEnrichmentJobSummaries() {
        return this.vectorEnrichmentJobSummaries != null && !(this.vectorEnrichmentJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<ListVectorEnrichmentJobOutputConfig> vectorEnrichmentJobSummaries() {
        return this.vectorEnrichmentJobSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVectorEnrichmentJobSummaries() ? this.vectorEnrichmentJobSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVectorEnrichmentJobsResponse)) {
            return false;
        }
        ListVectorEnrichmentJobsResponse other = (ListVectorEnrichmentJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasVectorEnrichmentJobSummaries() == other.hasVectorEnrichmentJobSummaries() && Objects.equals(this.vectorEnrichmentJobSummaries(), other.vectorEnrichmentJobSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListVectorEnrichmentJobsResponse").add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).add("VectorEnrichmentJobSummaries", this.hasVectorEnrichmentJobSummaries() ? this.vectorEnrichmentJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "VectorEnrichmentJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.vectorEnrichmentJobSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVectorEnrichmentJobsResponse, T> g) {
        return obj -> g.apply((ListVectorEnrichmentJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerGeospatialResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListVectorEnrichmentJobOutputConfig> vectorEnrichmentJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVectorEnrichmentJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.vectorEnrichmentJobSummaries(model.vectorEnrichmentJobSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListVectorEnrichmentJobOutputConfig.Builder> getVectorEnrichmentJobSummaries() {
            List<ListVectorEnrichmentJobOutputConfig.Builder> result = VectorEnrichmentJobListCopier.copyToBuilder(this.vectorEnrichmentJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVectorEnrichmentJobSummaries(Collection<ListVectorEnrichmentJobOutputConfig.BuilderImpl> vectorEnrichmentJobSummaries) {
            this.vectorEnrichmentJobSummaries = VectorEnrichmentJobListCopier.copyFromBuilder(vectorEnrichmentJobSummaries);
        }

        @Override
        public final Builder vectorEnrichmentJobSummaries(Collection<ListVectorEnrichmentJobOutputConfig> vectorEnrichmentJobSummaries) {
            this.vectorEnrichmentJobSummaries = VectorEnrichmentJobListCopier.copy(vectorEnrichmentJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectorEnrichmentJobSummaries(ListVectorEnrichmentJobOutputConfig ... vectorEnrichmentJobSummaries) {
            this.vectorEnrichmentJobSummaries(Arrays.asList(vectorEnrichmentJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectorEnrichmentJobSummaries(Consumer<ListVectorEnrichmentJobOutputConfig.Builder> ... vectorEnrichmentJobSummaries) {
            this.vectorEnrichmentJobSummaries(Stream.of(vectorEnrichmentJobSummaries).map(c -> (ListVectorEnrichmentJobOutputConfig)((ListVectorEnrichmentJobOutputConfig.Builder)ListVectorEnrichmentJobOutputConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVectorEnrichmentJobsResponse build() {
            return new ListVectorEnrichmentJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerGeospatialResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVectorEnrichmentJobsResponse> {
        public Builder nextToken(String var1);

        public Builder vectorEnrichmentJobSummaries(Collection<ListVectorEnrichmentJobOutputConfig> var1);

        public Builder vectorEnrichmentJobSummaries(ListVectorEnrichmentJobOutputConfig ... var1);

        public Builder vectorEnrichmentJobSummaries(Consumer<ListVectorEnrichmentJobOutputConfig.Builder> ... var1);
    }
}

