/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemakergeospatial.SageMakerGeospatialClient;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse;

public class ListVectorEnrichmentJobsIterable
implements SdkIterable<ListVectorEnrichmentJobsResponse> {
    private final SageMakerGeospatialClient client;
    private final ListVectorEnrichmentJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVectorEnrichmentJobsIterable(SageMakerGeospatialClient client, ListVectorEnrichmentJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVectorEnrichmentJobsResponseFetcher();
    }

    public Iterator<ListVectorEnrichmentJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListVectorEnrichmentJobOutputConfig> vectorEnrichmentJobSummaries() {
        Function<ListVectorEnrichmentJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vectorEnrichmentJobSummaries() != null) {
                return response.vectorEnrichmentJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVectorEnrichmentJobsResponseFetcher
    implements SyncPageFetcher<ListVectorEnrichmentJobsResponse> {
        private ListVectorEnrichmentJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListVectorEnrichmentJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVectorEnrichmentJobsResponse nextPage(ListVectorEnrichmentJobsResponse previousPage) {
            if (previousPage == null) {
                return ListVectorEnrichmentJobsIterable.this.client.listVectorEnrichmentJobs(ListVectorEnrichmentJobsIterable.this.firstRequest);
            }
            return ListVectorEnrichmentJobsIterable.this.client.listVectorEnrichmentJobs((ListVectorEnrichmentJobsRequest)((Object)ListVectorEnrichmentJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

