/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRecordRequest extends SageMakerFeatureStoreRuntimeRequest implements
        ToCopyableBuilder<DeleteRecordRequest.Builder, DeleteRecordRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupName").getter(getter(DeleteRecordRequest::featureGroupName))
            .setter(setter(Builder::featureGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FeatureGroupName").build()).build();

    private static final SdkField<String> RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecordIdentifierValueAsString")
            .getter(getter(DeleteRecordRequest::recordIdentifierValueAsString))
            .setter(setter(Builder::recordIdentifierValueAsString))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RecordIdentifierValueAsString")
                    .build()).build();

    private static final SdkField<String> EVENT_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventTime").getter(getter(DeleteRecordRequest::eventTime)).setter(setter(Builder::eventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EventTime").build()).build();

    private static final SdkField<List<String>> TARGET_STORES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetStores")
            .getter(getter(DeleteRecordRequest::targetStoresAsStrings))
            .setter(setter(Builder::targetStoresWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("TargetStores").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DELETION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeletionMode").getter(getter(DeleteRecordRequest::deletionModeAsString))
            .setter(setter(Builder::deletionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DeletionMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD,
            RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD, EVENT_TIME_FIELD, TARGET_STORES_FIELD, DELETION_MODE_FIELD));

    private final String featureGroupName;

    private final String recordIdentifierValueAsString;

    private final String eventTime;

    private final List<String> targetStores;

    private final String deletionMode;

    private DeleteRecordRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.recordIdentifierValueAsString = builder.recordIdentifierValueAsString;
        this.eventTime = builder.eventTime;
        this.targetStores = builder.targetStores;
        this.deletionMode = builder.deletionMode;
    }

    /**
     * <p>
     * The name of the feature group to delete the record from.
     * </p>
     * 
     * @return The name of the feature group to delete the record from.
     */
    public final String featureGroupName() {
        return featureGroupName;
    }

    /**
     * <p>
     * The value for the <code>RecordIdentifier</code> that uniquely identifies the record, in string format.
     * </p>
     * 
     * @return The value for the <code>RecordIdentifier</code> that uniquely identifies the record, in string format.
     */
    public final String recordIdentifierValueAsString() {
        return recordIdentifierValueAsString;
    }

    /**
     * <p>
     * Timestamp indicating when the deletion event occurred. <code>EventTime</code> can be used to query data at a
     * certain point in time.
     * </p>
     * 
     * @return Timestamp indicating when the deletion event occurred. <code>EventTime</code> can be used to query data
     *         at a certain point in time.
     */
    public final String eventTime() {
        return eventTime;
    }

    /**
     * <p>
     * A list of stores from which you're deleting the record. By default, Feature Store deletes the record from all of
     * the stores that you're using for the <code>FeatureGroup</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetStores} method.
     * </p>
     * 
     * @return A list of stores from which you're deleting the record. By default, Feature Store deletes the record from
     *         all of the stores that you're using for the <code>FeatureGroup</code>.
     */
    public final List<TargetStore> targetStores() {
        return TargetStoresCopier.copyStringToEnum(targetStores);
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetStores property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetStores() {
        return targetStores != null && !(targetStores instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of stores from which you're deleting the record. By default, Feature Store deletes the record from all of
     * the stores that you're using for the <code>FeatureGroup</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetStores} method.
     * </p>
     * 
     * @return A list of stores from which you're deleting the record. By default, Feature Store deletes the record from
     *         all of the stores that you're using for the <code>FeatureGroup</code>.
     */
    public final List<String> targetStoresAsStrings() {
        return targetStores;
    }

    /**
     * <p>
     * The name of the deletion mode for deleting the record. By default, the deletion mode is set to
     * <code>SoftDelete</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deletionMode} will
     * return {@link DeletionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deletionModeAsString}.
     * </p>
     * 
     * @return The name of the deletion mode for deleting the record. By default, the deletion mode is set to
     *         <code>SoftDelete</code>.
     * @see DeletionMode
     */
    public final DeletionMode deletionMode() {
        return DeletionMode.fromValue(deletionMode);
    }

    /**
     * <p>
     * The name of the deletion mode for deleting the record. By default, the deletion mode is set to
     * <code>SoftDelete</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deletionMode} will
     * return {@link DeletionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deletionModeAsString}.
     * </p>
     * 
     * @return The name of the deletion mode for deleting the record. By default, the deletion mode is set to
     *         <code>SoftDelete</code>.
     * @see DeletionMode
     */
    public final String deletionModeAsString() {
        return deletionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(recordIdentifierValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetStores() ? targetStoresAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deletionModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRecordRequest)) {
            return false;
        }
        DeleteRecordRequest other = (DeleteRecordRequest) obj;
        return Objects.equals(featureGroupName(), other.featureGroupName())
                && Objects.equals(recordIdentifierValueAsString(), other.recordIdentifierValueAsString())
                && Objects.equals(eventTime(), other.eventTime()) && hasTargetStores() == other.hasTargetStores()
                && Objects.equals(targetStoresAsStrings(), other.targetStoresAsStrings())
                && Objects.equals(deletionModeAsString(), other.deletionModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRecordRequest").add("FeatureGroupName", featureGroupName())
                .add("RecordIdentifierValueAsString", recordIdentifierValueAsString()).add("EventTime", eventTime())
                .add("TargetStores", hasTargetStores() ? targetStoresAsStrings() : null)
                .add("DeletionMode", deletionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupName":
            return Optional.ofNullable(clazz.cast(featureGroupName()));
        case "RecordIdentifierValueAsString":
            return Optional.ofNullable(clazz.cast(recordIdentifierValueAsString()));
        case "EventTime":
            return Optional.ofNullable(clazz.cast(eventTime()));
        case "TargetStores":
            return Optional.ofNullable(clazz.cast(targetStoresAsStrings()));
        case "DeletionMode":
            return Optional.ofNullable(clazz.cast(deletionModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRecordRequest, T> g) {
        return obj -> g.apply((DeleteRecordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerFeatureStoreRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteRecordRequest> {
        /**
         * <p>
         * The name of the feature group to delete the record from.
         * </p>
         * 
         * @param featureGroupName
         *        The name of the feature group to delete the record from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupName(String featureGroupName);

        /**
         * <p>
         * The value for the <code>RecordIdentifier</code> that uniquely identifies the record, in string format.
         * </p>
         * 
         * @param recordIdentifierValueAsString
         *        The value for the <code>RecordIdentifier</code> that uniquely identifies the record, in string format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordIdentifierValueAsString(String recordIdentifierValueAsString);

        /**
         * <p>
         * Timestamp indicating when the deletion event occurred. <code>EventTime</code> can be used to query data at a
         * certain point in time.
         * </p>
         * 
         * @param eventTime
         *        Timestamp indicating when the deletion event occurred. <code>EventTime</code> can be used to query
         *        data at a certain point in time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTime(String eventTime);

        /**
         * <p>
         * A list of stores from which you're deleting the record. By default, Feature Store deletes the record from all
         * of the stores that you're using for the <code>FeatureGroup</code>.
         * </p>
         * 
         * @param targetStores
         *        A list of stores from which you're deleting the record. By default, Feature Store deletes the record
         *        from all of the stores that you're using for the <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetStoresWithStrings(Collection<String> targetStores);

        /**
         * <p>
         * A list of stores from which you're deleting the record. By default, Feature Store deletes the record from all
         * of the stores that you're using for the <code>FeatureGroup</code>.
         * </p>
         * 
         * @param targetStores
         *        A list of stores from which you're deleting the record. By default, Feature Store deletes the record
         *        from all of the stores that you're using for the <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetStoresWithStrings(String... targetStores);

        /**
         * <p>
         * A list of stores from which you're deleting the record. By default, Feature Store deletes the record from all
         * of the stores that you're using for the <code>FeatureGroup</code>.
         * </p>
         * 
         * @param targetStores
         *        A list of stores from which you're deleting the record. By default, Feature Store deletes the record
         *        from all of the stores that you're using for the <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetStores(Collection<TargetStore> targetStores);

        /**
         * <p>
         * A list of stores from which you're deleting the record. By default, Feature Store deletes the record from all
         * of the stores that you're using for the <code>FeatureGroup</code>.
         * </p>
         * 
         * @param targetStores
         *        A list of stores from which you're deleting the record. By default, Feature Store deletes the record
         *        from all of the stores that you're using for the <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetStores(TargetStore... targetStores);

        /**
         * <p>
         * The name of the deletion mode for deleting the record. By default, the deletion mode is set to
         * <code>SoftDelete</code>.
         * </p>
         * 
         * @param deletionMode
         *        The name of the deletion mode for deleting the record. By default, the deletion mode is set to
         *        <code>SoftDelete</code>.
         * @see DeletionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionMode
         */
        Builder deletionMode(String deletionMode);

        /**
         * <p>
         * The name of the deletion mode for deleting the record. By default, the deletion mode is set to
         * <code>SoftDelete</code>.
         * </p>
         * 
         * @param deletionMode
         *        The name of the deletion mode for deleting the record. By default, the deletion mode is set to
         *        <code>SoftDelete</code>.
         * @see DeletionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionMode
         */
        Builder deletionMode(DeletionMode deletionMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerFeatureStoreRuntimeRequest.BuilderImpl implements Builder {
        private String featureGroupName;

        private String recordIdentifierValueAsString;

        private String eventTime;

        private List<String> targetStores = DefaultSdkAutoConstructList.getInstance();

        private String deletionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRecordRequest model) {
            super(model);
            featureGroupName(model.featureGroupName);
            recordIdentifierValueAsString(model.recordIdentifierValueAsString);
            eventTime(model.eventTime);
            targetStoresWithStrings(model.targetStores);
            deletionMode(model.deletionMode);
        }

        public final String getFeatureGroupName() {
            return featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getRecordIdentifierValueAsString() {
            return recordIdentifierValueAsString;
        }

        public final void setRecordIdentifierValueAsString(String recordIdentifierValueAsString) {
            this.recordIdentifierValueAsString = recordIdentifierValueAsString;
        }

        @Override
        public final Builder recordIdentifierValueAsString(String recordIdentifierValueAsString) {
            this.recordIdentifierValueAsString = recordIdentifierValueAsString;
            return this;
        }

        public final String getEventTime() {
            return eventTime;
        }

        public final void setEventTime(String eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final Collection<String> getTargetStores() {
            if (targetStores instanceof SdkAutoConstructList) {
                return null;
            }
            return targetStores;
        }

        public final void setTargetStores(Collection<String> targetStores) {
            this.targetStores = TargetStoresCopier.copy(targetStores);
        }

        @Override
        public final Builder targetStoresWithStrings(Collection<String> targetStores) {
            this.targetStores = TargetStoresCopier.copy(targetStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStoresWithStrings(String... targetStores) {
            targetStoresWithStrings(Arrays.asList(targetStores));
            return this;
        }

        @Override
        public final Builder targetStores(Collection<TargetStore> targetStores) {
            this.targetStores = TargetStoresCopier.copyEnumToString(targetStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStores(TargetStore... targetStores) {
            targetStores(Arrays.asList(targetStores));
            return this;
        }

        public final String getDeletionMode() {
            return deletionMode;
        }

        public final void setDeletionMode(String deletionMode) {
            this.deletionMode = deletionMode;
        }

        @Override
        public final Builder deletionMode(String deletionMode) {
            this.deletionMode = deletionMode;
            return this;
        }

        @Override
        public final Builder deletionMode(DeletionMode deletionMode) {
            this.deletionMode(deletionMode == null ? null : deletionMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRecordRequest build() {
            return new DeleteRecordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
