/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakeredge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakeredge.model.Definition;
import software.amazon.awssdk.services.sagemakeredge.model.DefinitionsCopier;
import software.amazon.awssdk.services.sagemakeredge.model.DeploymentType;
import software.amazon.awssdk.services.sagemakeredge.model.FailureHandlingPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EdgeDeployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EdgeDeployment> {
    private static final SdkField<String> DEPLOYMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentName").getter(EdgeDeployment.getter(EdgeDeployment::deploymentName)).setter(EdgeDeployment.setter(Builder::deploymentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(EdgeDeployment.getter(EdgeDeployment::typeAsString)).setter(EdgeDeployment.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> FAILURE_HANDLING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureHandlingPolicy").getter(EdgeDeployment.getter(EdgeDeployment::failureHandlingPolicyAsString)).setter(EdgeDeployment.setter(Builder::failureHandlingPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureHandlingPolicy").build()}).build();
    private static final SdkField<List<Definition>> DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Definitions").getter(EdgeDeployment.getter(EdgeDeployment::definitions)).setter(EdgeDeployment.setter(Builder::definitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Definition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_NAME_FIELD, TYPE_FIELD, FAILURE_HANDLING_POLICY_FIELD, DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DeploymentName", DEPLOYMENT_NAME_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("FailureHandlingPolicy", FAILURE_HANDLING_POLICY_FIELD);
            this.put("Definitions", DEFINITIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String deploymentName;
    private final String type;
    private final String failureHandlingPolicy;
    private final List<Definition> definitions;

    private EdgeDeployment(BuilderImpl builder) {
        this.deploymentName = builder.deploymentName;
        this.type = builder.type;
        this.failureHandlingPolicy = builder.failureHandlingPolicy;
        this.definitions = builder.definitions;
    }

    public final String deploymentName() {
        return this.deploymentName;
    }

    public final DeploymentType type() {
        return DeploymentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final FailureHandlingPolicy failureHandlingPolicy() {
        return FailureHandlingPolicy.fromValue(this.failureHandlingPolicy);
    }

    public final String failureHandlingPolicyAsString() {
        return this.failureHandlingPolicy;
    }

    public final boolean hasDefinitions() {
        return this.definitions != null && !(this.definitions instanceof SdkAutoConstructList);
    }

    public final List<Definition> definitions() {
        return this.definitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureHandlingPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefinitions() ? this.definitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeDeployment)) {
            return false;
        }
        EdgeDeployment other = (EdgeDeployment)obj;
        return Objects.equals(this.deploymentName(), other.deploymentName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.failureHandlingPolicyAsString(), other.failureHandlingPolicyAsString()) && this.hasDefinitions() == other.hasDefinitions() && Objects.equals(this.definitions(), other.definitions());
    }

    public final String toString() {
        return ToString.builder((String)"EdgeDeployment").add("DeploymentName", (Object)this.deploymentName()).add("Type", (Object)this.typeAsString()).add("FailureHandlingPolicy", (Object)this.failureHandlingPolicyAsString()).add("Definitions", this.hasDefinitions() ? this.definitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentName": {
                return Optional.ofNullable(clazz.cast(this.deploymentName()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "FailureHandlingPolicy": {
                return Optional.ofNullable(clazz.cast(this.failureHandlingPolicyAsString()));
            }
            case "Definitions": {
                return Optional.ofNullable(clazz.cast(this.definitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EdgeDeployment, T> g) {
        return obj -> g.apply((EdgeDeployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentName;
        private String type;
        private String failureHandlingPolicy;
        private List<Definition> definitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeDeployment model) {
            this.deploymentName(model.deploymentName);
            this.type(model.type);
            this.failureHandlingPolicy(model.failureHandlingPolicy);
            this.definitions(model.definitions);
        }

        public final String getDeploymentName() {
            return this.deploymentName;
        }

        public final void setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        @Override
        public final Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DeploymentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getFailureHandlingPolicy() {
            return this.failureHandlingPolicy;
        }

        public final void setFailureHandlingPolicy(String failureHandlingPolicy) {
            this.failureHandlingPolicy = failureHandlingPolicy;
        }

        @Override
        public final Builder failureHandlingPolicy(String failureHandlingPolicy) {
            this.failureHandlingPolicy = failureHandlingPolicy;
            return this;
        }

        @Override
        public final Builder failureHandlingPolicy(FailureHandlingPolicy failureHandlingPolicy) {
            this.failureHandlingPolicy(failureHandlingPolicy == null ? null : failureHandlingPolicy.toString());
            return this;
        }

        public final List<Definition.Builder> getDefinitions() {
            List<Definition.Builder> result = DefinitionsCopier.copyToBuilder(this.definitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefinitions(Collection<Definition.BuilderImpl> definitions) {
            this.definitions = DefinitionsCopier.copyFromBuilder(definitions);
        }

        @Override
        public final Builder definitions(Collection<Definition> definitions) {
            this.definitions = DefinitionsCopier.copy(definitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definitions(Definition ... definitions) {
            this.definitions(Arrays.asList(definitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definitions(Consumer<Definition.Builder> ... definitions) {
            this.definitions(Stream.of(definitions).map(c -> (Definition)((Definition.Builder)Definition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EdgeDeployment build() {
            return new EdgeDeployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EdgeDeployment> {
        public Builder deploymentName(String var1);

        public Builder type(String var1);

        public Builder type(DeploymentType var1);

        public Builder failureHandlingPolicy(String var1);

        public Builder failureHandlingPolicy(FailureHandlingPolicy var1);

        public Builder definitions(Collection<Definition> var1);

        public Builder definitions(Definition ... var1);

        public Builder definitions(Consumer<Definition.Builder> ... var1);
    }
}

