/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakeredge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakeredge.model.EdgeMetric;
import software.amazon.awssdk.services.sagemakeredge.model.EdgeMetricsCopier;
import software.amazon.awssdk.services.sagemakeredge.model.Model;
import software.amazon.awssdk.services.sagemakeredge.model.ModelsCopier;
import software.amazon.awssdk.services.sagemakeredge.model.SagemakerEdgeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendHeartbeatRequest
extends SagemakerEdgeRequest
implements ToCopyableBuilder<Builder, SendHeartbeatRequest> {
    private static final SdkField<List<EdgeMetric>> AGENT_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentMetrics").getter(SendHeartbeatRequest.getter(SendHeartbeatRequest::agentMetrics)).setter(SendHeartbeatRequest.setter(Builder::agentMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EdgeMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Model>> MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Models").getter(SendHeartbeatRequest.getter(SendHeartbeatRequest::models)).setter(SendHeartbeatRequest.setter(Builder::models)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Models").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Model::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgentVersion").getter(SendHeartbeatRequest.getter(SendHeartbeatRequest::agentVersion)).setter(SendHeartbeatRequest.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceName").getter(SendHeartbeatRequest.getter(SendHeartbeatRequest::deviceName)).setter(SendHeartbeatRequest.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()}).build();
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetName").getter(SendHeartbeatRequest.getter(SendHeartbeatRequest::deviceFleetName)).setter(SendHeartbeatRequest.setter(Builder::deviceFleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_METRICS_FIELD, MODELS_FIELD, AGENT_VERSION_FIELD, DEVICE_NAME_FIELD, DEVICE_FLEET_NAME_FIELD));
    private final List<EdgeMetric> agentMetrics;
    private final List<Model> models;
    private final String agentVersion;
    private final String deviceName;
    private final String deviceFleetName;

    private SendHeartbeatRequest(BuilderImpl builder) {
        super(builder);
        this.agentMetrics = builder.agentMetrics;
        this.models = builder.models;
        this.agentVersion = builder.agentVersion;
        this.deviceName = builder.deviceName;
        this.deviceFleetName = builder.deviceFleetName;
    }

    public final boolean hasAgentMetrics() {
        return this.agentMetrics != null && !(this.agentMetrics instanceof SdkAutoConstructList);
    }

    public final List<EdgeMetric> agentMetrics() {
        return this.agentMetrics;
    }

    public final boolean hasModels() {
        return this.models != null && !(this.models instanceof SdkAutoConstructList);
    }

    public final List<Model> models() {
        return this.models;
    }

    public final String agentVersion() {
        return this.agentVersion;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    public final String deviceFleetName() {
        return this.deviceFleetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentMetrics() ? this.agentMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModels() ? this.models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendHeartbeatRequest)) {
            return false;
        }
        SendHeartbeatRequest other = (SendHeartbeatRequest)((Object)obj);
        return this.hasAgentMetrics() == other.hasAgentMetrics() && Objects.equals(this.agentMetrics(), other.agentMetrics()) && this.hasModels() == other.hasModels() && Objects.equals(this.models(), other.models()) && Objects.equals(this.agentVersion(), other.agentVersion()) && Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.deviceFleetName(), other.deviceFleetName());
    }

    public final String toString() {
        return ToString.builder((String)"SendHeartbeatRequest").add("AgentMetrics", this.hasAgentMetrics() ? this.agentMetrics() : null).add("Models", this.hasModels() ? this.models() : null).add("AgentVersion", (Object)this.agentVersion()).add("DeviceName", (Object)this.deviceName()).add("DeviceFleetName", (Object)this.deviceFleetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentMetrics": {
                return Optional.ofNullable(clazz.cast(this.agentMetrics()));
            }
            case "Models": {
                return Optional.ofNullable(clazz.cast(this.models()));
            }
            case "AgentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "DeviceFleetName": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendHeartbeatRequest, T> g) {
        return obj -> g.apply((SendHeartbeatRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SagemakerEdgeRequest.BuilderImpl
    implements Builder {
        private List<EdgeMetric> agentMetrics = DefaultSdkAutoConstructList.getInstance();
        private List<Model> models = DefaultSdkAutoConstructList.getInstance();
        private String agentVersion;
        private String deviceName;
        private String deviceFleetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SendHeartbeatRequest model) {
            super(model);
            this.agentMetrics(model.agentMetrics);
            this.models(model.models);
            this.agentVersion(model.agentVersion);
            this.deviceName(model.deviceName);
            this.deviceFleetName(model.deviceFleetName);
        }

        public final Collection<EdgeMetric.Builder> getAgentMetrics() {
            if (this.agentMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentMetrics != null ? (Collection)this.agentMetrics.stream().map(EdgeMetric::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder agentMetrics(Collection<EdgeMetric> agentMetrics) {
            this.agentMetrics = EdgeMetricsCopier.copy(agentMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentMetrics(EdgeMetric ... agentMetrics) {
            this.agentMetrics(Arrays.asList(agentMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentMetrics(Consumer<EdgeMetric.Builder> ... agentMetrics) {
            this.agentMetrics(Stream.of(agentMetrics).map(c -> (EdgeMetric)((EdgeMetric.Builder)EdgeMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAgentMetrics(Collection<EdgeMetric.BuilderImpl> agentMetrics) {
            this.agentMetrics = EdgeMetricsCopier.copyFromBuilder(agentMetrics);
        }

        public final Collection<Model.Builder> getModels() {
            if (this.models instanceof SdkAutoConstructList) {
                return null;
            }
            return this.models != null ? (Collection)this.models.stream().map(Model::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder models(Collection<Model> models) {
            this.models = ModelsCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Model ... models) {
            this.models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<Model.Builder> ... models) {
            this.models(Stream.of(models).map(c -> (Model)((Model.Builder)Model.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModels(Collection<Model.BuilderImpl> models) {
            this.models = ModelsCopier.copyFromBuilder(models);
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getDeviceFleetName() {
            return this.deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendHeartbeatRequest build() {
            return new SendHeartbeatRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SagemakerEdgeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendHeartbeatRequest> {
        public Builder agentMetrics(Collection<EdgeMetric> var1);

        public Builder agentMetrics(EdgeMetric ... var1);

        public Builder agentMetrics(Consumer<EdgeMetric.Builder> ... var1);

        public Builder models(Collection<Model> var1);

        public Builder models(Model ... var1);

        public Builder models(Consumer<Model.Builder> ... var1);

        public Builder agentVersion(String var1);

        public Builder deviceName(String var1);

        public Builder deviceFleetName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

