/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * Internal implementation of {@link SageMakerA2IRuntimeAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSageMakerA2IRuntimeAsyncClientBuilder extends
        DefaultSageMakerA2IRuntimeBaseClientBuilder<SageMakerA2IRuntimeAsyncClientBuilder, SageMakerA2IRuntimeAsyncClient>
        implements SageMakerA2IRuntimeAsyncClientBuilder {
    @Override
    protected final SageMakerA2IRuntimeAsyncClient buildClient() {
        return new DefaultSageMakerA2IRuntimeAsyncClient(super.asyncClientConfiguration());
    }
}
