/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusItem;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelPackageStatusDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelPackageStatusDetails> {
    private static final SdkField<List<ModelPackageStatusItem>> VALIDATION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModelPackageStatusDetails.getter(ModelPackageStatusDetails::validationStatuses)).setter(ModelPackageStatusDetails.setter(Builder::validationStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelPackageStatusItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ModelPackageStatusItem>> IMAGE_SCAN_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModelPackageStatusDetails.getter(ModelPackageStatusDetails::imageScanStatuses)).setter(ModelPackageStatusDetails.setter(Builder::imageScanStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageScanStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelPackageStatusItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_STATUSES_FIELD, IMAGE_SCAN_STATUSES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ModelPackageStatusItem> validationStatuses;
    private final List<ModelPackageStatusItem> imageScanStatuses;

    private ModelPackageStatusDetails(BuilderImpl builder) {
        this.validationStatuses = builder.validationStatuses;
        this.imageScanStatuses = builder.imageScanStatuses;
    }

    public List<ModelPackageStatusItem> validationStatuses() {
        return this.validationStatuses;
    }

    public List<ModelPackageStatusItem> imageScanStatuses() {
        return this.imageScanStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScanStatuses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageStatusDetails)) {
            return false;
        }
        ModelPackageStatusDetails other = (ModelPackageStatusDetails)obj;
        return Objects.equals(this.validationStatuses(), other.validationStatuses()) && Objects.equals(this.imageScanStatuses(), other.imageScanStatuses());
    }

    public String toString() {
        return ToString.builder((String)"ModelPackageStatusDetails").add("ValidationStatuses", this.validationStatuses()).add("ImageScanStatuses", this.imageScanStatuses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ValidationStatuses": {
                return Optional.ofNullable(clazz.cast(this.validationStatuses()));
            }
            case "ImageScanStatuses": {
                return Optional.ofNullable(clazz.cast(this.imageScanStatuses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageStatusDetails, T> g) {
        return obj -> g.apply((ModelPackageStatusDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ModelPackageStatusItem> validationStatuses = DefaultSdkAutoConstructList.getInstance();
        private List<ModelPackageStatusItem> imageScanStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageStatusDetails model) {
            this.validationStatuses(model.validationStatuses);
            this.imageScanStatuses(model.imageScanStatuses);
        }

        public final Collection<ModelPackageStatusItem.Builder> getValidationStatuses() {
            return this.validationStatuses != null ? (Collection)this.validationStatuses.stream().map(ModelPackageStatusItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationStatuses(Collection<ModelPackageStatusItem> validationStatuses) {
            this.validationStatuses = ModelPackageStatusItemListCopier.copy(validationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationStatuses(ModelPackageStatusItem ... validationStatuses) {
            this.validationStatuses(Arrays.asList(validationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationStatuses(Consumer<ModelPackageStatusItem.Builder> ... validationStatuses) {
            this.validationStatuses(Stream.of(validationStatuses).map(c -> (ModelPackageStatusItem)((ModelPackageStatusItem.Builder)ModelPackageStatusItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidationStatuses(Collection<ModelPackageStatusItem.BuilderImpl> validationStatuses) {
            this.validationStatuses = ModelPackageStatusItemListCopier.copyFromBuilder(validationStatuses);
        }

        public final Collection<ModelPackageStatusItem.Builder> getImageScanStatuses() {
            return this.imageScanStatuses != null ? (Collection)this.imageScanStatuses.stream().map(ModelPackageStatusItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageScanStatuses(Collection<ModelPackageStatusItem> imageScanStatuses) {
            this.imageScanStatuses = ModelPackageStatusItemListCopier.copy(imageScanStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageScanStatuses(ModelPackageStatusItem ... imageScanStatuses) {
            this.imageScanStatuses(Arrays.asList(imageScanStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageScanStatuses(Consumer<ModelPackageStatusItem.Builder> ... imageScanStatuses) {
            this.imageScanStatuses(Stream.of(imageScanStatuses).map(c -> (ModelPackageStatusItem)((ModelPackageStatusItem.Builder)ModelPackageStatusItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImageScanStatuses(Collection<ModelPackageStatusItem.BuilderImpl> imageScanStatuses) {
            this.imageScanStatuses = ModelPackageStatusItemListCopier.copyFromBuilder(imageScanStatuses);
        }

        public ModelPackageStatusDetails build() {
            return new ModelPackageStatusDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelPackageStatusDetails> {
        public Builder validationStatuses(Collection<ModelPackageStatusItem> var1);

        public Builder validationStatuses(ModelPackageStatusItem ... var1);

        public Builder validationStatuses(Consumer<ModelPackageStatusItem.Builder> ... var1);

        public Builder imageScanStatuses(Collection<ModelPackageStatusItem> var1);

        public Builder imageScanStatuses(ModelPackageStatusItem ... var1);

        public Builder imageScanStatuses(Consumer<ModelPackageStatusItem.Builder> ... var1);
    }
}

