/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrainingJobsForHyperParameterTuningJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListTrainingJobsForHyperParameterTuningJobResponse> {
    private static final SdkField<List<HyperParameterTrainingJobSummary>> TRAINING_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListTrainingJobsForHyperParameterTuningJobResponse.getter(ListTrainingJobsForHyperParameterTuningJobResponse::trainingJobSummaries)).setter(ListTrainingJobsForHyperParameterTuningJobResponse.setter(Builder::trainingJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HyperParameterTrainingJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTrainingJobsForHyperParameterTuningJobResponse.getter(ListTrainingJobsForHyperParameterTuningJobResponse::nextToken)).setter(ListTrainingJobsForHyperParameterTuningJobResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<HyperParameterTrainingJobSummary> trainingJobSummaries;
    private final String nextToken;

    private ListTrainingJobsForHyperParameterTuningJobResponse(BuilderImpl builder) {
        super(builder);
        this.trainingJobSummaries = builder.trainingJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<HyperParameterTrainingJobSummary> trainingJobSummaries() {
        return this.trainingJobSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainingJobsForHyperParameterTuningJobResponse)) {
            return false;
        }
        ListTrainingJobsForHyperParameterTuningJobResponse other = (ListTrainingJobsForHyperParameterTuningJobResponse)((Object)obj);
        return Objects.equals(this.trainingJobSummaries(), other.trainingJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTrainingJobsForHyperParameterTuningJobResponse").add("TrainingJobSummaries", this.trainingJobSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.trainingJobSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrainingJobsForHyperParameterTuningJobResponse, T> g) {
        return obj -> g.apply((ListTrainingJobsForHyperParameterTuningJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<HyperParameterTrainingJobSummary> trainingJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainingJobsForHyperParameterTuningJobResponse model) {
            super(model);
            this.trainingJobSummaries(model.trainingJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<HyperParameterTrainingJobSummary.Builder> getTrainingJobSummaries() {
            return this.trainingJobSummaries != null ? (Collection)this.trainingJobSummaries.stream().map(HyperParameterTrainingJobSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trainingJobSummaries(Collection<HyperParameterTrainingJobSummary> trainingJobSummaries) {
            this.trainingJobSummaries = HyperParameterTrainingJobSummariesCopier.copy(trainingJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingJobSummaries(HyperParameterTrainingJobSummary ... trainingJobSummaries) {
            this.trainingJobSummaries(Arrays.asList(trainingJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingJobSummaries(Consumer<HyperParameterTrainingJobSummary.Builder> ... trainingJobSummaries) {
            this.trainingJobSummaries(Stream.of(trainingJobSummaries).map(c -> (HyperParameterTrainingJobSummary)((HyperParameterTrainingJobSummary.Builder)HyperParameterTrainingJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrainingJobSummaries(Collection<HyperParameterTrainingJobSummary.BuilderImpl> trainingJobSummaries) {
            this.trainingJobSummaries = HyperParameterTrainingJobSummariesCopier.copyFromBuilder(trainingJobSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTrainingJobsForHyperParameterTuningJobResponse build() {
            return new ListTrainingJobsForHyperParameterTuningJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrainingJobsForHyperParameterTuningJobResponse> {
        public Builder trainingJobSummaries(Collection<HyperParameterTrainingJobSummary> var1);

        public Builder trainingJobSummaries(HyperParameterTrainingJobSummary ... var1);

        public Builder trainingJobSummaries(Consumer<HyperParameterTrainingJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

