/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.Channel;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterAlgorithmSpecification;
import software.amazon.awssdk.services.sagemaker.model.HyperParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.InputDataConfigCopier;
import software.amazon.awssdk.services.sagemaker.model.OutputDataConfig;
import software.amazon.awssdk.services.sagemaker.model.ResourceConfig;
import software.amazon.awssdk.services.sagemaker.model.StoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterTrainingJobDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HyperParameterTrainingJobDefinition> {
    private static final SdkField<Map<String, String>> STATIC_HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::staticHyperParameters)).setter(HyperParameterTrainingJobDefinition.setter(Builder::staticHyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticHyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<HyperParameterAlgorithmSpecification> ALGORITHM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::algorithmSpecification)).setter(HyperParameterTrainingJobDefinition.setter(Builder::algorithmSpecification)).constructor(HyperParameterAlgorithmSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmSpecification").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::roleArn)).setter(HyperParameterTrainingJobDefinition.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<Channel>> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::inputDataConfig)).setter(HyperParameterTrainingJobDefinition.setter(Builder::inputDataConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Channel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::vpcConfig)).setter(HyperParameterTrainingJobDefinition.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::outputDataConfig)).setter(HyperParameterTrainingJobDefinition.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::resourceConfig)).setter(HyperParameterTrainingJobDefinition.setter(Builder::resourceConfig)).constructor(ResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfig").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::stoppingCondition)).setter(HyperParameterTrainingJobDefinition.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::enableNetworkIsolation)).setter(HyperParameterTrainingJobDefinition.setter(Builder::enableNetworkIsolation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build()}).build();
    private static final SdkField<Boolean> ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::enableInterContainerTrafficEncryption)).setter(HyperParameterTrainingJobDefinition.setter(Builder::enableInterContainerTrafficEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableInterContainerTrafficEncryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_HYPER_PARAMETERS_FIELD, ALGORITHM_SPECIFICATION_FIELD, ROLE_ARN_FIELD, INPUT_DATA_CONFIG_FIELD, VPC_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, RESOURCE_CONFIG_FIELD, STOPPING_CONDITION_FIELD, ENABLE_NETWORK_ISOLATION_FIELD, ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> staticHyperParameters;
    private final HyperParameterAlgorithmSpecification algorithmSpecification;
    private final String roleArn;
    private final List<Channel> inputDataConfig;
    private final VpcConfig vpcConfig;
    private final OutputDataConfig outputDataConfig;
    private final ResourceConfig resourceConfig;
    private final StoppingCondition stoppingCondition;
    private final Boolean enableNetworkIsolation;
    private final Boolean enableInterContainerTrafficEncryption;

    private HyperParameterTrainingJobDefinition(BuilderImpl builder) {
        this.staticHyperParameters = builder.staticHyperParameters;
        this.algorithmSpecification = builder.algorithmSpecification;
        this.roleArn = builder.roleArn;
        this.inputDataConfig = builder.inputDataConfig;
        this.vpcConfig = builder.vpcConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.resourceConfig = builder.resourceConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
        this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
    }

    public Map<String, String> staticHyperParameters() {
        return this.staticHyperParameters;
    }

    public HyperParameterAlgorithmSpecification algorithmSpecification() {
        return this.algorithmSpecification;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public List<Channel> inputDataConfig() {
        return this.inputDataConfig;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public ResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public Boolean enableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public Boolean enableInterContainerTrafficEncryption() {
        return this.enableInterContainerTrafficEncryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.staticHyperParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNetworkIsolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableInterContainerTrafficEncryption());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTrainingJobDefinition)) {
            return false;
        }
        HyperParameterTrainingJobDefinition other = (HyperParameterTrainingJobDefinition)obj;
        return Objects.equals(this.staticHyperParameters(), other.staticHyperParameters()) && Objects.equals(this.algorithmSpecification(), other.algorithmSpecification()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && Objects.equals(this.enableNetworkIsolation(), other.enableNetworkIsolation()) && Objects.equals(this.enableInterContainerTrafficEncryption(), other.enableInterContainerTrafficEncryption());
    }

    public String toString() {
        return ToString.builder((String)"HyperParameterTrainingJobDefinition").add("StaticHyperParameters", this.staticHyperParameters()).add("AlgorithmSpecification", (Object)this.algorithmSpecification()).add("RoleArn", (Object)this.roleArn()).add("InputDataConfig", this.inputDataConfig()).add("VpcConfig", (Object)this.vpcConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("ResourceConfig", (Object)this.resourceConfig()).add("StoppingCondition", (Object)this.stoppingCondition()).add("EnableNetworkIsolation", (Object)this.enableNetworkIsolation()).add("EnableInterContainerTrafficEncryption", (Object)this.enableInterContainerTrafficEncryption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StaticHyperParameters": {
                return Optional.ofNullable(clazz.cast(this.staticHyperParameters()));
            }
            case "AlgorithmSpecification": {
                return Optional.ofNullable(clazz.cast(this.algorithmSpecification()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "ResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "EnableNetworkIsolation": {
                return Optional.ofNullable(clazz.cast(this.enableNetworkIsolation()));
            }
            case "EnableInterContainerTrafficEncryption": {
                return Optional.ofNullable(clazz.cast(this.enableInterContainerTrafficEncryption()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTrainingJobDefinition, T> g) {
        return obj -> g.apply((HyperParameterTrainingJobDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> staticHyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private HyperParameterAlgorithmSpecification algorithmSpecification;
        private String roleArn;
        private List<Channel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();
        private VpcConfig vpcConfig;
        private OutputDataConfig outputDataConfig;
        private ResourceConfig resourceConfig;
        private StoppingCondition stoppingCondition;
        private Boolean enableNetworkIsolation;
        private Boolean enableInterContainerTrafficEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTrainingJobDefinition model) {
            this.staticHyperParameters(model.staticHyperParameters);
            this.algorithmSpecification(model.algorithmSpecification);
            this.roleArn(model.roleArn);
            this.inputDataConfig(model.inputDataConfig);
            this.vpcConfig(model.vpcConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.resourceConfig(model.resourceConfig);
            this.stoppingCondition(model.stoppingCondition);
            this.enableNetworkIsolation(model.enableNetworkIsolation);
            this.enableInterContainerTrafficEncryption(model.enableInterContainerTrafficEncryption);
        }

        public final Map<String, String> getStaticHyperParameters() {
            return this.staticHyperParameters;
        }

        @Override
        public final Builder staticHyperParameters(Map<String, String> staticHyperParameters) {
            this.staticHyperParameters = HyperParametersCopier.copy(staticHyperParameters);
            return this;
        }

        public final void setStaticHyperParameters(Map<String, String> staticHyperParameters) {
            this.staticHyperParameters = HyperParametersCopier.copy(staticHyperParameters);
        }

        public final HyperParameterAlgorithmSpecification.Builder getAlgorithmSpecification() {
            return this.algorithmSpecification != null ? this.algorithmSpecification.toBuilder() : null;
        }

        @Override
        public final Builder algorithmSpecification(HyperParameterAlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public final void setAlgorithmSpecification(HyperParameterAlgorithmSpecification.BuilderImpl algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification != null ? algorithmSpecification.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<Channel.Builder> getInputDataConfig() {
            return this.inputDataConfig != null ? (Collection)this.inputDataConfig.stream().map(Channel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputDataConfig(Collection<Channel> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Channel ... inputDataConfig) {
            this.inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<Channel.Builder> ... inputDataConfig) {
            this.inputDataConfig(Stream.of(inputDataConfig).map(c -> (Channel)((Channel.Builder)Channel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputDataConfig(Collection<Channel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public final Boolean getEnableNetworkIsolation() {
            return this.enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        public final Boolean getEnableInterContainerTrafficEncryption() {
            return this.enableInterContainerTrafficEncryption;
        }

        @Override
        public final Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
            return this;
        }

        public final void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
        }

        public HyperParameterTrainingJobDefinition build() {
            return new HyperParameterTrainingJobDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HyperParameterTrainingJobDefinition> {
        public Builder staticHyperParameters(Map<String, String> var1);

        public Builder algorithmSpecification(HyperParameterAlgorithmSpecification var1);

        default public Builder algorithmSpecification(Consumer<HyperParameterAlgorithmSpecification.Builder> algorithmSpecification) {
            return this.algorithmSpecification((HyperParameterAlgorithmSpecification)((HyperParameterAlgorithmSpecification.Builder)HyperParameterAlgorithmSpecification.builder().applyMutation(algorithmSpecification)).build());
        }

        public Builder roleArn(String var1);

        public Builder inputDataConfig(Collection<Channel> var1);

        public Builder inputDataConfig(Channel ... var1);

        public Builder inputDataConfig(Consumer<Channel.Builder> ... var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder resourceConfig(ResourceConfig var1);

        default public Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((ResourceConfig)((ResourceConfig.Builder)ResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder enableNetworkIsolation(Boolean var1);

        public Builder enableInterContainerTrafficEncryption(Boolean var1);
    }
}

