/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AccountDefaultStatus;
import software.amazon.awssdk.services.sagemaker.model.DefaultDomainIdListCopier;
import software.amazon.awssdk.services.sagemaker.model.ModelRegistrationMode;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMlflowAppRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateMlflowAppRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateMlflowAppRequest.getter(UpdateMlflowAppRequest::arn)).setter(UpdateMlflowAppRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateMlflowAppRequest.getter(UpdateMlflowAppRequest::name)).setter(UpdateMlflowAppRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARTIFACT_STORE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactStoreUri").getter(UpdateMlflowAppRequest.getter(UpdateMlflowAppRequest::artifactStoreUri)).setter(UpdateMlflowAppRequest.setter(Builder::artifactStoreUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactStoreUri").build()}).build();
    private static final SdkField<String> MODEL_REGISTRATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelRegistrationMode").getter(UpdateMlflowAppRequest.getter(UpdateMlflowAppRequest::modelRegistrationModeAsString)).setter(UpdateMlflowAppRequest.setter(Builder::modelRegistrationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelRegistrationMode").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceWindowStart").getter(UpdateMlflowAppRequest.getter(UpdateMlflowAppRequest::weeklyMaintenanceWindowStart)).setter(UpdateMlflowAppRequest.setter(Builder::weeklyMaintenanceWindowStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart").build()}).build();
    private static final SdkField<List<String>> DEFAULT_DOMAIN_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultDomainIdList").getter(UpdateMlflowAppRequest.getter(UpdateMlflowAppRequest::defaultDomainIdList)).setter(UpdateMlflowAppRequest.setter(Builder::defaultDomainIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultDomainIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACCOUNT_DEFAULT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountDefaultStatus").getter(UpdateMlflowAppRequest.getter(UpdateMlflowAppRequest::accountDefaultStatusAsString)).setter(UpdateMlflowAppRequest.setter(Builder::accountDefaultStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountDefaultStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, ARTIFACT_STORE_URI_FIELD, MODEL_REGISTRATION_MODE_FIELD, WEEKLY_MAINTENANCE_WINDOW_START_FIELD, DEFAULT_DOMAIN_ID_LIST_FIELD, ACCOUNT_DEFAULT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMlflowAppRequest.memberNameToFieldInitializer();
    private final String arn;
    private final String name;
    private final String artifactStoreUri;
    private final String modelRegistrationMode;
    private final String weeklyMaintenanceWindowStart;
    private final List<String> defaultDomainIdList;
    private final String accountDefaultStatus;

    private UpdateMlflowAppRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.artifactStoreUri = builder.artifactStoreUri;
        this.modelRegistrationMode = builder.modelRegistrationMode;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
        this.defaultDomainIdList = builder.defaultDomainIdList;
        this.accountDefaultStatus = builder.accountDefaultStatus;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String artifactStoreUri() {
        return this.artifactStoreUri;
    }

    public final ModelRegistrationMode modelRegistrationMode() {
        return ModelRegistrationMode.fromValue(this.modelRegistrationMode);
    }

    public final String modelRegistrationModeAsString() {
        return this.modelRegistrationMode;
    }

    public final String weeklyMaintenanceWindowStart() {
        return this.weeklyMaintenanceWindowStart;
    }

    public final boolean hasDefaultDomainIdList() {
        return this.defaultDomainIdList != null && !(this.defaultDomainIdList instanceof SdkAutoConstructList);
    }

    public final List<String> defaultDomainIdList() {
        return this.defaultDomainIdList;
    }

    public final AccountDefaultStatus accountDefaultStatus() {
        return AccountDefaultStatus.fromValue(this.accountDefaultStatus);
    }

    public final String accountDefaultStatusAsString() {
        return this.accountDefaultStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactStoreUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelRegistrationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultDomainIdList() ? this.defaultDomainIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accountDefaultStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMlflowAppRequest)) {
            return false;
        }
        UpdateMlflowAppRequest other = (UpdateMlflowAppRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.artifactStoreUri(), other.artifactStoreUri()) && Objects.equals(this.modelRegistrationModeAsString(), other.modelRegistrationModeAsString()) && Objects.equals(this.weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart()) && this.hasDefaultDomainIdList() == other.hasDefaultDomainIdList() && Objects.equals(this.defaultDomainIdList(), other.defaultDomainIdList()) && Objects.equals(this.accountDefaultStatusAsString(), other.accountDefaultStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMlflowAppRequest").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("ArtifactStoreUri", (Object)this.artifactStoreUri()).add("ModelRegistrationMode", (Object)this.modelRegistrationModeAsString()).add("WeeklyMaintenanceWindowStart", (Object)this.weeklyMaintenanceWindowStart()).add("DefaultDomainIdList", this.hasDefaultDomainIdList() ? this.defaultDomainIdList() : null).add("AccountDefaultStatus", (Object)this.accountDefaultStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ArtifactStoreUri": {
                return Optional.ofNullable(clazz.cast(this.artifactStoreUri()));
            }
            case "ModelRegistrationMode": {
                return Optional.ofNullable(clazz.cast(this.modelRegistrationModeAsString()));
            }
            case "WeeklyMaintenanceWindowStart": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceWindowStart()));
            }
            case "DefaultDomainIdList": {
                return Optional.ofNullable(clazz.cast(this.defaultDomainIdList()));
            }
            case "AccountDefaultStatus": {
                return Optional.ofNullable(clazz.cast(this.accountDefaultStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ArtifactStoreUri", ARTIFACT_STORE_URI_FIELD);
        map.put("ModelRegistrationMode", MODEL_REGISTRATION_MODE_FIELD);
        map.put("WeeklyMaintenanceWindowStart", WEEKLY_MAINTENANCE_WINDOW_START_FIELD);
        map.put("DefaultDomainIdList", DEFAULT_DOMAIN_ID_LIST_FIELD);
        map.put("AccountDefaultStatus", ACCOUNT_DEFAULT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMlflowAppRequest, T> g) {
        return obj -> g.apply((UpdateMlflowAppRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String artifactStoreUri;
        private String modelRegistrationMode;
        private String weeklyMaintenanceWindowStart;
        private List<String> defaultDomainIdList = DefaultSdkAutoConstructList.getInstance();
        private String accountDefaultStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMlflowAppRequest model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.artifactStoreUri(model.artifactStoreUri);
            this.modelRegistrationMode(model.modelRegistrationMode);
            this.weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
            this.defaultDomainIdList(model.defaultDomainIdList);
            this.accountDefaultStatus(model.accountDefaultStatus);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArtifactStoreUri() {
            return this.artifactStoreUri;
        }

        public final void setArtifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
        }

        @Override
        public final Builder artifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
            return this;
        }

        public final String getModelRegistrationMode() {
            return this.modelRegistrationMode;
        }

        public final void setModelRegistrationMode(String modelRegistrationMode) {
            this.modelRegistrationMode = modelRegistrationMode;
        }

        @Override
        public final Builder modelRegistrationMode(String modelRegistrationMode) {
            this.modelRegistrationMode = modelRegistrationMode;
            return this;
        }

        @Override
        public final Builder modelRegistrationMode(ModelRegistrationMode modelRegistrationMode) {
            this.modelRegistrationMode(modelRegistrationMode == null ? null : modelRegistrationMode.toString());
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return this.weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        public final Collection<String> getDefaultDomainIdList() {
            if (this.defaultDomainIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.defaultDomainIdList;
        }

        public final void setDefaultDomainIdList(Collection<String> defaultDomainIdList) {
            this.defaultDomainIdList = DefaultDomainIdListCopier.copy(defaultDomainIdList);
        }

        @Override
        public final Builder defaultDomainIdList(Collection<String> defaultDomainIdList) {
            this.defaultDomainIdList = DefaultDomainIdListCopier.copy(defaultDomainIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultDomainIdList(String ... defaultDomainIdList) {
            this.defaultDomainIdList(Arrays.asList(defaultDomainIdList));
            return this;
        }

        public final String getAccountDefaultStatus() {
            return this.accountDefaultStatus;
        }

        public final void setAccountDefaultStatus(String accountDefaultStatus) {
            this.accountDefaultStatus = accountDefaultStatus;
        }

        @Override
        public final Builder accountDefaultStatus(String accountDefaultStatus) {
            this.accountDefaultStatus = accountDefaultStatus;
            return this;
        }

        @Override
        public final Builder accountDefaultStatus(AccountDefaultStatus accountDefaultStatus) {
            this.accountDefaultStatus(accountDefaultStatus == null ? null : accountDefaultStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMlflowAppRequest build() {
            return new UpdateMlflowAppRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMlflowAppRequest> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder artifactStoreUri(String var1);

        public Builder modelRegistrationMode(String var1);

        public Builder modelRegistrationMode(ModelRegistrationMode var1);

        public Builder weeklyMaintenanceWindowStart(String var1);

        public Builder defaultDomainIdList(Collection<String> var1);

        public Builder defaultDomainIdList(String ... var1);

        public Builder accountDefaultStatus(String var1);

        public Builder accountDefaultStatus(AccountDefaultStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

