/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelPackageConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelPackageConfig> {
    private static final SdkField<String> MODEL_PACKAGE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupArn").getter(ModelPackageConfig.getter(ModelPackageConfig::modelPackageGroupArn)).setter(ModelPackageConfig.setter(Builder::modelPackageGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupArn").build()}).build();
    private static final SdkField<String> SOURCE_MODEL_PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceModelPackageArn").getter(ModelPackageConfig.getter(ModelPackageConfig::sourceModelPackageArn)).setter(ModelPackageConfig.setter(Builder::sourceModelPackageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceModelPackageArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_GROUP_ARN_FIELD, SOURCE_MODEL_PACKAGE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelPackageConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelPackageGroupArn;
    private final String sourceModelPackageArn;

    private ModelPackageConfig(BuilderImpl builder) {
        this.modelPackageGroupArn = builder.modelPackageGroupArn;
        this.sourceModelPackageArn = builder.sourceModelPackageArn;
    }

    public final String modelPackageGroupArn() {
        return this.modelPackageGroupArn;
    }

    public final String sourceModelPackageArn() {
        return this.sourceModelPackageArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceModelPackageArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageConfig)) {
            return false;
        }
        ModelPackageConfig other = (ModelPackageConfig)obj;
        return Objects.equals(this.modelPackageGroupArn(), other.modelPackageGroupArn()) && Objects.equals(this.sourceModelPackageArn(), other.sourceModelPackageArn());
    }

    public final String toString() {
        return ToString.builder((String)"ModelPackageConfig").add("ModelPackageGroupArn", (Object)this.modelPackageGroupArn()).add("SourceModelPackageArn", (Object)this.sourceModelPackageArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageGroupArn": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupArn()));
            }
            case "SourceModelPackageArn": {
                return Optional.ofNullable(clazz.cast(this.sourceModelPackageArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ModelPackageGroupArn", MODEL_PACKAGE_GROUP_ARN_FIELD);
        map.put("SourceModelPackageArn", SOURCE_MODEL_PACKAGE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageConfig, T> g) {
        return obj -> g.apply((ModelPackageConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelPackageGroupArn;
        private String sourceModelPackageArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageConfig model) {
            this.modelPackageGroupArn(model.modelPackageGroupArn);
            this.sourceModelPackageArn(model.sourceModelPackageArn);
        }

        public final String getModelPackageGroupArn() {
            return this.modelPackageGroupArn;
        }

        public final void setModelPackageGroupArn(String modelPackageGroupArn) {
            this.modelPackageGroupArn = modelPackageGroupArn;
        }

        @Override
        public final Builder modelPackageGroupArn(String modelPackageGroupArn) {
            this.modelPackageGroupArn = modelPackageGroupArn;
            return this;
        }

        public final String getSourceModelPackageArn() {
            return this.sourceModelPackageArn;
        }

        public final void setSourceModelPackageArn(String sourceModelPackageArn) {
            this.sourceModelPackageArn = sourceModelPackageArn;
        }

        @Override
        public final Builder sourceModelPackageArn(String sourceModelPackageArn) {
            this.sourceModelPackageArn = sourceModelPackageArn;
            return this;
        }

        public ModelPackageConfig build() {
            return new ModelPackageConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelPackageConfig> {
        public Builder modelPackageGroupArn(String var1);

        public Builder sourceModelPackageArn(String var1);
    }
}

