/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AccountDefaultStatus;
import software.amazon.awssdk.services.sagemaker.model.DefaultDomainIdListCopier;
import software.amazon.awssdk.services.sagemaker.model.MaintenanceStatus;
import software.amazon.awssdk.services.sagemaker.model.MlflowAppStatus;
import software.amazon.awssdk.services.sagemaker.model.ModelRegistrationMode;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMlflowAppResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeMlflowAppResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::arn)).setter(DescribeMlflowAppResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::name)).setter(DescribeMlflowAppResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARTIFACT_STORE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactStoreUri").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::artifactStoreUri)).setter(DescribeMlflowAppResponse.setter(Builder::artifactStoreUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactStoreUri").build()}).build();
    private static final SdkField<String> MLFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MlflowVersion").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::mlflowVersion)).setter(DescribeMlflowAppResponse.setter(Builder::mlflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlflowVersion").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::roleArn)).setter(DescribeMlflowAppResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::statusAsString)).setter(DescribeMlflowAppResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MODEL_REGISTRATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelRegistrationMode").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::modelRegistrationModeAsString)).setter(DescribeMlflowAppResponse.setter(Builder::modelRegistrationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelRegistrationMode").build()}).build();
    private static final SdkField<String> ACCOUNT_DEFAULT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountDefaultStatus").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::accountDefaultStatusAsString)).setter(DescribeMlflowAppResponse.setter(Builder::accountDefaultStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountDefaultStatus").build()}).build();
    private static final SdkField<List<String>> DEFAULT_DOMAIN_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultDomainIdList").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::defaultDomainIdList)).setter(DescribeMlflowAppResponse.setter(Builder::defaultDomainIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultDomainIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::creationTime)).setter(DescribeMlflowAppResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::createdBy)).setter(DescribeMlflowAppResponse.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::lastModifiedTime)).setter(DescribeMlflowAppResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedBy").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::lastModifiedBy)).setter(DescribeMlflowAppResponse.setter(Builder::lastModifiedBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceWindowStart").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::weeklyMaintenanceWindowStart)).setter(DescribeMlflowAppResponse.setter(Builder::weeklyMaintenanceWindowStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart").build()}).build();
    private static final SdkField<String> MAINTENANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceStatus").getter(DescribeMlflowAppResponse.getter(DescribeMlflowAppResponse::maintenanceStatusAsString)).setter(DescribeMlflowAppResponse.setter(Builder::maintenanceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, ARTIFACT_STORE_URI_FIELD, MLFLOW_VERSION_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, MODEL_REGISTRATION_MODE_FIELD, ACCOUNT_DEFAULT_STATUS_FIELD, DEFAULT_DOMAIN_ID_LIST_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, WEEKLY_MAINTENANCE_WINDOW_START_FIELD, MAINTENANCE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMlflowAppResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String name;
    private final String artifactStoreUri;
    private final String mlflowVersion;
    private final String roleArn;
    private final String status;
    private final String modelRegistrationMode;
    private final String accountDefaultStatus;
    private final List<String> defaultDomainIdList;
    private final Instant creationTime;
    private final UserContext createdBy;
    private final Instant lastModifiedTime;
    private final UserContext lastModifiedBy;
    private final String weeklyMaintenanceWindowStart;
    private final String maintenanceStatus;

    private DescribeMlflowAppResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.artifactStoreUri = builder.artifactStoreUri;
        this.mlflowVersion = builder.mlflowVersion;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.modelRegistrationMode = builder.modelRegistrationMode;
        this.accountDefaultStatus = builder.accountDefaultStatus;
        this.defaultDomainIdList = builder.defaultDomainIdList;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
        this.maintenanceStatus = builder.maintenanceStatus;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String artifactStoreUri() {
        return this.artifactStoreUri;
    }

    public final String mlflowVersion() {
        return this.mlflowVersion;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final MlflowAppStatus status() {
        return MlflowAppStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ModelRegistrationMode modelRegistrationMode() {
        return ModelRegistrationMode.fromValue(this.modelRegistrationMode);
    }

    public final String modelRegistrationModeAsString() {
        return this.modelRegistrationMode;
    }

    public final AccountDefaultStatus accountDefaultStatus() {
        return AccountDefaultStatus.fromValue(this.accountDefaultStatus);
    }

    public final String accountDefaultStatusAsString() {
        return this.accountDefaultStatus;
    }

    public final boolean hasDefaultDomainIdList() {
        return this.defaultDomainIdList != null && !(this.defaultDomainIdList instanceof SdkAutoConstructList);
    }

    public final List<String> defaultDomainIdList() {
        return this.defaultDomainIdList;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final UserContext lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final String weeklyMaintenanceWindowStart() {
        return this.weeklyMaintenanceWindowStart;
    }

    public final MaintenanceStatus maintenanceStatus() {
        return MaintenanceStatus.fromValue(this.maintenanceStatus);
    }

    public final String maintenanceStatusAsString() {
        return this.maintenanceStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactStoreUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelRegistrationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountDefaultStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultDomainIdList() ? this.defaultDomainIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMlflowAppResponse)) {
            return false;
        }
        DescribeMlflowAppResponse other = (DescribeMlflowAppResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.artifactStoreUri(), other.artifactStoreUri()) && Objects.equals(this.mlflowVersion(), other.mlflowVersion()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.modelRegistrationModeAsString(), other.modelRegistrationModeAsString()) && Objects.equals(this.accountDefaultStatusAsString(), other.accountDefaultStatusAsString()) && this.hasDefaultDomainIdList() == other.hasDefaultDomainIdList() && Objects.equals(this.defaultDomainIdList(), other.defaultDomainIdList()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart()) && Objects.equals(this.maintenanceStatusAsString(), other.maintenanceStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMlflowAppResponse").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("ArtifactStoreUri", (Object)this.artifactStoreUri()).add("MlflowVersion", (Object)this.mlflowVersion()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("ModelRegistrationMode", (Object)this.modelRegistrationModeAsString()).add("AccountDefaultStatus", (Object)this.accountDefaultStatusAsString()).add("DefaultDomainIdList", this.hasDefaultDomainIdList() ? this.defaultDomainIdList() : null).add("CreationTime", (Object)this.creationTime()).add("CreatedBy", (Object)this.createdBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("WeeklyMaintenanceWindowStart", (Object)this.weeklyMaintenanceWindowStart()).add("MaintenanceStatus", (Object)this.maintenanceStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ArtifactStoreUri": {
                return Optional.ofNullable(clazz.cast(this.artifactStoreUri()));
            }
            case "MlflowVersion": {
                return Optional.ofNullable(clazz.cast(this.mlflowVersion()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ModelRegistrationMode": {
                return Optional.ofNullable(clazz.cast(this.modelRegistrationModeAsString()));
            }
            case "AccountDefaultStatus": {
                return Optional.ofNullable(clazz.cast(this.accountDefaultStatusAsString()));
            }
            case "DefaultDomainIdList": {
                return Optional.ofNullable(clazz.cast(this.defaultDomainIdList()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "WeeklyMaintenanceWindowStart": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceWindowStart()));
            }
            case "MaintenanceStatus": {
                return Optional.ofNullable(clazz.cast(this.maintenanceStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ArtifactStoreUri", ARTIFACT_STORE_URI_FIELD);
        map.put("MlflowVersion", MLFLOW_VERSION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ModelRegistrationMode", MODEL_REGISTRATION_MODE_FIELD);
        map.put("AccountDefaultStatus", ACCOUNT_DEFAULT_STATUS_FIELD);
        map.put("DefaultDomainIdList", DEFAULT_DOMAIN_ID_LIST_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("WeeklyMaintenanceWindowStart", WEEKLY_MAINTENANCE_WINDOW_START_FIELD);
        map.put("MaintenanceStatus", MAINTENANCE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMlflowAppResponse, T> g) {
        return obj -> g.apply((DescribeMlflowAppResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String artifactStoreUri;
        private String mlflowVersion;
        private String roleArn;
        private String status;
        private String modelRegistrationMode;
        private String accountDefaultStatus;
        private List<String> defaultDomainIdList = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private UserContext createdBy;
        private Instant lastModifiedTime;
        private UserContext lastModifiedBy;
        private String weeklyMaintenanceWindowStart;
        private String maintenanceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMlflowAppResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.artifactStoreUri(model.artifactStoreUri);
            this.mlflowVersion(model.mlflowVersion);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.modelRegistrationMode(model.modelRegistrationMode);
            this.accountDefaultStatus(model.accountDefaultStatus);
            this.defaultDomainIdList(model.defaultDomainIdList);
            this.creationTime(model.creationTime);
            this.createdBy(model.createdBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedBy(model.lastModifiedBy);
            this.weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
            this.maintenanceStatus(model.maintenanceStatus);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArtifactStoreUri() {
            return this.artifactStoreUri;
        }

        public final void setArtifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
        }

        @Override
        public final Builder artifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
            return this;
        }

        public final String getMlflowVersion() {
            return this.mlflowVersion;
        }

        public final void setMlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
        }

        @Override
        public final Builder mlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MlflowAppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModelRegistrationMode() {
            return this.modelRegistrationMode;
        }

        public final void setModelRegistrationMode(String modelRegistrationMode) {
            this.modelRegistrationMode = modelRegistrationMode;
        }

        @Override
        public final Builder modelRegistrationMode(String modelRegistrationMode) {
            this.modelRegistrationMode = modelRegistrationMode;
            return this;
        }

        @Override
        public final Builder modelRegistrationMode(ModelRegistrationMode modelRegistrationMode) {
            this.modelRegistrationMode(modelRegistrationMode == null ? null : modelRegistrationMode.toString());
            return this;
        }

        public final String getAccountDefaultStatus() {
            return this.accountDefaultStatus;
        }

        public final void setAccountDefaultStatus(String accountDefaultStatus) {
            this.accountDefaultStatus = accountDefaultStatus;
        }

        @Override
        public final Builder accountDefaultStatus(String accountDefaultStatus) {
            this.accountDefaultStatus = accountDefaultStatus;
            return this;
        }

        @Override
        public final Builder accountDefaultStatus(AccountDefaultStatus accountDefaultStatus) {
            this.accountDefaultStatus(accountDefaultStatus == null ? null : accountDefaultStatus.toString());
            return this;
        }

        public final Collection<String> getDefaultDomainIdList() {
            if (this.defaultDomainIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.defaultDomainIdList;
        }

        public final void setDefaultDomainIdList(Collection<String> defaultDomainIdList) {
            this.defaultDomainIdList = DefaultDomainIdListCopier.copy(defaultDomainIdList);
        }

        @Override
        public final Builder defaultDomainIdList(Collection<String> defaultDomainIdList) {
            this.defaultDomainIdList = DefaultDomainIdListCopier.copy(defaultDomainIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultDomainIdList(String ... defaultDomainIdList) {
            this.defaultDomainIdList(Arrays.asList(defaultDomainIdList));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return this.lastModifiedBy != null ? this.lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return this.weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        public final String getMaintenanceStatus() {
            return this.maintenanceStatus;
        }

        public final void setMaintenanceStatus(String maintenanceStatus) {
            this.maintenanceStatus = maintenanceStatus;
        }

        @Override
        public final Builder maintenanceStatus(String maintenanceStatus) {
            this.maintenanceStatus = maintenanceStatus;
            return this;
        }

        @Override
        public final Builder maintenanceStatus(MaintenanceStatus maintenanceStatus) {
            this.maintenanceStatus(maintenanceStatus == null ? null : maintenanceStatus.toString());
            return this;
        }

        @Override
        public DescribeMlflowAppResponse build() {
            return new DescribeMlflowAppResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMlflowAppResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder artifactStoreUri(String var1);

        public Builder mlflowVersion(String var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(MlflowAppStatus var1);

        public Builder modelRegistrationMode(String var1);

        public Builder modelRegistrationMode(ModelRegistrationMode var1);

        public Builder accountDefaultStatus(String var1);

        public Builder accountDefaultStatus(AccountDefaultStatus var1);

        public Builder defaultDomainIdList(Collection<String> var1);

        public Builder defaultDomainIdList(String ... var1);

        public Builder creationTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedBy(UserContext var1);

        default public Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return this.lastModifiedBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(lastModifiedBy)).build());
        }

        public Builder weeklyMaintenanceWindowStart(String var1);

        public Builder maintenanceStatus(String var1);

        public Builder maintenanceStatus(MaintenanceStatus var1);
    }
}

