/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AccountDefaultStatus;
import software.amazon.awssdk.services.sagemaker.model.DefaultDomainIdListCopier;
import software.amazon.awssdk.services.sagemaker.model.ModelRegistrationMode;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMlflowAppRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateMlflowAppRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateMlflowAppRequest.getter(CreateMlflowAppRequest::name)).setter(CreateMlflowAppRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARTIFACT_STORE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactStoreUri").getter(CreateMlflowAppRequest.getter(CreateMlflowAppRequest::artifactStoreUri)).setter(CreateMlflowAppRequest.setter(Builder::artifactStoreUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactStoreUri").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateMlflowAppRequest.getter(CreateMlflowAppRequest::roleArn)).setter(CreateMlflowAppRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> MODEL_REGISTRATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelRegistrationMode").getter(CreateMlflowAppRequest.getter(CreateMlflowAppRequest::modelRegistrationModeAsString)).setter(CreateMlflowAppRequest.setter(Builder::modelRegistrationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelRegistrationMode").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceWindowStart").getter(CreateMlflowAppRequest.getter(CreateMlflowAppRequest::weeklyMaintenanceWindowStart)).setter(CreateMlflowAppRequest.setter(Builder::weeklyMaintenanceWindowStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart").build()}).build();
    private static final SdkField<String> ACCOUNT_DEFAULT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountDefaultStatus").getter(CreateMlflowAppRequest.getter(CreateMlflowAppRequest::accountDefaultStatusAsString)).setter(CreateMlflowAppRequest.setter(Builder::accountDefaultStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountDefaultStatus").build()}).build();
    private static final SdkField<List<String>> DEFAULT_DOMAIN_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultDomainIdList").getter(CreateMlflowAppRequest.getter(CreateMlflowAppRequest::defaultDomainIdList)).setter(CreateMlflowAppRequest.setter(Builder::defaultDomainIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultDomainIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateMlflowAppRequest.getter(CreateMlflowAppRequest::tags)).setter(CreateMlflowAppRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARTIFACT_STORE_URI_FIELD, ROLE_ARN_FIELD, MODEL_REGISTRATION_MODE_FIELD, WEEKLY_MAINTENANCE_WINDOW_START_FIELD, ACCOUNT_DEFAULT_STATUS_FIELD, DEFAULT_DOMAIN_ID_LIST_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMlflowAppRequest.memberNameToFieldInitializer();
    private final String name;
    private final String artifactStoreUri;
    private final String roleArn;
    private final String modelRegistrationMode;
    private final String weeklyMaintenanceWindowStart;
    private final String accountDefaultStatus;
    private final List<String> defaultDomainIdList;
    private final List<Tag> tags;

    private CreateMlflowAppRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.artifactStoreUri = builder.artifactStoreUri;
        this.roleArn = builder.roleArn;
        this.modelRegistrationMode = builder.modelRegistrationMode;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
        this.accountDefaultStatus = builder.accountDefaultStatus;
        this.defaultDomainIdList = builder.defaultDomainIdList;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String artifactStoreUri() {
        return this.artifactStoreUri;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ModelRegistrationMode modelRegistrationMode() {
        return ModelRegistrationMode.fromValue(this.modelRegistrationMode);
    }

    public final String modelRegistrationModeAsString() {
        return this.modelRegistrationMode;
    }

    public final String weeklyMaintenanceWindowStart() {
        return this.weeklyMaintenanceWindowStart;
    }

    public final AccountDefaultStatus accountDefaultStatus() {
        return AccountDefaultStatus.fromValue(this.accountDefaultStatus);
    }

    public final String accountDefaultStatusAsString() {
        return this.accountDefaultStatus;
    }

    public final boolean hasDefaultDomainIdList() {
        return this.defaultDomainIdList != null && !(this.defaultDomainIdList instanceof SdkAutoConstructList);
    }

    public final List<String> defaultDomainIdList() {
        return this.defaultDomainIdList;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactStoreUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelRegistrationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountDefaultStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultDomainIdList() ? this.defaultDomainIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMlflowAppRequest)) {
            return false;
        }
        CreateMlflowAppRequest other = (CreateMlflowAppRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.artifactStoreUri(), other.artifactStoreUri()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.modelRegistrationModeAsString(), other.modelRegistrationModeAsString()) && Objects.equals(this.weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart()) && Objects.equals(this.accountDefaultStatusAsString(), other.accountDefaultStatusAsString()) && this.hasDefaultDomainIdList() == other.hasDefaultDomainIdList() && Objects.equals(this.defaultDomainIdList(), other.defaultDomainIdList()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMlflowAppRequest").add("Name", (Object)this.name()).add("ArtifactStoreUri", (Object)this.artifactStoreUri()).add("RoleArn", (Object)this.roleArn()).add("ModelRegistrationMode", (Object)this.modelRegistrationModeAsString()).add("WeeklyMaintenanceWindowStart", (Object)this.weeklyMaintenanceWindowStart()).add("AccountDefaultStatus", (Object)this.accountDefaultStatusAsString()).add("DefaultDomainIdList", this.hasDefaultDomainIdList() ? this.defaultDomainIdList() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ArtifactStoreUri": {
                return Optional.ofNullable(clazz.cast(this.artifactStoreUri()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ModelRegistrationMode": {
                return Optional.ofNullable(clazz.cast(this.modelRegistrationModeAsString()));
            }
            case "WeeklyMaintenanceWindowStart": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceWindowStart()));
            }
            case "AccountDefaultStatus": {
                return Optional.ofNullable(clazz.cast(this.accountDefaultStatusAsString()));
            }
            case "DefaultDomainIdList": {
                return Optional.ofNullable(clazz.cast(this.defaultDomainIdList()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("ArtifactStoreUri", ARTIFACT_STORE_URI_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("ModelRegistrationMode", MODEL_REGISTRATION_MODE_FIELD);
        map.put("WeeklyMaintenanceWindowStart", WEEKLY_MAINTENANCE_WINDOW_START_FIELD);
        map.put("AccountDefaultStatus", ACCOUNT_DEFAULT_STATUS_FIELD);
        map.put("DefaultDomainIdList", DEFAULT_DOMAIN_ID_LIST_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMlflowAppRequest, T> g) {
        return obj -> g.apply((CreateMlflowAppRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String name;
        private String artifactStoreUri;
        private String roleArn;
        private String modelRegistrationMode;
        private String weeklyMaintenanceWindowStart;
        private String accountDefaultStatus;
        private List<String> defaultDomainIdList = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMlflowAppRequest model) {
            super(model);
            this.name(model.name);
            this.artifactStoreUri(model.artifactStoreUri);
            this.roleArn(model.roleArn);
            this.modelRegistrationMode(model.modelRegistrationMode);
            this.weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
            this.accountDefaultStatus(model.accountDefaultStatus);
            this.defaultDomainIdList(model.defaultDomainIdList);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArtifactStoreUri() {
            return this.artifactStoreUri;
        }

        public final void setArtifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
        }

        @Override
        public final Builder artifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getModelRegistrationMode() {
            return this.modelRegistrationMode;
        }

        public final void setModelRegistrationMode(String modelRegistrationMode) {
            this.modelRegistrationMode = modelRegistrationMode;
        }

        @Override
        public final Builder modelRegistrationMode(String modelRegistrationMode) {
            this.modelRegistrationMode = modelRegistrationMode;
            return this;
        }

        @Override
        public final Builder modelRegistrationMode(ModelRegistrationMode modelRegistrationMode) {
            this.modelRegistrationMode(modelRegistrationMode == null ? null : modelRegistrationMode.toString());
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return this.weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        public final String getAccountDefaultStatus() {
            return this.accountDefaultStatus;
        }

        public final void setAccountDefaultStatus(String accountDefaultStatus) {
            this.accountDefaultStatus = accountDefaultStatus;
        }

        @Override
        public final Builder accountDefaultStatus(String accountDefaultStatus) {
            this.accountDefaultStatus = accountDefaultStatus;
            return this;
        }

        @Override
        public final Builder accountDefaultStatus(AccountDefaultStatus accountDefaultStatus) {
            this.accountDefaultStatus(accountDefaultStatus == null ? null : accountDefaultStatus.toString());
            return this;
        }

        public final Collection<String> getDefaultDomainIdList() {
            if (this.defaultDomainIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.defaultDomainIdList;
        }

        public final void setDefaultDomainIdList(Collection<String> defaultDomainIdList) {
            this.defaultDomainIdList = DefaultDomainIdListCopier.copy(defaultDomainIdList);
        }

        @Override
        public final Builder defaultDomainIdList(Collection<String> defaultDomainIdList) {
            this.defaultDomainIdList = DefaultDomainIdListCopier.copy(defaultDomainIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultDomainIdList(String ... defaultDomainIdList) {
            this.defaultDomainIdList(Arrays.asList(defaultDomainIdList));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMlflowAppRequest build() {
            return new CreateMlflowAppRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMlflowAppRequest> {
        public Builder name(String var1);

        public Builder artifactStoreUri(String var1);

        public Builder roleArn(String var1);

        public Builder modelRegistrationMode(String var1);

        public Builder modelRegistrationMode(ModelRegistrationMode var1);

        public Builder weeklyMaintenanceWindowStart(String var1);

        public Builder accountDefaultStatus(String var1);

        public Builder accountDefaultStatus(AccountDefaultStatus var1);

        public Builder defaultDomainIdList(Collection<String> var1);

        public Builder defaultDomainIdList(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

