/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ClusterCapacityRequirements;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStorageConfig;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStorageConfigsCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceType;
import software.amazon.awssdk.services.sagemaker.model.ClusterKubernetesConfig;
import software.amazon.awssdk.services.sagemaker.model.ClusterLifeCycleConfig;
import software.amazon.awssdk.services.sagemaker.model.DeepHealthCheckType;
import software.amazon.awssdk.services.sagemaker.model.OnStartDeepHealthChecksCopier;
import software.amazon.awssdk.services.sagemaker.model.ScheduledUpdateConfig;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterInstanceGroupSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterInstanceGroupSpecification> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::instanceCount)).setter(ClusterInstanceGroupSpecification.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final SdkField<Integer> MIN_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinInstanceCount").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::minInstanceCount)).setter(ClusterInstanceGroupSpecification.setter(Builder::minInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinInstanceCount").build()}).build();
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupName").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::instanceGroupName)).setter(ClusterInstanceGroupSpecification.setter(Builder::instanceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::instanceTypeAsString)).setter(ClusterInstanceGroupSpecification.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<ClusterLifeCycleConfig> LIFE_CYCLE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LifeCycleConfig").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::lifeCycleConfig)).setter(ClusterInstanceGroupSpecification.setter(Builder::lifeCycleConfig)).constructor(ClusterLifeCycleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleConfig").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRole").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::executionRole)).setter(ClusterInstanceGroupSpecification.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()}).build();
    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThreadsPerCore").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::threadsPerCore)).setter(ClusterInstanceGroupSpecification.setter(Builder::threadsPerCore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore").build()}).build();
    private static final SdkField<List<ClusterInstanceStorageConfig>> INSTANCE_STORAGE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceStorageConfigs").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::instanceStorageConfigs)).setter(ClusterInstanceGroupSpecification.setter(Builder::instanceStorageConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStorageConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterInstanceStorageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ON_START_DEEP_HEALTH_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OnStartDeepHealthChecks").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::onStartDeepHealthChecksAsStrings)).setter(ClusterInstanceGroupSpecification.setter(Builder::onStartDeepHealthChecksWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnStartDeepHealthChecks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRAINING_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingPlanArn").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::trainingPlanArn)).setter(ClusterInstanceGroupSpecification.setter(Builder::trainingPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanArn").build()}).build();
    private static final SdkField<VpcConfig> OVERRIDE_VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverrideVpcConfig").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::overrideVpcConfig)).setter(ClusterInstanceGroupSpecification.setter(Builder::overrideVpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideVpcConfig").build()}).build();
    private static final SdkField<ScheduledUpdateConfig> SCHEDULED_UPDATE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduledUpdateConfig").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::scheduledUpdateConfig)).setter(ClusterInstanceGroupSpecification.setter(Builder::scheduledUpdateConfig)).constructor(ScheduledUpdateConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledUpdateConfig").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::imageId)).setter(ClusterInstanceGroupSpecification.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<ClusterKubernetesConfig> KUBERNETES_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KubernetesConfig").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::kubernetesConfig)).setter(ClusterInstanceGroupSpecification.setter(Builder::kubernetesConfig)).constructor(ClusterKubernetesConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KubernetesConfig").build()}).build();
    private static final SdkField<ClusterCapacityRequirements> CAPACITY_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityRequirements").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::capacityRequirements)).setter(ClusterInstanceGroupSpecification.setter(Builder::capacityRequirements)).constructor(ClusterCapacityRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityRequirements").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD, MIN_INSTANCE_COUNT_FIELD, INSTANCE_GROUP_NAME_FIELD, INSTANCE_TYPE_FIELD, LIFE_CYCLE_CONFIG_FIELD, EXECUTION_ROLE_FIELD, THREADS_PER_CORE_FIELD, INSTANCE_STORAGE_CONFIGS_FIELD, ON_START_DEEP_HEALTH_CHECKS_FIELD, TRAINING_PLAN_ARN_FIELD, OVERRIDE_VPC_CONFIG_FIELD, SCHEDULED_UPDATE_CONFIG_FIELD, IMAGE_ID_FIELD, KUBERNETES_CONFIG_FIELD, CAPACITY_REQUIREMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterInstanceGroupSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer instanceCount;
    private final Integer minInstanceCount;
    private final String instanceGroupName;
    private final String instanceType;
    private final ClusterLifeCycleConfig lifeCycleConfig;
    private final String executionRole;
    private final Integer threadsPerCore;
    private final List<ClusterInstanceStorageConfig> instanceStorageConfigs;
    private final List<String> onStartDeepHealthChecks;
    private final String trainingPlanArn;
    private final VpcConfig overrideVpcConfig;
    private final ScheduledUpdateConfig scheduledUpdateConfig;
    private final String imageId;
    private final ClusterKubernetesConfig kubernetesConfig;
    private final ClusterCapacityRequirements capacityRequirements;

    private ClusterInstanceGroupSpecification(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.minInstanceCount = builder.minInstanceCount;
        this.instanceGroupName = builder.instanceGroupName;
        this.instanceType = builder.instanceType;
        this.lifeCycleConfig = builder.lifeCycleConfig;
        this.executionRole = builder.executionRole;
        this.threadsPerCore = builder.threadsPerCore;
        this.instanceStorageConfigs = builder.instanceStorageConfigs;
        this.onStartDeepHealthChecks = builder.onStartDeepHealthChecks;
        this.trainingPlanArn = builder.trainingPlanArn;
        this.overrideVpcConfig = builder.overrideVpcConfig;
        this.scheduledUpdateConfig = builder.scheduledUpdateConfig;
        this.imageId = builder.imageId;
        this.kubernetesConfig = builder.kubernetesConfig;
        this.capacityRequirements = builder.capacityRequirements;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final Integer minInstanceCount() {
        return this.minInstanceCount;
    }

    public final String instanceGroupName() {
        return this.instanceGroupName;
    }

    public final ClusterInstanceType instanceType() {
        return ClusterInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final ClusterLifeCycleConfig lifeCycleConfig() {
        return this.lifeCycleConfig;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final Integer threadsPerCore() {
        return this.threadsPerCore;
    }

    public final boolean hasInstanceStorageConfigs() {
        return this.instanceStorageConfigs != null && !(this.instanceStorageConfigs instanceof SdkAutoConstructList);
    }

    public final List<ClusterInstanceStorageConfig> instanceStorageConfigs() {
        return this.instanceStorageConfigs;
    }

    public final List<DeepHealthCheckType> onStartDeepHealthChecks() {
        return OnStartDeepHealthChecksCopier.copyStringToEnum(this.onStartDeepHealthChecks);
    }

    public final boolean hasOnStartDeepHealthChecks() {
        return this.onStartDeepHealthChecks != null && !(this.onStartDeepHealthChecks instanceof SdkAutoConstructList);
    }

    public final List<String> onStartDeepHealthChecksAsStrings() {
        return this.onStartDeepHealthChecks;
    }

    public final String trainingPlanArn() {
        return this.trainingPlanArn;
    }

    public final VpcConfig overrideVpcConfig() {
        return this.overrideVpcConfig;
    }

    public final ScheduledUpdateConfig scheduledUpdateConfig() {
        return this.scheduledUpdateConfig;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final ClusterKubernetesConfig kubernetesConfig() {
        return this.kubernetesConfig;
    }

    public final ClusterCapacityRequirements capacityRequirements() {
        return this.capacityRequirements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.minInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadsPerCore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceStorageConfigs() ? this.instanceStorageConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOnStartDeepHealthChecks() ? this.onStartDeepHealthChecksAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledUpdateConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityRequirements());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterInstanceGroupSpecification)) {
            return false;
        }
        ClusterInstanceGroupSpecification other = (ClusterInstanceGroupSpecification)obj;
        return Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.minInstanceCount(), other.minInstanceCount()) && Objects.equals(this.instanceGroupName(), other.instanceGroupName()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.lifeCycleConfig(), other.lifeCycleConfig()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.threadsPerCore(), other.threadsPerCore()) && this.hasInstanceStorageConfigs() == other.hasInstanceStorageConfigs() && Objects.equals(this.instanceStorageConfigs(), other.instanceStorageConfigs()) && this.hasOnStartDeepHealthChecks() == other.hasOnStartDeepHealthChecks() && Objects.equals(this.onStartDeepHealthChecksAsStrings(), other.onStartDeepHealthChecksAsStrings()) && Objects.equals(this.trainingPlanArn(), other.trainingPlanArn()) && Objects.equals(this.overrideVpcConfig(), other.overrideVpcConfig()) && Objects.equals(this.scheduledUpdateConfig(), other.scheduledUpdateConfig()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.kubernetesConfig(), other.kubernetesConfig()) && Objects.equals(this.capacityRequirements(), other.capacityRequirements());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterInstanceGroupSpecification").add("InstanceCount", (Object)this.instanceCount()).add("MinInstanceCount", (Object)this.minInstanceCount()).add("InstanceGroupName", (Object)this.instanceGroupName()).add("InstanceType", (Object)this.instanceTypeAsString()).add("LifeCycleConfig", (Object)this.lifeCycleConfig()).add("ExecutionRole", (Object)this.executionRole()).add("ThreadsPerCore", (Object)this.threadsPerCore()).add("InstanceStorageConfigs", this.hasInstanceStorageConfigs() ? this.instanceStorageConfigs() : null).add("OnStartDeepHealthChecks", this.hasOnStartDeepHealthChecks() ? this.onStartDeepHealthChecksAsStrings() : null).add("TrainingPlanArn", (Object)this.trainingPlanArn()).add("OverrideVpcConfig", (Object)this.overrideVpcConfig()).add("ScheduledUpdateConfig", (Object)this.scheduledUpdateConfig()).add("ImageId", (Object)this.imageId()).add("KubernetesConfig", (Object)this.kubernetesConfig()).add("CapacityRequirements", (Object)this.capacityRequirements()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "MinInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.minInstanceCount()));
            }
            case "InstanceGroupName": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupName()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "LifeCycleConfig": {
                return Optional.ofNullable(clazz.cast(this.lifeCycleConfig()));
            }
            case "ExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "ThreadsPerCore": {
                return Optional.ofNullable(clazz.cast(this.threadsPerCore()));
            }
            case "InstanceStorageConfigs": {
                return Optional.ofNullable(clazz.cast(this.instanceStorageConfigs()));
            }
            case "OnStartDeepHealthChecks": {
                return Optional.ofNullable(clazz.cast(this.onStartDeepHealthChecksAsStrings()));
            }
            case "TrainingPlanArn": {
                return Optional.ofNullable(clazz.cast(this.trainingPlanArn()));
            }
            case "OverrideVpcConfig": {
                return Optional.ofNullable(clazz.cast(this.overrideVpcConfig()));
            }
            case "ScheduledUpdateConfig": {
                return Optional.ofNullable(clazz.cast(this.scheduledUpdateConfig()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "KubernetesConfig": {
                return Optional.ofNullable(clazz.cast(this.kubernetesConfig()));
            }
            case "CapacityRequirements": {
                return Optional.ofNullable(clazz.cast(this.capacityRequirements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("MinInstanceCount", MIN_INSTANCE_COUNT_FIELD);
        map.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("LifeCycleConfig", LIFE_CYCLE_CONFIG_FIELD);
        map.put("ExecutionRole", EXECUTION_ROLE_FIELD);
        map.put("ThreadsPerCore", THREADS_PER_CORE_FIELD);
        map.put("InstanceStorageConfigs", INSTANCE_STORAGE_CONFIGS_FIELD);
        map.put("OnStartDeepHealthChecks", ON_START_DEEP_HEALTH_CHECKS_FIELD);
        map.put("TrainingPlanArn", TRAINING_PLAN_ARN_FIELD);
        map.put("OverrideVpcConfig", OVERRIDE_VPC_CONFIG_FIELD);
        map.put("ScheduledUpdateConfig", SCHEDULED_UPDATE_CONFIG_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("KubernetesConfig", KUBERNETES_CONFIG_FIELD);
        map.put("CapacityRequirements", CAPACITY_REQUIREMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterInstanceGroupSpecification, T> g) {
        return obj -> g.apply((ClusterInstanceGroupSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private Integer minInstanceCount;
        private String instanceGroupName;
        private String instanceType;
        private ClusterLifeCycleConfig lifeCycleConfig;
        private String executionRole;
        private Integer threadsPerCore;
        private List<ClusterInstanceStorageConfig> instanceStorageConfigs = DefaultSdkAutoConstructList.getInstance();
        private List<String> onStartDeepHealthChecks = DefaultSdkAutoConstructList.getInstance();
        private String trainingPlanArn;
        private VpcConfig overrideVpcConfig;
        private ScheduledUpdateConfig scheduledUpdateConfig;
        private String imageId;
        private ClusterKubernetesConfig kubernetesConfig;
        private ClusterCapacityRequirements capacityRequirements;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterInstanceGroupSpecification model) {
            this.instanceCount(model.instanceCount);
            this.minInstanceCount(model.minInstanceCount);
            this.instanceGroupName(model.instanceGroupName);
            this.instanceType(model.instanceType);
            this.lifeCycleConfig(model.lifeCycleConfig);
            this.executionRole(model.executionRole);
            this.threadsPerCore(model.threadsPerCore);
            this.instanceStorageConfigs(model.instanceStorageConfigs);
            this.onStartDeepHealthChecksWithStrings(model.onStartDeepHealthChecks);
            this.trainingPlanArn(model.trainingPlanArn);
            this.overrideVpcConfig(model.overrideVpcConfig);
            this.scheduledUpdateConfig(model.scheduledUpdateConfig);
            this.imageId(model.imageId);
            this.kubernetesConfig(model.kubernetesConfig);
            this.capacityRequirements(model.capacityRequirements);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Integer getMinInstanceCount() {
            return this.minInstanceCount;
        }

        public final void setMinInstanceCount(Integer minInstanceCount) {
            this.minInstanceCount = minInstanceCount;
        }

        @Override
        public final Builder minInstanceCount(Integer minInstanceCount) {
            this.minInstanceCount = minInstanceCount;
            return this;
        }

        public final String getInstanceGroupName() {
            return this.instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ClusterInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final ClusterLifeCycleConfig.Builder getLifeCycleConfig() {
            return this.lifeCycleConfig != null ? this.lifeCycleConfig.toBuilder() : null;
        }

        public final void setLifeCycleConfig(ClusterLifeCycleConfig.BuilderImpl lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig != null ? lifeCycleConfig.build() : null;
        }

        @Override
        public final Builder lifeCycleConfig(ClusterLifeCycleConfig lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return this.threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        public final List<ClusterInstanceStorageConfig.Builder> getInstanceStorageConfigs() {
            List<ClusterInstanceStorageConfig.Builder> result = ClusterInstanceStorageConfigsCopier.copyToBuilder(this.instanceStorageConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceStorageConfigs(Collection<ClusterInstanceStorageConfig.BuilderImpl> instanceStorageConfigs) {
            this.instanceStorageConfigs = ClusterInstanceStorageConfigsCopier.copyFromBuilder(instanceStorageConfigs);
        }

        @Override
        public final Builder instanceStorageConfigs(Collection<ClusterInstanceStorageConfig> instanceStorageConfigs) {
            this.instanceStorageConfigs = ClusterInstanceStorageConfigsCopier.copy(instanceStorageConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStorageConfigs(ClusterInstanceStorageConfig ... instanceStorageConfigs) {
            this.instanceStorageConfigs(Arrays.asList(instanceStorageConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStorageConfigs(Consumer<ClusterInstanceStorageConfig.Builder> ... instanceStorageConfigs) {
            this.instanceStorageConfigs(Stream.of(instanceStorageConfigs).map(c -> (ClusterInstanceStorageConfig)((ClusterInstanceStorageConfig.Builder)ClusterInstanceStorageConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getOnStartDeepHealthChecks() {
            if (this.onStartDeepHealthChecks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.onStartDeepHealthChecks;
        }

        public final void setOnStartDeepHealthChecks(Collection<String> onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks = OnStartDeepHealthChecksCopier.copy(onStartDeepHealthChecks);
        }

        @Override
        public final Builder onStartDeepHealthChecksWithStrings(Collection<String> onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks = OnStartDeepHealthChecksCopier.copy(onStartDeepHealthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStartDeepHealthChecksWithStrings(String ... onStartDeepHealthChecks) {
            this.onStartDeepHealthChecksWithStrings(Arrays.asList(onStartDeepHealthChecks));
            return this;
        }

        @Override
        public final Builder onStartDeepHealthChecks(Collection<DeepHealthCheckType> onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks = OnStartDeepHealthChecksCopier.copyEnumToString(onStartDeepHealthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStartDeepHealthChecks(DeepHealthCheckType ... onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks(Arrays.asList(onStartDeepHealthChecks));
            return this;
        }

        public final String getTrainingPlanArn() {
            return this.trainingPlanArn;
        }

        public final void setTrainingPlanArn(String trainingPlanArn) {
            this.trainingPlanArn = trainingPlanArn;
        }

        @Override
        public final Builder trainingPlanArn(String trainingPlanArn) {
            this.trainingPlanArn = trainingPlanArn;
            return this;
        }

        public final VpcConfig.Builder getOverrideVpcConfig() {
            return this.overrideVpcConfig != null ? this.overrideVpcConfig.toBuilder() : null;
        }

        public final void setOverrideVpcConfig(VpcConfig.BuilderImpl overrideVpcConfig) {
            this.overrideVpcConfig = overrideVpcConfig != null ? overrideVpcConfig.build() : null;
        }

        @Override
        public final Builder overrideVpcConfig(VpcConfig overrideVpcConfig) {
            this.overrideVpcConfig = overrideVpcConfig;
            return this;
        }

        public final ScheduledUpdateConfig.Builder getScheduledUpdateConfig() {
            return this.scheduledUpdateConfig != null ? this.scheduledUpdateConfig.toBuilder() : null;
        }

        public final void setScheduledUpdateConfig(ScheduledUpdateConfig.BuilderImpl scheduledUpdateConfig) {
            this.scheduledUpdateConfig = scheduledUpdateConfig != null ? scheduledUpdateConfig.build() : null;
        }

        @Override
        public final Builder scheduledUpdateConfig(ScheduledUpdateConfig scheduledUpdateConfig) {
            this.scheduledUpdateConfig = scheduledUpdateConfig;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final ClusterKubernetesConfig.Builder getKubernetesConfig() {
            return this.kubernetesConfig != null ? this.kubernetesConfig.toBuilder() : null;
        }

        public final void setKubernetesConfig(ClusterKubernetesConfig.BuilderImpl kubernetesConfig) {
            this.kubernetesConfig = kubernetesConfig != null ? kubernetesConfig.build() : null;
        }

        @Override
        public final Builder kubernetesConfig(ClusterKubernetesConfig kubernetesConfig) {
            this.kubernetesConfig = kubernetesConfig;
            return this;
        }

        public final ClusterCapacityRequirements.Builder getCapacityRequirements() {
            return this.capacityRequirements != null ? this.capacityRequirements.toBuilder() : null;
        }

        public final void setCapacityRequirements(ClusterCapacityRequirements.BuilderImpl capacityRequirements) {
            this.capacityRequirements = capacityRequirements != null ? capacityRequirements.build() : null;
        }

        @Override
        public final Builder capacityRequirements(ClusterCapacityRequirements capacityRequirements) {
            this.capacityRequirements = capacityRequirements;
            return this;
        }

        public ClusterInstanceGroupSpecification build() {
            return new ClusterInstanceGroupSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterInstanceGroupSpecification> {
        public Builder instanceCount(Integer var1);

        public Builder minInstanceCount(Integer var1);

        public Builder instanceGroupName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ClusterInstanceType var1);

        public Builder lifeCycleConfig(ClusterLifeCycleConfig var1);

        default public Builder lifeCycleConfig(Consumer<ClusterLifeCycleConfig.Builder> lifeCycleConfig) {
            return this.lifeCycleConfig((ClusterLifeCycleConfig)((ClusterLifeCycleConfig.Builder)ClusterLifeCycleConfig.builder().applyMutation(lifeCycleConfig)).build());
        }

        public Builder executionRole(String var1);

        public Builder threadsPerCore(Integer var1);

        public Builder instanceStorageConfigs(Collection<ClusterInstanceStorageConfig> var1);

        public Builder instanceStorageConfigs(ClusterInstanceStorageConfig ... var1);

        public Builder instanceStorageConfigs(Consumer<ClusterInstanceStorageConfig.Builder> ... var1);

        public Builder onStartDeepHealthChecksWithStrings(Collection<String> var1);

        public Builder onStartDeepHealthChecksWithStrings(String ... var1);

        public Builder onStartDeepHealthChecks(Collection<DeepHealthCheckType> var1);

        public Builder onStartDeepHealthChecks(DeepHealthCheckType ... var1);

        public Builder trainingPlanArn(String var1);

        public Builder overrideVpcConfig(VpcConfig var1);

        default public Builder overrideVpcConfig(Consumer<VpcConfig.Builder> overrideVpcConfig) {
            return this.overrideVpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(overrideVpcConfig)).build());
        }

        public Builder scheduledUpdateConfig(ScheduledUpdateConfig var1);

        default public Builder scheduledUpdateConfig(Consumer<ScheduledUpdateConfig.Builder> scheduledUpdateConfig) {
            return this.scheduledUpdateConfig((ScheduledUpdateConfig)((ScheduledUpdateConfig.Builder)ScheduledUpdateConfig.builder().applyMutation(scheduledUpdateConfig)).build());
        }

        public Builder imageId(String var1);

        public Builder kubernetesConfig(ClusterKubernetesConfig var1);

        default public Builder kubernetesConfig(Consumer<ClusterKubernetesConfig.Builder> kubernetesConfig) {
            return this.kubernetesConfig((ClusterKubernetesConfig)((ClusterKubernetesConfig.Builder)ClusterKubernetesConfig.builder().applyMutation(kubernetesConfig)).build());
        }

        public Builder capacityRequirements(ClusterCapacityRequirements var1);

        default public Builder capacityRequirements(Consumer<ClusterCapacityRequirements.Builder> capacityRequirements) {
            return this.capacityRequirements((ClusterCapacityRequirements)((ClusterCapacityRequirements.Builder)ClusterCapacityRequirements.builder().applyMutation(capacityRequirements)).build());
        }
    }
}

