/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.BatchRebootClusterNodeLogicalIdsError;
import software.amazon.awssdk.services.sagemaker.model.BatchRebootClusterNodeLogicalIdsErrorsCopier;
import software.amazon.awssdk.services.sagemaker.model.BatchRebootClusterNodesError;
import software.amazon.awssdk.services.sagemaker.model.BatchRebootClusterNodesErrorsCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeIdsCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeLogicalIdListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchRebootClusterNodesResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, BatchRebootClusterNodesResponse> {
    private static final SdkField<List<String>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Successful").getter(BatchRebootClusterNodesResponse.getter(BatchRebootClusterNodesResponse::successful)).setter(BatchRebootClusterNodesResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchRebootClusterNodesError>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Failed").getter(BatchRebootClusterNodesResponse.getter(BatchRebootClusterNodesResponse::failed)).setter(BatchRebootClusterNodesResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchRebootClusterNodesError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchRebootClusterNodeLogicalIdsError>> FAILED_NODE_LOGICAL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedNodeLogicalIds").getter(BatchRebootClusterNodesResponse.getter(BatchRebootClusterNodesResponse::failedNodeLogicalIds)).setter(BatchRebootClusterNodesResponse.setter(Builder::failedNodeLogicalIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedNodeLogicalIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchRebootClusterNodeLogicalIdsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUCCESSFUL_NODE_LOGICAL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfulNodeLogicalIds").getter(BatchRebootClusterNodesResponse.getter(BatchRebootClusterNodesResponse::successfulNodeLogicalIds)).setter(BatchRebootClusterNodesResponse.setter(Builder::successfulNodeLogicalIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulNodeLogicalIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD, FAILED_FIELD, FAILED_NODE_LOGICAL_IDS_FIELD, SUCCESSFUL_NODE_LOGICAL_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchRebootClusterNodesResponse.memberNameToFieldInitializer();
    private final List<String> successful;
    private final List<BatchRebootClusterNodesError> failed;
    private final List<BatchRebootClusterNodeLogicalIdsError> failedNodeLogicalIds;
    private final List<String> successfulNodeLogicalIds;

    private BatchRebootClusterNodesResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
        this.failedNodeLogicalIds = builder.failedNodeLogicalIds;
        this.successfulNodeLogicalIds = builder.successfulNodeLogicalIds;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<String> successful() {
        return this.successful;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<BatchRebootClusterNodesError> failed() {
        return this.failed;
    }

    public final boolean hasFailedNodeLogicalIds() {
        return this.failedNodeLogicalIds != null && !(this.failedNodeLogicalIds instanceof SdkAutoConstructList);
    }

    public final List<BatchRebootClusterNodeLogicalIdsError> failedNodeLogicalIds() {
        return this.failedNodeLogicalIds;
    }

    public final boolean hasSuccessfulNodeLogicalIds() {
        return this.successfulNodeLogicalIds != null && !(this.successfulNodeLogicalIds instanceof SdkAutoConstructList);
    }

    public final List<String> successfulNodeLogicalIds() {
        return this.successfulNodeLogicalIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedNodeLogicalIds() ? this.failedNodeLogicalIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulNodeLogicalIds() ? this.successfulNodeLogicalIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchRebootClusterNodesResponse)) {
            return false;
        }
        BatchRebootClusterNodesResponse other = (BatchRebootClusterNodesResponse)((Object)obj);
        return this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful()) && this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed()) && this.hasFailedNodeLogicalIds() == other.hasFailedNodeLogicalIds() && Objects.equals(this.failedNodeLogicalIds(), other.failedNodeLogicalIds()) && this.hasSuccessfulNodeLogicalIds() == other.hasSuccessfulNodeLogicalIds() && Objects.equals(this.successfulNodeLogicalIds(), other.successfulNodeLogicalIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchRebootClusterNodesResponse").add("Successful", this.hasSuccessful() ? this.successful() : null).add("Failed", this.hasFailed() ? this.failed() : null).add("FailedNodeLogicalIds", this.hasFailedNodeLogicalIds() ? this.failedNodeLogicalIds() : null).add("SuccessfulNodeLogicalIds", this.hasSuccessfulNodeLogicalIds() ? this.successfulNodeLogicalIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
            case "FailedNodeLogicalIds": {
                return Optional.ofNullable(clazz.cast(this.failedNodeLogicalIds()));
            }
            case "SuccessfulNodeLogicalIds": {
                return Optional.ofNullable(clazz.cast(this.successfulNodeLogicalIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Successful", SUCCESSFUL_FIELD);
        map.put("Failed", FAILED_FIELD);
        map.put("FailedNodeLogicalIds", FAILED_NODE_LOGICAL_IDS_FIELD);
        map.put("SuccessfulNodeLogicalIds", SUCCESSFUL_NODE_LOGICAL_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchRebootClusterNodesResponse, T> g) {
        return obj -> g.apply((BatchRebootClusterNodesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<String> successful = DefaultSdkAutoConstructList.getInstance();
        private List<BatchRebootClusterNodesError> failed = DefaultSdkAutoConstructList.getInstance();
        private List<BatchRebootClusterNodeLogicalIdsError> failedNodeLogicalIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> successfulNodeLogicalIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchRebootClusterNodesResponse model) {
            super(model);
            this.successful(model.successful);
            this.failed(model.failed);
            this.failedNodeLogicalIds(model.failedNodeLogicalIds);
            this.successfulNodeLogicalIds(model.successfulNodeLogicalIds);
        }

        public final Collection<String> getSuccessful() {
            if (this.successful instanceof SdkAutoConstructList) {
                return null;
            }
            return this.successful;
        }

        public final void setSuccessful(Collection<String> successful) {
            this.successful = ClusterNodeIdsCopier.copy(successful);
        }

        @Override
        public final Builder successful(Collection<String> successful) {
            this.successful = ClusterNodeIdsCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(String ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        public final List<BatchRebootClusterNodesError.Builder> getFailed() {
            List<BatchRebootClusterNodesError.Builder> result = BatchRebootClusterNodesErrorsCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchRebootClusterNodesError.BuilderImpl> failed) {
            this.failed = BatchRebootClusterNodesErrorsCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchRebootClusterNodesError> failed) {
            this.failed = BatchRebootClusterNodesErrorsCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchRebootClusterNodesError ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchRebootClusterNodesError.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (BatchRebootClusterNodesError)((BatchRebootClusterNodesError.Builder)BatchRebootClusterNodesError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchRebootClusterNodeLogicalIdsError.Builder> getFailedNodeLogicalIds() {
            List<BatchRebootClusterNodeLogicalIdsError.Builder> result = BatchRebootClusterNodeLogicalIdsErrorsCopier.copyToBuilder(this.failedNodeLogicalIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedNodeLogicalIds(Collection<BatchRebootClusterNodeLogicalIdsError.BuilderImpl> failedNodeLogicalIds) {
            this.failedNodeLogicalIds = BatchRebootClusterNodeLogicalIdsErrorsCopier.copyFromBuilder(failedNodeLogicalIds);
        }

        @Override
        public final Builder failedNodeLogicalIds(Collection<BatchRebootClusterNodeLogicalIdsError> failedNodeLogicalIds) {
            this.failedNodeLogicalIds = BatchRebootClusterNodeLogicalIdsErrorsCopier.copy(failedNodeLogicalIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedNodeLogicalIds(BatchRebootClusterNodeLogicalIdsError ... failedNodeLogicalIds) {
            this.failedNodeLogicalIds(Arrays.asList(failedNodeLogicalIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedNodeLogicalIds(Consumer<BatchRebootClusterNodeLogicalIdsError.Builder> ... failedNodeLogicalIds) {
            this.failedNodeLogicalIds(Stream.of(failedNodeLogicalIds).map(c -> (BatchRebootClusterNodeLogicalIdsError)((BatchRebootClusterNodeLogicalIdsError.Builder)BatchRebootClusterNodeLogicalIdsError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSuccessfulNodeLogicalIds() {
            if (this.successfulNodeLogicalIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.successfulNodeLogicalIds;
        }

        public final void setSuccessfulNodeLogicalIds(Collection<String> successfulNodeLogicalIds) {
            this.successfulNodeLogicalIds = ClusterNodeLogicalIdListCopier.copy(successfulNodeLogicalIds);
        }

        @Override
        public final Builder successfulNodeLogicalIds(Collection<String> successfulNodeLogicalIds) {
            this.successfulNodeLogicalIds = ClusterNodeLogicalIdListCopier.copy(successfulNodeLogicalIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulNodeLogicalIds(String ... successfulNodeLogicalIds) {
            this.successfulNodeLogicalIds(Arrays.asList(successfulNodeLogicalIds));
            return this;
        }

        @Override
        public BatchRebootClusterNodesResponse build() {
            return new BatchRebootClusterNodesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchRebootClusterNodesResponse> {
        public Builder successful(Collection<String> var1);

        public Builder successful(String ... var1);

        public Builder failed(Collection<BatchRebootClusterNodesError> var1);

        public Builder failed(BatchRebootClusterNodesError ... var1);

        public Builder failed(Consumer<BatchRebootClusterNodesError.Builder> ... var1);

        public Builder failedNodeLogicalIds(Collection<BatchRebootClusterNodeLogicalIdsError> var1);

        public Builder failedNodeLogicalIds(BatchRebootClusterNodeLogicalIdsError ... var1);

        public Builder failedNodeLogicalIds(Consumer<BatchRebootClusterNodeLogicalIdsError.Builder> ... var1);

        public Builder successfulNodeLogicalIds(Collection<String> var1);

        public Builder successfulNodeLogicalIds(String ... var1);
    }
}

