/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse;

public class ListEndpointConfigsIterable
implements SdkIterable<ListEndpointConfigsResponse> {
    private final SageMakerClient client;
    private final ListEndpointConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEndpointConfigsIterable(SageMakerClient client, ListEndpointConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEndpointConfigsResponseFetcher();
    }

    public Iterator<ListEndpointConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListEndpointConfigsIterable resume(ListEndpointConfigsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListEndpointConfigsIterable(this.client, (ListEndpointConfigsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListEndpointConfigsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListEndpointConfigsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListEndpointConfigsResponseFetcher
    implements SyncPageFetcher<ListEndpointConfigsResponse> {
        private ListEndpointConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEndpointConfigsResponse nextPage(ListEndpointConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointConfigsIterable.this.client.listEndpointConfigs(ListEndpointConfigsIterable.this.firstRequest);
            }
            return ListEndpointConfigsIterable.this.client.listEndpointConfigs((ListEndpointConfigsRequest)((Object)ListEndpointConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

