/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3FileSystemConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3FileSystemConfig> {
    private static final SdkField<String> MOUNT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MountPath").getter(S3FileSystemConfig.getter(S3FileSystemConfig::mountPath)).setter(S3FileSystemConfig.setter(Builder::mountPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountPath").build()}).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(S3FileSystemConfig.getter(S3FileSystemConfig::s3Uri)).setter(S3FileSystemConfig.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOUNT_PATH_FIELD, S3_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3FileSystemConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mountPath;
    private final String s3Uri;

    private S3FileSystemConfig(BuilderImpl builder) {
        this.mountPath = builder.mountPath;
        this.s3Uri = builder.s3Uri;
    }

    public final String mountPath() {
        return this.mountPath;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mountPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3FileSystemConfig)) {
            return false;
        }
        S3FileSystemConfig other = (S3FileSystemConfig)obj;
        return Objects.equals(this.mountPath(), other.mountPath()) && Objects.equals(this.s3Uri(), other.s3Uri());
    }

    public final String toString() {
        return ToString.builder((String)"S3FileSystemConfig").add("MountPath", (Object)this.mountPath()).add("S3Uri", (Object)this.s3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MountPath": {
                return Optional.ofNullable(clazz.cast(this.mountPath()));
            }
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MountPath", MOUNT_PATH_FIELD);
        map.put("S3Uri", S3_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3FileSystemConfig, T> g) {
        return obj -> g.apply((S3FileSystemConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mountPath;
        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(S3FileSystemConfig model) {
            this.mountPath(model.mountPath);
            this.s3Uri(model.s3Uri);
        }

        public final String getMountPath() {
            return this.mountPath;
        }

        public final void setMountPath(String mountPath) {
            this.mountPath = mountPath;
        }

        @Override
        public final Builder mountPath(String mountPath) {
            this.mountPath = mountPath;
            return this;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public S3FileSystemConfig build() {
            return new S3FileSystemConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3FileSystemConfig> {
        public Builder mountPath(String var1);

        public Builder s3Uri(String var1);
    }
}

