/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TtlDurationUnit {
    SECONDS("Seconds"),
    MINUTES("Minutes"),
    HOURS("Hours"),
    DAYS("Days"),
    WEEKS("Weeks"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TtlDurationUnit> VALUE_MAP;
    private final String value;

    private TtlDurationUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TtlDurationUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TtlDurationUnit> knownValues() {
        EnumSet<TtlDurationUnit> knownValues = EnumSet.allOf(TtlDurationUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TtlDurationUnit.class, TtlDurationUnit::toString);
    }
}

