/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.LifecycleManagement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdleSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdleSettings> {
    private static final SdkField<String> LIFECYCLE_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LifecycleManagement").getter(IdleSettings.getter(IdleSettings::lifecycleManagementAsString)).setter(IdleSettings.setter(Builder::lifecycleManagement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleManagement").build()}).build();
    private static final SdkField<Integer> IDLE_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IdleTimeoutInMinutes").getter(IdleSettings.getter(IdleSettings::idleTimeoutInMinutes)).setter(IdleSettings.setter(Builder::idleTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleTimeoutInMinutes").build()}).build();
    private static final SdkField<Integer> MIN_IDLE_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinIdleTimeoutInMinutes").getter(IdleSettings.getter(IdleSettings::minIdleTimeoutInMinutes)).setter(IdleSettings.setter(Builder::minIdleTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinIdleTimeoutInMinutes").build()}).build();
    private static final SdkField<Integer> MAX_IDLE_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxIdleTimeoutInMinutes").getter(IdleSettings.getter(IdleSettings::maxIdleTimeoutInMinutes)).setter(IdleSettings.setter(Builder::maxIdleTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxIdleTimeoutInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_MANAGEMENT_FIELD, IDLE_TIMEOUT_IN_MINUTES_FIELD, MIN_IDLE_TIMEOUT_IN_MINUTES_FIELD, MAX_IDLE_TIMEOUT_IN_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IdleSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String lifecycleManagement;
    private final Integer idleTimeoutInMinutes;
    private final Integer minIdleTimeoutInMinutes;
    private final Integer maxIdleTimeoutInMinutes;

    private IdleSettings(BuilderImpl builder) {
        this.lifecycleManagement = builder.lifecycleManagement;
        this.idleTimeoutInMinutes = builder.idleTimeoutInMinutes;
        this.minIdleTimeoutInMinutes = builder.minIdleTimeoutInMinutes;
        this.maxIdleTimeoutInMinutes = builder.maxIdleTimeoutInMinutes;
    }

    public final LifecycleManagement lifecycleManagement() {
        return LifecycleManagement.fromValue(this.lifecycleManagement);
    }

    public final String lifecycleManagementAsString() {
        return this.lifecycleManagement;
    }

    public final Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public final Integer minIdleTimeoutInMinutes() {
        return this.minIdleTimeoutInMinutes;
    }

    public final Integer maxIdleTimeoutInMinutes() {
        return this.maxIdleTimeoutInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleManagementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIdleTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxIdleTimeoutInMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdleSettings)) {
            return false;
        }
        IdleSettings other = (IdleSettings)obj;
        return Objects.equals(this.lifecycleManagementAsString(), other.lifecycleManagementAsString()) && Objects.equals(this.idleTimeoutInMinutes(), other.idleTimeoutInMinutes()) && Objects.equals(this.minIdleTimeoutInMinutes(), other.minIdleTimeoutInMinutes()) && Objects.equals(this.maxIdleTimeoutInMinutes(), other.maxIdleTimeoutInMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"IdleSettings").add("LifecycleManagement", (Object)this.lifecycleManagementAsString()).add("IdleTimeoutInMinutes", (Object)this.idleTimeoutInMinutes()).add("MinIdleTimeoutInMinutes", (Object)this.minIdleTimeoutInMinutes()).add("MaxIdleTimeoutInMinutes", (Object)this.maxIdleTimeoutInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LifecycleManagement": {
                return Optional.ofNullable(clazz.cast(this.lifecycleManagementAsString()));
            }
            case "IdleTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.idleTimeoutInMinutes()));
            }
            case "MinIdleTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.minIdleTimeoutInMinutes()));
            }
            case "MaxIdleTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.maxIdleTimeoutInMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LifecycleManagement", LIFECYCLE_MANAGEMENT_FIELD);
        map.put("IdleTimeoutInMinutes", IDLE_TIMEOUT_IN_MINUTES_FIELD);
        map.put("MinIdleTimeoutInMinutes", MIN_IDLE_TIMEOUT_IN_MINUTES_FIELD);
        map.put("MaxIdleTimeoutInMinutes", MAX_IDLE_TIMEOUT_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdleSettings, T> g) {
        return obj -> g.apply((IdleSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lifecycleManagement;
        private Integer idleTimeoutInMinutes;
        private Integer minIdleTimeoutInMinutes;
        private Integer maxIdleTimeoutInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(IdleSettings model) {
            this.lifecycleManagement(model.lifecycleManagement);
            this.idleTimeoutInMinutes(model.idleTimeoutInMinutes);
            this.minIdleTimeoutInMinutes(model.minIdleTimeoutInMinutes);
            this.maxIdleTimeoutInMinutes(model.maxIdleTimeoutInMinutes);
        }

        public final String getLifecycleManagement() {
            return this.lifecycleManagement;
        }

        public final void setLifecycleManagement(String lifecycleManagement) {
            this.lifecycleManagement = lifecycleManagement;
        }

        @Override
        public final Builder lifecycleManagement(String lifecycleManagement) {
            this.lifecycleManagement = lifecycleManagement;
            return this;
        }

        @Override
        public final Builder lifecycleManagement(LifecycleManagement lifecycleManagement) {
            this.lifecycleManagement(lifecycleManagement == null ? null : lifecycleManagement.toString());
            return this;
        }

        public final Integer getIdleTimeoutInMinutes() {
            return this.idleTimeoutInMinutes;
        }

        public final void setIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
            this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        }

        @Override
        public final Builder idleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
            this.idleTimeoutInMinutes = idleTimeoutInMinutes;
            return this;
        }

        public final Integer getMinIdleTimeoutInMinutes() {
            return this.minIdleTimeoutInMinutes;
        }

        public final void setMinIdleTimeoutInMinutes(Integer minIdleTimeoutInMinutes) {
            this.minIdleTimeoutInMinutes = minIdleTimeoutInMinutes;
        }

        @Override
        public final Builder minIdleTimeoutInMinutes(Integer minIdleTimeoutInMinutes) {
            this.minIdleTimeoutInMinutes = minIdleTimeoutInMinutes;
            return this;
        }

        public final Integer getMaxIdleTimeoutInMinutes() {
            return this.maxIdleTimeoutInMinutes;
        }

        public final void setMaxIdleTimeoutInMinutes(Integer maxIdleTimeoutInMinutes) {
            this.maxIdleTimeoutInMinutes = maxIdleTimeoutInMinutes;
        }

        @Override
        public final Builder maxIdleTimeoutInMinutes(Integer maxIdleTimeoutInMinutes) {
            this.maxIdleTimeoutInMinutes = maxIdleTimeoutInMinutes;
            return this;
        }

        public IdleSettings build() {
            return new IdleSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdleSettings> {
        public Builder lifecycleManagement(String var1);

        public Builder lifecycleManagement(LifecycleManagement var1);

        public Builder idleTimeoutInMinutes(Integer var1);

        public Builder minIdleTimeoutInMinutes(Integer var1);

        public Builder maxIdleTimeoutInMinutes(Integer var1);
    }
}

