/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.IsTrackingServerActive;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.TrackingServerMaintenanceStatus;
import software.amazon.awssdk.services.sagemaker.model.TrackingServerSize;
import software.amazon.awssdk.services.sagemaker.model.TrackingServerStatus;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMlflowTrackingServerResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeMlflowTrackingServerResponse> {
    private static final SdkField<String> TRACKING_SERVER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackingServerArn").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::trackingServerArn)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::trackingServerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerArn").build()}).build();
    private static final SdkField<String> TRACKING_SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackingServerName").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::trackingServerName)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::trackingServerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerName").build()}).build();
    private static final SdkField<String> ARTIFACT_STORE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactStoreUri").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::artifactStoreUri)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::artifactStoreUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactStoreUri").build()}).build();
    private static final SdkField<String> TRACKING_SERVER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackingServerSize").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::trackingServerSizeAsString)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::trackingServerSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerSize").build()}).build();
    private static final SdkField<String> MLFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MlflowVersion").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::mlflowVersion)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::mlflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlflowVersion").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::roleArn)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> TRACKING_SERVER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackingServerStatus").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::trackingServerStatusAsString)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::trackingServerStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerStatus").build()}).build();
    private static final SdkField<String> TRACKING_SERVER_MAINTENANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackingServerMaintenanceStatus").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::trackingServerMaintenanceStatusAsString)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::trackingServerMaintenanceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerMaintenanceStatus").build()}).build();
    private static final SdkField<String> IS_ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IsActive").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::isActiveAsString)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::isActive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsActive").build()}).build();
    private static final SdkField<String> TRACKING_SERVER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackingServerUrl").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::trackingServerUrl)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::trackingServerUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerUrl").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceWindowStart").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::weeklyMaintenanceWindowStart)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::weeklyMaintenanceWindowStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart").build()}).build();
    private static final SdkField<Boolean> AUTOMATIC_MODEL_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutomaticModelRegistration").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::automaticModelRegistration)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::automaticModelRegistration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticModelRegistration").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::creationTime)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::createdBy)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::lastModifiedTime)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedBy").getter(DescribeMlflowTrackingServerResponse.getter(DescribeMlflowTrackingServerResponse::lastModifiedBy)).setter(DescribeMlflowTrackingServerResponse.setter(Builder::lastModifiedBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_SERVER_ARN_FIELD, TRACKING_SERVER_NAME_FIELD, ARTIFACT_STORE_URI_FIELD, TRACKING_SERVER_SIZE_FIELD, MLFLOW_VERSION_FIELD, ROLE_ARN_FIELD, TRACKING_SERVER_STATUS_FIELD, TRACKING_SERVER_MAINTENANCE_STATUS_FIELD, IS_ACTIVE_FIELD, TRACKING_SERVER_URL_FIELD, WEEKLY_MAINTENANCE_WINDOW_START_FIELD, AUTOMATIC_MODEL_REGISTRATION_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMlflowTrackingServerResponse.memberNameToFieldInitializer();
    private final String trackingServerArn;
    private final String trackingServerName;
    private final String artifactStoreUri;
    private final String trackingServerSize;
    private final String mlflowVersion;
    private final String roleArn;
    private final String trackingServerStatus;
    private final String trackingServerMaintenanceStatus;
    private final String isActive;
    private final String trackingServerUrl;
    private final String weeklyMaintenanceWindowStart;
    private final Boolean automaticModelRegistration;
    private final Instant creationTime;
    private final UserContext createdBy;
    private final Instant lastModifiedTime;
    private final UserContext lastModifiedBy;

    private DescribeMlflowTrackingServerResponse(BuilderImpl builder) {
        super(builder);
        this.trackingServerArn = builder.trackingServerArn;
        this.trackingServerName = builder.trackingServerName;
        this.artifactStoreUri = builder.artifactStoreUri;
        this.trackingServerSize = builder.trackingServerSize;
        this.mlflowVersion = builder.mlflowVersion;
        this.roleArn = builder.roleArn;
        this.trackingServerStatus = builder.trackingServerStatus;
        this.trackingServerMaintenanceStatus = builder.trackingServerMaintenanceStatus;
        this.isActive = builder.isActive;
        this.trackingServerUrl = builder.trackingServerUrl;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
        this.automaticModelRegistration = builder.automaticModelRegistration;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
    }

    public final String trackingServerArn() {
        return this.trackingServerArn;
    }

    public final String trackingServerName() {
        return this.trackingServerName;
    }

    public final String artifactStoreUri() {
        return this.artifactStoreUri;
    }

    public final TrackingServerSize trackingServerSize() {
        return TrackingServerSize.fromValue(this.trackingServerSize);
    }

    public final String trackingServerSizeAsString() {
        return this.trackingServerSize;
    }

    public final String mlflowVersion() {
        return this.mlflowVersion;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final TrackingServerStatus trackingServerStatus() {
        return TrackingServerStatus.fromValue(this.trackingServerStatus);
    }

    public final String trackingServerStatusAsString() {
        return this.trackingServerStatus;
    }

    public final TrackingServerMaintenanceStatus trackingServerMaintenanceStatus() {
        return TrackingServerMaintenanceStatus.fromValue(this.trackingServerMaintenanceStatus);
    }

    public final String trackingServerMaintenanceStatusAsString() {
        return this.trackingServerMaintenanceStatus;
    }

    public final IsTrackingServerActive isActive() {
        return IsTrackingServerActive.fromValue(this.isActive);
    }

    public final String isActiveAsString() {
        return this.isActive;
    }

    public final String trackingServerUrl() {
        return this.trackingServerUrl;
    }

    public final String weeklyMaintenanceWindowStart() {
        return this.weeklyMaintenanceWindowStart;
    }

    public final Boolean automaticModelRegistration() {
        return this.automaticModelRegistration;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final UserContext lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingServerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingServerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactStoreUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingServerSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingServerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingServerMaintenanceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isActiveAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingServerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticModelRegistration());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMlflowTrackingServerResponse)) {
            return false;
        }
        DescribeMlflowTrackingServerResponse other = (DescribeMlflowTrackingServerResponse)((Object)obj);
        return Objects.equals(this.trackingServerArn(), other.trackingServerArn()) && Objects.equals(this.trackingServerName(), other.trackingServerName()) && Objects.equals(this.artifactStoreUri(), other.artifactStoreUri()) && Objects.equals(this.trackingServerSizeAsString(), other.trackingServerSizeAsString()) && Objects.equals(this.mlflowVersion(), other.mlflowVersion()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.trackingServerStatusAsString(), other.trackingServerStatusAsString()) && Objects.equals(this.trackingServerMaintenanceStatusAsString(), other.trackingServerMaintenanceStatusAsString()) && Objects.equals(this.isActiveAsString(), other.isActiveAsString()) && Objects.equals(this.trackingServerUrl(), other.trackingServerUrl()) && Objects.equals(this.weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart()) && Objects.equals(this.automaticModelRegistration(), other.automaticModelRegistration()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMlflowTrackingServerResponse").add("TrackingServerArn", (Object)this.trackingServerArn()).add("TrackingServerName", (Object)this.trackingServerName()).add("ArtifactStoreUri", (Object)this.artifactStoreUri()).add("TrackingServerSize", (Object)this.trackingServerSizeAsString()).add("MlflowVersion", (Object)this.mlflowVersion()).add("RoleArn", (Object)this.roleArn()).add("TrackingServerStatus", (Object)this.trackingServerStatusAsString()).add("TrackingServerMaintenanceStatus", (Object)this.trackingServerMaintenanceStatusAsString()).add("IsActive", (Object)this.isActiveAsString()).add("TrackingServerUrl", (Object)this.trackingServerUrl()).add("WeeklyMaintenanceWindowStart", (Object)this.weeklyMaintenanceWindowStart()).add("AutomaticModelRegistration", (Object)this.automaticModelRegistration()).add("CreationTime", (Object)this.creationTime()).add("CreatedBy", (Object)this.createdBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrackingServerArn": {
                return Optional.ofNullable(clazz.cast(this.trackingServerArn()));
            }
            case "TrackingServerName": {
                return Optional.ofNullable(clazz.cast(this.trackingServerName()));
            }
            case "ArtifactStoreUri": {
                return Optional.ofNullable(clazz.cast(this.artifactStoreUri()));
            }
            case "TrackingServerSize": {
                return Optional.ofNullable(clazz.cast(this.trackingServerSizeAsString()));
            }
            case "MlflowVersion": {
                return Optional.ofNullable(clazz.cast(this.mlflowVersion()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "TrackingServerStatus": {
                return Optional.ofNullable(clazz.cast(this.trackingServerStatusAsString()));
            }
            case "TrackingServerMaintenanceStatus": {
                return Optional.ofNullable(clazz.cast(this.trackingServerMaintenanceStatusAsString()));
            }
            case "IsActive": {
                return Optional.ofNullable(clazz.cast(this.isActiveAsString()));
            }
            case "TrackingServerUrl": {
                return Optional.ofNullable(clazz.cast(this.trackingServerUrl()));
            }
            case "WeeklyMaintenanceWindowStart": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceWindowStart()));
            }
            case "AutomaticModelRegistration": {
                return Optional.ofNullable(clazz.cast(this.automaticModelRegistration()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrackingServerArn", TRACKING_SERVER_ARN_FIELD);
        map.put("TrackingServerName", TRACKING_SERVER_NAME_FIELD);
        map.put("ArtifactStoreUri", ARTIFACT_STORE_URI_FIELD);
        map.put("TrackingServerSize", TRACKING_SERVER_SIZE_FIELD);
        map.put("MlflowVersion", MLFLOW_VERSION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("TrackingServerStatus", TRACKING_SERVER_STATUS_FIELD);
        map.put("TrackingServerMaintenanceStatus", TRACKING_SERVER_MAINTENANCE_STATUS_FIELD);
        map.put("IsActive", IS_ACTIVE_FIELD);
        map.put("TrackingServerUrl", TRACKING_SERVER_URL_FIELD);
        map.put("WeeklyMaintenanceWindowStart", WEEKLY_MAINTENANCE_WINDOW_START_FIELD);
        map.put("AutomaticModelRegistration", AUTOMATIC_MODEL_REGISTRATION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMlflowTrackingServerResponse, T> g) {
        return obj -> g.apply((DescribeMlflowTrackingServerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String trackingServerArn;
        private String trackingServerName;
        private String artifactStoreUri;
        private String trackingServerSize;
        private String mlflowVersion;
        private String roleArn;
        private String trackingServerStatus;
        private String trackingServerMaintenanceStatus;
        private String isActive;
        private String trackingServerUrl;
        private String weeklyMaintenanceWindowStart;
        private Boolean automaticModelRegistration;
        private Instant creationTime;
        private UserContext createdBy;
        private Instant lastModifiedTime;
        private UserContext lastModifiedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMlflowTrackingServerResponse model) {
            super(model);
            this.trackingServerArn(model.trackingServerArn);
            this.trackingServerName(model.trackingServerName);
            this.artifactStoreUri(model.artifactStoreUri);
            this.trackingServerSize(model.trackingServerSize);
            this.mlflowVersion(model.mlflowVersion);
            this.roleArn(model.roleArn);
            this.trackingServerStatus(model.trackingServerStatus);
            this.trackingServerMaintenanceStatus(model.trackingServerMaintenanceStatus);
            this.isActive(model.isActive);
            this.trackingServerUrl(model.trackingServerUrl);
            this.weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
            this.automaticModelRegistration(model.automaticModelRegistration);
            this.creationTime(model.creationTime);
            this.createdBy(model.createdBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedBy(model.lastModifiedBy);
        }

        public final String getTrackingServerArn() {
            return this.trackingServerArn;
        }

        public final void setTrackingServerArn(String trackingServerArn) {
            this.trackingServerArn = trackingServerArn;
        }

        @Override
        public final Builder trackingServerArn(String trackingServerArn) {
            this.trackingServerArn = trackingServerArn;
            return this;
        }

        public final String getTrackingServerName() {
            return this.trackingServerName;
        }

        public final void setTrackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
        }

        @Override
        public final Builder trackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
            return this;
        }

        public final String getArtifactStoreUri() {
            return this.artifactStoreUri;
        }

        public final void setArtifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
        }

        @Override
        public final Builder artifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
            return this;
        }

        public final String getTrackingServerSize() {
            return this.trackingServerSize;
        }

        public final void setTrackingServerSize(String trackingServerSize) {
            this.trackingServerSize = trackingServerSize;
        }

        @Override
        public final Builder trackingServerSize(String trackingServerSize) {
            this.trackingServerSize = trackingServerSize;
            return this;
        }

        @Override
        public final Builder trackingServerSize(TrackingServerSize trackingServerSize) {
            this.trackingServerSize(trackingServerSize == null ? null : trackingServerSize.toString());
            return this;
        }

        public final String getMlflowVersion() {
            return this.mlflowVersion;
        }

        public final void setMlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
        }

        @Override
        public final Builder mlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getTrackingServerStatus() {
            return this.trackingServerStatus;
        }

        public final void setTrackingServerStatus(String trackingServerStatus) {
            this.trackingServerStatus = trackingServerStatus;
        }

        @Override
        public final Builder trackingServerStatus(String trackingServerStatus) {
            this.trackingServerStatus = trackingServerStatus;
            return this;
        }

        @Override
        public final Builder trackingServerStatus(TrackingServerStatus trackingServerStatus) {
            this.trackingServerStatus(trackingServerStatus == null ? null : trackingServerStatus.toString());
            return this;
        }

        public final String getTrackingServerMaintenanceStatus() {
            return this.trackingServerMaintenanceStatus;
        }

        public final void setTrackingServerMaintenanceStatus(String trackingServerMaintenanceStatus) {
            this.trackingServerMaintenanceStatus = trackingServerMaintenanceStatus;
        }

        @Override
        public final Builder trackingServerMaintenanceStatus(String trackingServerMaintenanceStatus) {
            this.trackingServerMaintenanceStatus = trackingServerMaintenanceStatus;
            return this;
        }

        @Override
        public final Builder trackingServerMaintenanceStatus(TrackingServerMaintenanceStatus trackingServerMaintenanceStatus) {
            this.trackingServerMaintenanceStatus(trackingServerMaintenanceStatus == null ? null : trackingServerMaintenanceStatus.toString());
            return this;
        }

        public final String getIsActive() {
            return this.isActive;
        }

        public final void setIsActive(String isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(String isActive) {
            this.isActive = isActive;
            return this;
        }

        @Override
        public final Builder isActive(IsTrackingServerActive isActive) {
            this.isActive(isActive == null ? null : isActive.toString());
            return this;
        }

        public final String getTrackingServerUrl() {
            return this.trackingServerUrl;
        }

        public final void setTrackingServerUrl(String trackingServerUrl) {
            this.trackingServerUrl = trackingServerUrl;
        }

        @Override
        public final Builder trackingServerUrl(String trackingServerUrl) {
            this.trackingServerUrl = trackingServerUrl;
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return this.weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        public final Boolean getAutomaticModelRegistration() {
            return this.automaticModelRegistration;
        }

        public final void setAutomaticModelRegistration(Boolean automaticModelRegistration) {
            this.automaticModelRegistration = automaticModelRegistration;
        }

        @Override
        public final Builder automaticModelRegistration(Boolean automaticModelRegistration) {
            this.automaticModelRegistration = automaticModelRegistration;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return this.lastModifiedBy != null ? this.lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        @Override
        public DescribeMlflowTrackingServerResponse build() {
            return new DescribeMlflowTrackingServerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMlflowTrackingServerResponse> {
        public Builder trackingServerArn(String var1);

        public Builder trackingServerName(String var1);

        public Builder artifactStoreUri(String var1);

        public Builder trackingServerSize(String var1);

        public Builder trackingServerSize(TrackingServerSize var1);

        public Builder mlflowVersion(String var1);

        public Builder roleArn(String var1);

        public Builder trackingServerStatus(String var1);

        public Builder trackingServerStatus(TrackingServerStatus var1);

        public Builder trackingServerMaintenanceStatus(String var1);

        public Builder trackingServerMaintenanceStatus(TrackingServerMaintenanceStatus var1);

        public Builder isActive(String var1);

        public Builder isActive(IsTrackingServerActive var1);

        public Builder trackingServerUrl(String var1);

        public Builder weeklyMaintenanceWindowStart(String var1);

        public Builder automaticModelRegistration(Boolean var1);

        public Builder creationTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedBy(UserContext var1);

        default public Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return this.lastModifiedBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(lastModifiedBy)).build());
        }
    }
}

