/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceCatalog
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceCatalog> {
    private static final SdkField<String> RESOURCE_CATALOG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceCatalogArn").getter(ResourceCatalog.getter(ResourceCatalog::resourceCatalogArn)).setter(ResourceCatalog.setter(Builder::resourceCatalogArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCatalogArn").build()}).build();
    private static final SdkField<String> RESOURCE_CATALOG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceCatalogName").getter(ResourceCatalog.getter(ResourceCatalog::resourceCatalogName)).setter(ResourceCatalog.setter(Builder::resourceCatalogName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCatalogName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ResourceCatalog.getter(ResourceCatalog::description)).setter(ResourceCatalog.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ResourceCatalog.getter(ResourceCatalog::creationTime)).setter(ResourceCatalog.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_CATALOG_ARN_FIELD, RESOURCE_CATALOG_NAME_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceCatalog.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceCatalogArn;
    private final String resourceCatalogName;
    private final String description;
    private final Instant creationTime;

    private ResourceCatalog(BuilderImpl builder) {
        this.resourceCatalogArn = builder.resourceCatalogArn;
        this.resourceCatalogName = builder.resourceCatalogName;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
    }

    public final String resourceCatalogArn() {
        return this.resourceCatalogArn;
    }

    public final String resourceCatalogName() {
        return this.resourceCatalogName;
    }

    public final String description() {
        return this.description;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCatalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCatalogName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCatalog)) {
            return false;
        }
        ResourceCatalog other = (ResourceCatalog)obj;
        return Objects.equals(this.resourceCatalogArn(), other.resourceCatalogArn()) && Objects.equals(this.resourceCatalogName(), other.resourceCatalogName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceCatalog").add("ResourceCatalogArn", (Object)this.resourceCatalogArn()).add("ResourceCatalogName", (Object)this.resourceCatalogName()).add("Description", (Object)this.description()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceCatalogArn": {
                return Optional.ofNullable(clazz.cast(this.resourceCatalogArn()));
            }
            case "ResourceCatalogName": {
                return Optional.ofNullable(clazz.cast(this.resourceCatalogName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceCatalogArn", RESOURCE_CATALOG_ARN_FIELD);
        map.put("ResourceCatalogName", RESOURCE_CATALOG_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceCatalog, T> g) {
        return obj -> g.apply((ResourceCatalog)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceCatalogArn;
        private String resourceCatalogName;
        private String description;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceCatalog model) {
            this.resourceCatalogArn(model.resourceCatalogArn);
            this.resourceCatalogName(model.resourceCatalogName);
            this.description(model.description);
            this.creationTime(model.creationTime);
        }

        public final String getResourceCatalogArn() {
            return this.resourceCatalogArn;
        }

        public final void setResourceCatalogArn(String resourceCatalogArn) {
            this.resourceCatalogArn = resourceCatalogArn;
        }

        @Override
        public final Builder resourceCatalogArn(String resourceCatalogArn) {
            this.resourceCatalogArn = resourceCatalogArn;
            return this;
        }

        public final String getResourceCatalogName() {
            return this.resourceCatalogName;
        }

        public final void setResourceCatalogName(String resourceCatalogName) {
            this.resourceCatalogName = resourceCatalogName;
        }

        @Override
        public final Builder resourceCatalogName(String resourceCatalogName) {
            this.resourceCatalogName = resourceCatalogName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public ResourceCatalog build() {
            return new ResourceCatalog(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceCatalog> {
        public Builder resourceCatalogArn(String var1);

        public Builder resourceCatalogName(String var1);

        public Builder description(String var1);

        public Builder creationTime(Instant var1);
    }
}

