/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrainingPlanRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, DescribeTrainingPlanRequest> {
    private static final SdkField<String> TRAINING_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingPlanName").getter(DescribeTrainingPlanRequest.getter(DescribeTrainingPlanRequest::trainingPlanName)).setter(DescribeTrainingPlanRequest.setter(Builder::trainingPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_PLAN_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTrainingPlanRequest.memberNameToFieldInitializer();
    private final String trainingPlanName;

    private DescribeTrainingPlanRequest(BuilderImpl builder) {
        super(builder);
        this.trainingPlanName = builder.trainingPlanName;
    }

    public final String trainingPlanName() {
        return this.trainingPlanName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingPlanName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrainingPlanRequest)) {
            return false;
        }
        DescribeTrainingPlanRequest other = (DescribeTrainingPlanRequest)((Object)obj);
        return Objects.equals(this.trainingPlanName(), other.trainingPlanName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTrainingPlanRequest").add("TrainingPlanName", (Object)this.trainingPlanName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingPlanName": {
                return Optional.ofNullable(clazz.cast(this.trainingPlanName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TrainingPlanName", TRAINING_PLAN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrainingPlanRequest, T> g) {
        return obj -> g.apply((DescribeTrainingPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String trainingPlanName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrainingPlanRequest model) {
            super(model);
            this.trainingPlanName(model.trainingPlanName);
        }

        public final String getTrainingPlanName() {
            return this.trainingPlanName;
        }

        public final void setTrainingPlanName(String trainingPlanName) {
            this.trainingPlanName = trainingPlanName;
        }

        @Override
        public final Builder trainingPlanName(String trainingPlanName) {
            this.trainingPlanName = trainingPlanName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTrainingPlanRequest build() {
            return new DescribeTrainingPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrainingPlanRequest> {
        public Builder trainingPlanName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

