/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CognitoConfig;
import software.amazon.awssdk.services.sagemaker.model.OidcConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SourceIpConfig;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.WorkforceVpcConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkforceRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateWorkforceRequest> {
    private static final SdkField<CognitoConfig> COGNITO_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CognitoConfig").getter(CreateWorkforceRequest.getter(CreateWorkforceRequest::cognitoConfig)).setter(CreateWorkforceRequest.setter(Builder::cognitoConfig)).constructor(CognitoConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoConfig").build()}).build();
    private static final SdkField<OidcConfig> OIDC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OidcConfig").getter(CreateWorkforceRequest.getter(CreateWorkforceRequest::oidcConfig)).setter(CreateWorkforceRequest.setter(Builder::oidcConfig)).constructor(OidcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcConfig").build()}).build();
    private static final SdkField<SourceIpConfig> SOURCE_IP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceIpConfig").getter(CreateWorkforceRequest.getter(CreateWorkforceRequest::sourceIpConfig)).setter(CreateWorkforceRequest.setter(Builder::sourceIpConfig)).constructor(SourceIpConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpConfig").build()}).build();
    private static final SdkField<String> WORKFORCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkforceName").getter(CreateWorkforceRequest.getter(CreateWorkforceRequest::workforceName)).setter(CreateWorkforceRequest.setter(Builder::workforceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateWorkforceRequest.getter(CreateWorkforceRequest::tags)).setter(CreateWorkforceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<WorkforceVpcConfigRequest> WORKFORCE_VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkforceVpcConfig").getter(CreateWorkforceRequest.getter(CreateWorkforceRequest::workforceVpcConfig)).setter(CreateWorkforceRequest.setter(Builder::workforceVpcConfig)).constructor(WorkforceVpcConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceVpcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COGNITO_CONFIG_FIELD, OIDC_CONFIG_FIELD, SOURCE_IP_CONFIG_FIELD, WORKFORCE_NAME_FIELD, TAGS_FIELD, WORKFORCE_VPC_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWorkforceRequest.memberNameToFieldInitializer();
    private final CognitoConfig cognitoConfig;
    private final OidcConfig oidcConfig;
    private final SourceIpConfig sourceIpConfig;
    private final String workforceName;
    private final List<Tag> tags;
    private final WorkforceVpcConfigRequest workforceVpcConfig;

    private CreateWorkforceRequest(BuilderImpl builder) {
        super(builder);
        this.cognitoConfig = builder.cognitoConfig;
        this.oidcConfig = builder.oidcConfig;
        this.sourceIpConfig = builder.sourceIpConfig;
        this.workforceName = builder.workforceName;
        this.tags = builder.tags;
        this.workforceVpcConfig = builder.workforceVpcConfig;
    }

    public final CognitoConfig cognitoConfig() {
        return this.cognitoConfig;
    }

    public final OidcConfig oidcConfig() {
        return this.oidcConfig;
    }

    public final SourceIpConfig sourceIpConfig() {
        return this.sourceIpConfig;
    }

    public final String workforceName() {
        return this.workforceName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final WorkforceVpcConfigRequest workforceVpcConfig() {
        return this.workforceVpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.oidcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.workforceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workforceVpcConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkforceRequest)) {
            return false;
        }
        CreateWorkforceRequest other = (CreateWorkforceRequest)((Object)obj);
        return Objects.equals(this.cognitoConfig(), other.cognitoConfig()) && Objects.equals(this.oidcConfig(), other.oidcConfig()) && Objects.equals(this.sourceIpConfig(), other.sourceIpConfig()) && Objects.equals(this.workforceName(), other.workforceName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.workforceVpcConfig(), other.workforceVpcConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkforceRequest").add("CognitoConfig", (Object)this.cognitoConfig()).add("OidcConfig", (Object)this.oidcConfig()).add("SourceIpConfig", (Object)this.sourceIpConfig()).add("WorkforceName", (Object)this.workforceName()).add("Tags", this.hasTags() ? this.tags() : null).add("WorkforceVpcConfig", (Object)this.workforceVpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CognitoConfig": {
                return Optional.ofNullable(clazz.cast(this.cognitoConfig()));
            }
            case "OidcConfig": {
                return Optional.ofNullable(clazz.cast(this.oidcConfig()));
            }
            case "SourceIpConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceIpConfig()));
            }
            case "WorkforceName": {
                return Optional.ofNullable(clazz.cast(this.workforceName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "WorkforceVpcConfig": {
                return Optional.ofNullable(clazz.cast(this.workforceVpcConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CognitoConfig", COGNITO_CONFIG_FIELD);
        map.put("OidcConfig", OIDC_CONFIG_FIELD);
        map.put("SourceIpConfig", SOURCE_IP_CONFIG_FIELD);
        map.put("WorkforceName", WORKFORCE_NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("WorkforceVpcConfig", WORKFORCE_VPC_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkforceRequest, T> g) {
        return obj -> g.apply((CreateWorkforceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private CognitoConfig cognitoConfig;
        private OidcConfig oidcConfig;
        private SourceIpConfig sourceIpConfig;
        private String workforceName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private WorkforceVpcConfigRequest workforceVpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkforceRequest model) {
            super(model);
            this.cognitoConfig(model.cognitoConfig);
            this.oidcConfig(model.oidcConfig);
            this.sourceIpConfig(model.sourceIpConfig);
            this.workforceName(model.workforceName);
            this.tags(model.tags);
            this.workforceVpcConfig(model.workforceVpcConfig);
        }

        public final CognitoConfig.Builder getCognitoConfig() {
            return this.cognitoConfig != null ? this.cognitoConfig.toBuilder() : null;
        }

        public final void setCognitoConfig(CognitoConfig.BuilderImpl cognitoConfig) {
            this.cognitoConfig = cognitoConfig != null ? cognitoConfig.build() : null;
        }

        @Override
        public final Builder cognitoConfig(CognitoConfig cognitoConfig) {
            this.cognitoConfig = cognitoConfig;
            return this;
        }

        public final OidcConfig.Builder getOidcConfig() {
            return this.oidcConfig != null ? this.oidcConfig.toBuilder() : null;
        }

        public final void setOidcConfig(OidcConfig.BuilderImpl oidcConfig) {
            this.oidcConfig = oidcConfig != null ? oidcConfig.build() : null;
        }

        @Override
        public final Builder oidcConfig(OidcConfig oidcConfig) {
            this.oidcConfig = oidcConfig;
            return this;
        }

        public final SourceIpConfig.Builder getSourceIpConfig() {
            return this.sourceIpConfig != null ? this.sourceIpConfig.toBuilder() : null;
        }

        public final void setSourceIpConfig(SourceIpConfig.BuilderImpl sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig != null ? sourceIpConfig.build() : null;
        }

        @Override
        public final Builder sourceIpConfig(SourceIpConfig sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig;
            return this;
        }

        public final String getWorkforceName() {
            return this.workforceName;
        }

        public final void setWorkforceName(String workforceName) {
            this.workforceName = workforceName;
        }

        @Override
        public final Builder workforceName(String workforceName) {
            this.workforceName = workforceName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final WorkforceVpcConfigRequest.Builder getWorkforceVpcConfig() {
            return this.workforceVpcConfig != null ? this.workforceVpcConfig.toBuilder() : null;
        }

        public final void setWorkforceVpcConfig(WorkforceVpcConfigRequest.BuilderImpl workforceVpcConfig) {
            this.workforceVpcConfig = workforceVpcConfig != null ? workforceVpcConfig.build() : null;
        }

        @Override
        public final Builder workforceVpcConfig(WorkforceVpcConfigRequest workforceVpcConfig) {
            this.workforceVpcConfig = workforceVpcConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkforceRequest build() {
            return new CreateWorkforceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkforceRequest> {
        public Builder cognitoConfig(CognitoConfig var1);

        default public Builder cognitoConfig(Consumer<CognitoConfig.Builder> cognitoConfig) {
            return this.cognitoConfig((CognitoConfig)((CognitoConfig.Builder)CognitoConfig.builder().applyMutation(cognitoConfig)).build());
        }

        public Builder oidcConfig(OidcConfig var1);

        default public Builder oidcConfig(Consumer<OidcConfig.Builder> oidcConfig) {
            return this.oidcConfig((OidcConfig)((OidcConfig.Builder)OidcConfig.builder().applyMutation(oidcConfig)).build());
        }

        public Builder sourceIpConfig(SourceIpConfig var1);

        default public Builder sourceIpConfig(Consumer<SourceIpConfig.Builder> sourceIpConfig) {
            return this.sourceIpConfig((SourceIpConfig)((SourceIpConfig.Builder)SourceIpConfig.builder().applyMutation(sourceIpConfig)).build());
        }

        public Builder workforceName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder workforceVpcConfig(WorkforceVpcConfigRequest var1);

        default public Builder workforceVpcConfig(Consumer<WorkforceVpcConfigRequest.Builder> workforceVpcConfig) {
            return this.workforceVpcConfig((WorkforceVpcConfigRequest)((WorkforceVpcConfigRequest.Builder)WorkforceVpcConfigRequest.builder().applyMutation(workforceVpcConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

