/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.WarmPoolResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WarmPoolStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WarmPoolStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(WarmPoolStatus.getter(WarmPoolStatus::statusAsString)).setter(WarmPoolStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> RESOURCE_RETAINED_BILLABLE_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResourceRetainedBillableTimeInSeconds").getter(WarmPoolStatus.getter(WarmPoolStatus::resourceRetainedBillableTimeInSeconds)).setter(WarmPoolStatus.setter(Builder::resourceRetainedBillableTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRetainedBillableTimeInSeconds").build()}).build();
    private static final SdkField<String> REUSED_BY_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReusedByJob").getter(WarmPoolStatus.getter(WarmPoolStatus::reusedByJob)).setter(WarmPoolStatus.setter(Builder::reusedByJob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReusedByJob").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, RESOURCE_RETAINED_BILLABLE_TIME_IN_SECONDS_FIELD, REUSED_BY_JOB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WarmPoolStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Integer resourceRetainedBillableTimeInSeconds;
    private final String reusedByJob;

    private WarmPoolStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.resourceRetainedBillableTimeInSeconds = builder.resourceRetainedBillableTimeInSeconds;
        this.reusedByJob = builder.reusedByJob;
    }

    public final WarmPoolResourceStatus status() {
        return WarmPoolResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer resourceRetainedBillableTimeInSeconds() {
        return this.resourceRetainedBillableTimeInSeconds;
    }

    public final String reusedByJob() {
        return this.reusedByJob;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRetainedBillableTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.reusedByJob());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WarmPoolStatus)) {
            return false;
        }
        WarmPoolStatus other = (WarmPoolStatus)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.resourceRetainedBillableTimeInSeconds(), other.resourceRetainedBillableTimeInSeconds()) && Objects.equals(this.reusedByJob(), other.reusedByJob());
    }

    public final String toString() {
        return ToString.builder((String)"WarmPoolStatus").add("Status", (Object)this.statusAsString()).add("ResourceRetainedBillableTimeInSeconds", (Object)this.resourceRetainedBillableTimeInSeconds()).add("ReusedByJob", (Object)this.reusedByJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ResourceRetainedBillableTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.resourceRetainedBillableTimeInSeconds()));
            }
            case "ReusedByJob": {
                return Optional.ofNullable(clazz.cast(this.reusedByJob()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("ResourceRetainedBillableTimeInSeconds", RESOURCE_RETAINED_BILLABLE_TIME_IN_SECONDS_FIELD);
        map.put("ReusedByJob", REUSED_BY_JOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WarmPoolStatus, T> g) {
        return obj -> g.apply((WarmPoolStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Integer resourceRetainedBillableTimeInSeconds;
        private String reusedByJob;

        private BuilderImpl() {
        }

        private BuilderImpl(WarmPoolStatus model) {
            this.status(model.status);
            this.resourceRetainedBillableTimeInSeconds(model.resourceRetainedBillableTimeInSeconds);
            this.reusedByJob(model.reusedByJob);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WarmPoolResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getResourceRetainedBillableTimeInSeconds() {
            return this.resourceRetainedBillableTimeInSeconds;
        }

        public final void setResourceRetainedBillableTimeInSeconds(Integer resourceRetainedBillableTimeInSeconds) {
            this.resourceRetainedBillableTimeInSeconds = resourceRetainedBillableTimeInSeconds;
        }

        @Override
        public final Builder resourceRetainedBillableTimeInSeconds(Integer resourceRetainedBillableTimeInSeconds) {
            this.resourceRetainedBillableTimeInSeconds = resourceRetainedBillableTimeInSeconds;
            return this;
        }

        public final String getReusedByJob() {
            return this.reusedByJob;
        }

        public final void setReusedByJob(String reusedByJob) {
            this.reusedByJob = reusedByJob;
        }

        @Override
        public final Builder reusedByJob(String reusedByJob) {
            this.reusedByJob = reusedByJob;
            return this;
        }

        public WarmPoolStatus build() {
            return new WarmPoolStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WarmPoolStatus> {
        public Builder status(String var1);

        public Builder status(WarmPoolResourceStatus var1);

        public Builder resourceRetainedBillableTimeInSeconds(Integer var1);

        public Builder reusedByJob(String var1);
    }
}

