/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CapacityReservationPreference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductionVariantCapacityReservationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductionVariantCapacityReservationConfig> {
    private static final SdkField<String> CAPACITY_RESERVATION_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationPreference").getter(ProductionVariantCapacityReservationConfig.getter(ProductionVariantCapacityReservationConfig::capacityReservationPreferenceAsString)).setter(ProductionVariantCapacityReservationConfig.setter(Builder::capacityReservationPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationPreference").build()}).build();
    private static final SdkField<String> ML_RESERVATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MlReservationArn").getter(ProductionVariantCapacityReservationConfig.getter(ProductionVariantCapacityReservationConfig::mlReservationArn)).setter(ProductionVariantCapacityReservationConfig.setter(Builder::mlReservationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlReservationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_PREFERENCE_FIELD, ML_RESERVATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProductionVariantCapacityReservationConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityReservationPreference;
    private final String mlReservationArn;

    private ProductionVariantCapacityReservationConfig(BuilderImpl builder) {
        this.capacityReservationPreference = builder.capacityReservationPreference;
        this.mlReservationArn = builder.mlReservationArn;
    }

    public final CapacityReservationPreference capacityReservationPreference() {
        return CapacityReservationPreference.fromValue(this.capacityReservationPreference);
    }

    public final String capacityReservationPreferenceAsString() {
        return this.capacityReservationPreference;
    }

    public final String mlReservationArn() {
        return this.mlReservationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlReservationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantCapacityReservationConfig)) {
            return false;
        }
        ProductionVariantCapacityReservationConfig other = (ProductionVariantCapacityReservationConfig)obj;
        return Objects.equals(this.capacityReservationPreferenceAsString(), other.capacityReservationPreferenceAsString()) && Objects.equals(this.mlReservationArn(), other.mlReservationArn());
    }

    public final String toString() {
        return ToString.builder((String)"ProductionVariantCapacityReservationConfig").add("CapacityReservationPreference", (Object)this.capacityReservationPreferenceAsString()).add("MlReservationArn", (Object)this.mlReservationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservationPreference": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationPreferenceAsString()));
            }
            case "MlReservationArn": {
                return Optional.ofNullable(clazz.cast(this.mlReservationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CapacityReservationPreference", CAPACITY_RESERVATION_PREFERENCE_FIELD);
        map.put("MlReservationArn", ML_RESERVATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariantCapacityReservationConfig, T> g) {
        return obj -> g.apply((ProductionVariantCapacityReservationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityReservationPreference;
        private String mlReservationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariantCapacityReservationConfig model) {
            this.capacityReservationPreference(model.capacityReservationPreference);
            this.mlReservationArn(model.mlReservationArn);
        }

        public final String getCapacityReservationPreference() {
            return this.capacityReservationPreference;
        }

        public final void setCapacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
        }

        @Override
        public final Builder capacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
            return this;
        }

        @Override
        public final Builder capacityReservationPreference(CapacityReservationPreference capacityReservationPreference) {
            this.capacityReservationPreference(capacityReservationPreference == null ? null : capacityReservationPreference.toString());
            return this;
        }

        public final String getMlReservationArn() {
            return this.mlReservationArn;
        }

        public final void setMlReservationArn(String mlReservationArn) {
            this.mlReservationArn = mlReservationArn;
        }

        @Override
        public final Builder mlReservationArn(String mlReservationArn) {
            this.mlReservationArn = mlReservationArn;
            return this;
        }

        public ProductionVariantCapacityReservationConfig build() {
            return new ProductionVariantCapacityReservationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductionVariantCapacityReservationConfig> {
        public Builder capacityReservationPreference(String var1);

        public Builder capacityReservationPreference(CapacityReservationPreference var1);

        public Builder mlReservationArn(String var1);
    }
}

