/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperimentConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperimentConfig> {
    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExperimentName").getter(ExperimentConfig.getter(ExperimentConfig::experimentName)).setter(ExperimentConfig.setter(Builder::experimentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()}).build();
    private static final SdkField<String> TRIAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrialName").getter(ExperimentConfig.getter(ExperimentConfig::trialName)).setter(ExperimentConfig.setter(Builder::trialName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialName").build()}).build();
    private static final SdkField<String> TRIAL_COMPONENT_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrialComponentDisplayName").getter(ExperimentConfig.getter(ExperimentConfig::trialComponentDisplayName)).setter(ExperimentConfig.setter(Builder::trialComponentDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentDisplayName").build()}).build();
    private static final SdkField<String> RUN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunName").getter(ExperimentConfig.getter(ExperimentConfig::runName)).setter(ExperimentConfig.setter(Builder::runName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_NAME_FIELD, TRIAL_NAME_FIELD, TRIAL_COMPONENT_DISPLAY_NAME_FIELD, RUN_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExperimentConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String experimentName;
    private final String trialName;
    private final String trialComponentDisplayName;
    private final String runName;

    private ExperimentConfig(BuilderImpl builder) {
        this.experimentName = builder.experimentName;
        this.trialName = builder.trialName;
        this.trialComponentDisplayName = builder.trialComponentDisplayName;
        this.runName = builder.runName;
    }

    public final String experimentName() {
        return this.experimentName;
    }

    public final String trialName() {
        return this.trialName;
    }

    public final String trialComponentDisplayName() {
        return this.trialComponentDisplayName;
    }

    public final String runName() {
        return this.runName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponentDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.runName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentConfig)) {
            return false;
        }
        ExperimentConfig other = (ExperimentConfig)obj;
        return Objects.equals(this.experimentName(), other.experimentName()) && Objects.equals(this.trialName(), other.trialName()) && Objects.equals(this.trialComponentDisplayName(), other.trialComponentDisplayName()) && Objects.equals(this.runName(), other.runName());
    }

    public final String toString() {
        return ToString.builder((String)"ExperimentConfig").add("ExperimentName", (Object)this.experimentName()).add("TrialName", (Object)this.trialName()).add("TrialComponentDisplayName", (Object)this.trialComponentDisplayName()).add("RunName", (Object)this.runName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExperimentName": {
                return Optional.ofNullable(clazz.cast(this.experimentName()));
            }
            case "TrialName": {
                return Optional.ofNullable(clazz.cast(this.trialName()));
            }
            case "TrialComponentDisplayName": {
                return Optional.ofNullable(clazz.cast(this.trialComponentDisplayName()));
            }
            case "RunName": {
                return Optional.ofNullable(clazz.cast(this.runName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ExperimentName", EXPERIMENT_NAME_FIELD);
        map.put("TrialName", TRIAL_NAME_FIELD);
        map.put("TrialComponentDisplayName", TRIAL_COMPONENT_DISPLAY_NAME_FIELD);
        map.put("RunName", RUN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentConfig, T> g) {
        return obj -> g.apply((ExperimentConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String experimentName;
        private String trialName;
        private String trialComponentDisplayName;
        private String runName;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentConfig model) {
            this.experimentName(model.experimentName);
            this.trialName(model.trialName);
            this.trialComponentDisplayName(model.trialComponentDisplayName);
            this.runName(model.runName);
        }

        public final String getExperimentName() {
            return this.experimentName;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        @Override
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public final String getTrialName() {
            return this.trialName;
        }

        public final void setTrialName(String trialName) {
            this.trialName = trialName;
        }

        @Override
        public final Builder trialName(String trialName) {
            this.trialName = trialName;
            return this;
        }

        public final String getTrialComponentDisplayName() {
            return this.trialComponentDisplayName;
        }

        public final void setTrialComponentDisplayName(String trialComponentDisplayName) {
            this.trialComponentDisplayName = trialComponentDisplayName;
        }

        @Override
        public final Builder trialComponentDisplayName(String trialComponentDisplayName) {
            this.trialComponentDisplayName = trialComponentDisplayName;
            return this;
        }

        public final String getRunName() {
            return this.runName;
        }

        public final void setRunName(String runName) {
            this.runName = runName;
        }

        @Override
        public final Builder runName(String runName) {
            this.runName = runName;
            return this;
        }

        public ExperimentConfig build() {
            return new ExperimentConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperimentConfig> {
        public Builder experimentName(String var1);

        public Builder trialName(String var1);

        public Builder trialComponentDisplayName(String var1);

        public Builder runName(String var1);
    }
}

