/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePipelineDefinitionForExecutionResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribePipelineDefinitionForExecutionResponse> {
    private static final SdkField<String> PIPELINE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineDefinition").getter(DescribePipelineDefinitionForExecutionResponse.getter(DescribePipelineDefinitionForExecutionResponse::pipelineDefinition)).setter(DescribePipelineDefinitionForExecutionResponse.setter(Builder::pipelineDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDefinition").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribePipelineDefinitionForExecutionResponse.getter(DescribePipelineDefinitionForExecutionResponse::creationTime)).setter(DescribePipelineDefinitionForExecutionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_DEFINITION_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribePipelineDefinitionForExecutionResponse.memberNameToFieldInitializer();
    private final String pipelineDefinition;
    private final Instant creationTime;

    private DescribePipelineDefinitionForExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineDefinition = builder.pipelineDefinition;
        this.creationTime = builder.creationTime;
    }

    public final String pipelineDefinition() {
        return this.pipelineDefinition;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePipelineDefinitionForExecutionResponse)) {
            return false;
        }
        DescribePipelineDefinitionForExecutionResponse other = (DescribePipelineDefinitionForExecutionResponse)((Object)obj);
        return Objects.equals(this.pipelineDefinition(), other.pipelineDefinition()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePipelineDefinitionForExecutionResponse").add("PipelineDefinition", (Object)this.pipelineDefinition()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineDefinition": {
                return Optional.ofNullable(clazz.cast(this.pipelineDefinition()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PipelineDefinition", PIPELINE_DEFINITION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePipelineDefinitionForExecutionResponse, T> g) {
        return obj -> g.apply((DescribePipelineDefinitionForExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String pipelineDefinition;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePipelineDefinitionForExecutionResponse model) {
            super(model);
            this.pipelineDefinition(model.pipelineDefinition);
            this.creationTime(model.creationTime);
        }

        public final String getPipelineDefinition() {
            return this.pipelineDefinition;
        }

        public final void setPipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
        }

        @Override
        public final Builder pipelineDefinition(String pipelineDefinition) {
            this.pipelineDefinition = pipelineDefinition;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public DescribePipelineDefinitionForExecutionResponse build() {
            return new DescribePipelineDefinitionForExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePipelineDefinitionForExecutionResponse> {
        public Builder pipelineDefinition(String var1);

        public Builder creationTime(Instant var1);
    }
}

