/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.DeploymentConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledUpdateConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledUpdateConfig> {
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleExpression").getter(ScheduledUpdateConfig.getter(ScheduledUpdateConfig::scheduleExpression)).setter(ScheduledUpdateConfig.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build()}).build();
    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeploymentConfig").getter(ScheduledUpdateConfig.getter(ScheduledUpdateConfig::deploymentConfig)).setter(ScheduledUpdateConfig.setter(Builder::deploymentConfig)).constructor(DeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_EXPRESSION_FIELD, DEPLOYMENT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScheduledUpdateConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scheduleExpression;
    private final DeploymentConfiguration deploymentConfig;

    private ScheduledUpdateConfig(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
        this.deploymentConfig = builder.deploymentConfig;
    }

    public final String scheduleExpression() {
        return this.scheduleExpression;
    }

    public final DeploymentConfiguration deploymentConfig() {
        return this.deploymentConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledUpdateConfig)) {
            return false;
        }
        ScheduledUpdateConfig other = (ScheduledUpdateConfig)obj;
        return Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.deploymentConfig(), other.deploymentConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledUpdateConfig").add("ScheduleExpression", (Object)this.scheduleExpression()).add("DeploymentConfig", (Object)this.deploymentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "DeploymentConfig": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("DeploymentConfig", DEPLOYMENT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledUpdateConfig, T> g) {
        return obj -> g.apply((ScheduledUpdateConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scheduleExpression;
        private DeploymentConfiguration deploymentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledUpdateConfig model) {
            this.scheduleExpression(model.scheduleExpression);
            this.deploymentConfig(model.deploymentConfig);
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfig() {
            return this.deploymentConfig != null ? this.deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(DeploymentConfiguration.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        public final Builder deploymentConfig(DeploymentConfiguration deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        public ScheduledUpdateConfig build() {
            return new ScheduledUpdateConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledUpdateConfig> {
        public Builder scheduleExpression(String var1);

        public Builder deploymentConfig(DeploymentConfiguration var1);

        default public Builder deploymentConfig(Consumer<DeploymentConfiguration.Builder> deploymentConfig) {
            return this.deploymentConfig((DeploymentConfiguration)((DeploymentConfiguration.Builder)DeploymentConfiguration.builder().applyMutation(deploymentConfig)).build());
        }
    }
}

